--Replace all instances of IDCS_APP with your schema name
--Execute as SYSDBA user or appropriate permissions


SET DEFINE OFF;


CREATE  TYPE idcs_app.idcs_user_t   
    AS OBJECT (
      username      VARCHAR2(100),
      displayname   VARCHAR2(100),
      firstname     VARCHAR2(50),
      lastname      VARCHAR2(50),
      email         VARCHAR2(100)
    ); 
/


CREATE OR REPLACE PACKAGE IDCS_APP.IDCS_CLIENT as

  g_base_url    VARCHAR2(500):= 'https://democo.idcs.internal.oracle.com:8943';    -- Replace with IDCS Base URL
  g_client_id   VARCHAR2(100):='8105a4f266c745b09a7bbed42ff151eb';                 -- Replace with Client ID
  g_client_pwd  VARCHAR2(100):='a664583b-2115-4921-bd48-8e4a84b0c7a3';             -- Replace with Client Secret
  g_wallet_path VARCHAR2(200):= 'file:/home/oracle/wallet';                        -- Replace with DB Wallet location
  g_wallet_pwd  VARCHAR2(50):= 'Welcome1';                                         -- Replace with DB Wallet password
  g_users_uri   VARCHAR2(200):='/admin/v1/Users';
  g_groups_uri  VARCHAR2(200):='/admin/v1/Groups';


  g_bearer_token  VARCHAR2(32767);    -- Stores Access token
  
  -- Used to return a list of groups on function get_user_membership
  TYPE group_list_t    
    IS TABLE OF VARCHAR2(100);   
    
  --  Used to return list of users and their profiles
  TYPE user_list_t     
    IS TABLE OF idcs_user_t;
    
  -- Create the following TYPE outside of the package using SQLPLUS with SYSDBA account
  -- TYPE idcs_user_t is used to store a user's profile
  /*
  CREATE  TYPE idcs_user_t   
    AS OBJECT (
      username      VARCHAR2(100),
      displayname   VARCHAR2(100),
      firstname     VARCHAR2(50),
      lastname      VARCHAR2(50),
      email         VARCHAR2(100)
    );
  */

  -- Obtain access token from IDCS
  PROCEDURE get_authz_token;      
  
  -- Creates user in IDCS
  PROCEDURE create_user (         
    username      varchar2,
    first_name  varchar2,
    last_name   varchar2,
    email       varchar2); 
    
  --  Assigns group groupname to user username
  PROCEDURE grant_group (         
    username      varchar2,
    groupname   varchar2);
    
  -- Returns list of all IDCS groups a user is a member of
  FUNCTION get_user_membership (  
      username      varchar2) 
      RETURN group_list_t;
      
  -- Returns internal user id from username
  FUNCTION get_user_id (          
      username      varchar2) 
      RETURN VARCHAR2;
      

-- Returns username,displayname,firstname,lastname,email for all users
/* Sample usage for Table Function user_profiles:

    SELECT * from TABLE((idcs_client.user_profiles));  

    SELECT email from TABLE((idcs_client.get_user_profiles)) where username='myuser1';
    
*/
  FUNCTION user_profiles        -- Table function to query user profiles
      RETURN user_list_t PIPELINED;
      

END idcs_client;
/


CREATE OR REPLACE PACKAGE BODY  IDCS_APP.idcs_client AS

  -- Gets access token from IDCS
  PROCEDURE get_authz_token IS
      
      v_token_request_uri   VARCHAR2(50):='/oauth2/v1/token';
      v_creds               VARCHAR2(500):=g_client_id||':'||g_client_pwd;  --Client credentials unencoded
      v_client_creds        VARCHAR2(1000):=replace(replace(replace(utl_encode.text_encode(v_creds,'WE8ISO8859P1', UTL_ENCODE.BASE64),chr(9)),chr(10)),chr(13));  -- BASE64 - encodes credentials
      l_idcs_response_CLOB  CLOB;     -- JSON response from IDCS
      l_idcs_url            VARCHAR2(500);

    BEGIN
      --Build request Headers
      apex_web_service.g_request_headers(1).name := 'Content-Type';
      apex_web_service.g_request_headers(1).value := 'application/x-www-form-urlencoded; charset=UTF-8';

      apex_web_service.g_request_headers(2).name := 'Authorization';
      apex_web_service.g_request_headers(2).value := 'Basic '||v_client_creds;

      l_idcs_url := g_base_url||v_token_request_uri ;  --Request URL

      -- Sends a POST SSL Request to /oauth2/v1/token with grant_type=client_credentials and appropiate scope
      l_idcs_response_clob := apex_web_service.make_rest_request
        ( p_url => l_idcs_url,
        p_http_method => 'POST',
        p_wallet_path => g_wallet_path,
        p_wallet_pwd  => g_wallet_pwd,
        p_body => 'grant_type=client_credentials'||'&'||'scope=urn:opc:idm:__myscopes__');
        dbms_output.put_line('IDCS Response getting token: '||l_idcs_response_clob);
  
        -- APEX_JSON Package used to parse response
        apex_json.parse(l_idcs_response_clob);   -- Parse JSON response.  No ERROR Checking for simplicity.
        -- Implement verification of response code and error check
        
        g_bearer_token := apex_json.get_varchar2(p_path => 'access_token');  -- Obtain access_token from parsed response and set variable with token value
        --dbms_output.put_line('Bearer Token: '||g_bearer_token);
        
    END get_authz_token;
    
    
    -- Creates user in IDCS
    PROCEDURE create_user (
      username    varchar2,
      first_name  varchar2,
      last_name   varchar2,
      email       varchar2) IS  -- work email
      
      l_idcs_url    VARCHAR2(1000);

      l_authz_header APEX_APPLICATION_GLOBAL.VC_ARR2;
      l_idcs_response_clob CLOB;  -- JSON IDCS response
      
      -- Quickly build a JSON Request Body for Create User Request from parameter values
      l_users_body  VARCHAR2(1000):='{
          "schemas": [
             "urn:ietf:params:scim:schemas:core:2.0:User"
            ],
            "userName": "'||username||'",
            "name": {
              "familyName": "'||last_name||'",
              "givenName": "'||first_name||'"
            },
            "emails": [
              {
                "value": "'||email||'",
                "type": "work",
                "primary": true
              }
            ]
          }'; 
      
      BEGIN

        IF g_bearer_token IS NULL THEN
          idcs_client.get_authz_token;  -- Get an access token to be able to make request
        END IF;
        IF g_bearer_token IS NOT NULL THEN
              -- Build Request Headers
              apex_web_service.g_request_headers(1).name := 'Content-Type';
              apex_web_service.g_request_headers(1).value := 'application/scim+json';
              apex_web_service.g_request_headers(2).name := 'Authorization';  
              apex_web_service.g_request_headers(2).value := 'Bearer ' || g_bearer_token;  -- Access Token
              l_idcs_url := g_base_url||g_users_uri ;  -- IDCS URL

              -- Sends a POST SSL Request to /admin/vi/Users with new user in Body
              l_idcs_response_clob := apex_web_service.make_rest_request
                 ( p_url => l_idcs_url,
                  p_http_method => 'POST',
                  p_wallet_path => g_wallet_path,
                  p_wallet_pwd  => g_wallet_pwd,
                  p_body => l_users_body);
              dbms_output.put_line('IDCS Response creating user: '||l_idcs_response_clob);
              apex_json.parse(l_idcs_response_clob);   -- Parse JSON response.  No ERROR Checking for simplicity.
              -- Implement verification of response code and error check
              --dbms_output.put_line(l_idcs_response_clob);
          END IF;
      END create_user;
      
      
    -- Grants group groupname to user username
    PROCEDURE grant_group (
      username      varchar2,
      groupname   varchar2) IS
      BEGIN
       null;            -- HOMEWORK!
      END grant_group;
      
      
    -- Returns list of groups user username is a member of
    FUNCTION get_user_membership (
      username      varchar2) 
        RETURN group_list_t IS

      l_idcs_url      VARCHAR2(1000);  
      l_idcs_response_clob CLOB;  --JSON IDCS Response
      -- Request filter to return the displayname user username is a member of
      l_groups_filter  VARCHAR2(100):='?attributes=displayName&filter=members+eq+%22'||get_user_id(username)||'%22';
      l_group_count PLS_INTEGER;  --Number of group the user is a member of
      l_group_names group_list_t:=group_list_t();  -- List of user's groups to return
    
      BEGIN
        IF g_bearer_token IS NULL THEN
          idcs_client.get_authz_token;  -- Get access token
        END IF;
        IF g_bearer_token IS NOT NULL THEN
              -- Build Request Headers
              apex_web_service.g_request_headers(1).name := 'Content-Type';
              apex_web_service.g_request_headers(1).value := 'application/scim+json';
              apex_web_service.g_request_headers(2).name := 'Authorization';
              apex_web_service.g_request_headers(2).value := 'Bearer ' || g_bearer_token;       
              l_idcs_url := g_base_url||g_groups_uri||l_groups_filter ; 

              -- Sends a GET SSL Request to /admin/vi/Groups?attributes=displayName&filter=members+eq+%22'||get_user_id(username)||'%22';
              l_idcs_response_clob := apex_web_service.make_rest_request
                 ( p_url => l_idcs_url,
                  p_http_method => 'GET',
                  p_wallet_path => g_wallet_path,
                  p_wallet_pwd  => g_wallet_pwd);

              dbms_output.put_line('IDCS Response getting membership: '||l_idcs_response_clob);
              apex_json.parse(l_idcs_response_clob);  -- Parse JSON response.  No ERROR Checking for simplicity.
              -- Implement verification of response code and error check
              --dbms_output.put_line(l_idcs_response_clob);
              l_group_count:=apex_json.get_count(p_path=>'Resources');  -- Obtained number of Resources (groups) to extract groups below
              
              --This LOOP is just to print the displaynames not really needed in this function.  List of groups is returned as l_group_names
              FOR i in 1..l_group_count LOOP  -- Through all returned groups.  
                l_group_names.extend;
                l_group_names(l_group_names.last):=apex_json.get_varchar2(p_path=>'Resources[%d].displayName',p0=>i);  --Find displayname for current group %d
                dbms_output.put_line(l_group_names(i)); -- Print group displayName
              END LOOP;
              
              RETURN l_group_names;  -- Returns list of the user's groups
          END IF;
          RETURN null;
      END get_user_membership;
      
      
    -- Returns internal userid from her username  
    -- This function is invoked from function get_user_membership
    FUNCTION get_user_id (
      username      varchar2) 
        RETURN VARCHAR2 IS
        
      l_idcs_url      VARCHAR2(1000);  
      l_idcs_response_clob CLOB;  --JSON IDCS Response
      l_users_filter  VARCHAR2(100):='?attributes=id&filter=userName+eq+%22'||username||'%22'; -- get id for userName=username
      
      BEGIN
        IF g_bearer_token IS NULL THEN
          idcs_client.get_authz_token;  -- Get Access Token
        END IF;
        IF g_bearer_token IS NOT NULL THEN
              -- Build Request Headers
              apex_web_service.g_request_headers(1).name := 'Content-Type';
              apex_web_service.g_request_headers(1).value := 'application/scim+json';
              apex_web_service.g_request_headers(2).name := 'Authorization';
              apex_web_service.g_request_headers(2).value := 'Bearer ' || g_bearer_token;       
              l_idcs_url := g_base_url||g_users_uri||l_users_filter ;

              -- Sends a GET SSL Request to /admin/vi/Users?attributes=id&filter=userName+eq+%22'||username||'%22
              l_idcs_response_clob := apex_web_service.make_rest_request
                 ( p_url => l_idcs_url,
                  p_http_method => 'GET',
                  p_wallet_path => g_wallet_path,
                  p_wallet_pwd  => g_wallet_pwd);
              dbms_output.put_line('IDCS Response getting user id: '||l_idcs_response_clob);
              apex_json.parse(l_idcs_response_clob);  -- Parse JSON response.  No ERROR Checking for simplicity.
              -- Implement verification of response code and error check
              
              --dbms_output.put_line(l_idcs_response_clob);
              --dbms_output.put_line('ID: '||apex_json.get_varchar2('Resources[1].id'));
              RETURN apex_json.get_varchar2('Resources[1].id');
          END IF;    
      
        RETURN null;
      END get_user_id;
    
      
      
    -- Returns username,displayname,firstname,lastname,email for all users
    /* Sample usage for Table Function user_profiles:

       SELECT * from TABLE((idcs_client.user_profiles));  

        SELECT email from TABLE((idcs_client.get_user_profiles)) where username='myuser1';
    */
    -- This is a Table Function, can be queried as SELECT * from TABLE((idcs_client.get_user_profiles));
    FUNCTION user_profiles   
       RETURN user_list_t PIPELINED IS

      l_idcs_url      VARCHAR2(1000);  
      l_idcs_response_clob CLOB;  -- JSON IDCS Response
       -- Filter to get displayname, username, active, firstname, lastname and primary email
      l_users_filter  VARCHAR2(100):='?attributes=displayname,username,active,name.givenName,name.familyName,emails.value,emails.primary';
      l_user_count PLS_INTEGER;   -- Number of users returned.
      l_user_profile idcs_user_t:=idcs_user_t(NULL,NULL,NULL,NULL,NULL);   --initialize variable that holds user profiles
    
      BEGIN
        IF g_bearer_token IS NULL THEN
          idcs_client.get_authz_token;  -- Get Access Token
        END IF;
        IF g_bearer_token IS NOT NULL THEN
              -- Build Request Headers
              apex_web_service.g_request_headers(1).name := 'Content-Type';
              apex_web_service.g_request_headers(1).value := 'application/scim+json';
              apex_web_service.g_request_headers(2).name := 'Authorization';
              apex_web_service.g_request_headers(2).value := 'Bearer ' || g_bearer_token;       
              l_idcs_url := g_base_url||g_users_uri||l_users_filter ;

              -- Sends a GET SSL Request to /admin/vi/Users?attributes=displayname,username,active,name.givenName,name.familyName,emails.value,emails.primary to retrieve ALL USERS.
              -- No Paging is done
              l_idcs_response_clob := apex_web_service.make_rest_request
                 ( p_url => l_idcs_url,
                  p_http_method => 'GET',
                  p_wallet_path => g_wallet_path,
                  p_wallet_pwd  => g_wallet_pwd);
              dbms_output.put_line('IDCS Response getting profiles: '||l_idcs_response_clob);
              apex_json.parse(l_idcs_response_clob);  -- Parse JSON response.  No ERROR Checking for simplicity.
              -- Implement verification of response code and error check
              
              l_user_count:=apex_json.get_count(p_path=>'Resources');  -- Number of Resources (users) in response
              
              -- LOOP through all returned users and idcs_user_t table with the profile attributes for each user
              -- No Paging implemented
              FOR i in 1..l_user_count LOOP  
                l_user_profile:=idcs_user_t(apex_json.get_varchar2(p_path=>'Resources[%d].userName',p0=>i),
                                                                  apex_json.get_varchar2(p_path=>'Resources[%d].displayName',p0=>i),
                                                                  apex_json.get_varchar2(p_path=>'Resources[%d].name.givenName',p0=>i),
                                                                  apex_json.get_varchar2(p_path=>'Resources[%d].name.familyName',p0=>i),
                                                                  apex_json.get_varchar2(p_path=>'Resources[%d].emails[1].value',p0=>i)
                                                                  );
                                                     
               -- dbms_output.put_line(l_user_profile.username);
                PIPE ROW(l_user_profile);  -- Pipe out rows to invoking select statement
              END LOOP;
              
              
          END IF;
          RETURN;
      END user_profiles;
    
END idcs_client;
/
