/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.cipher;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import oracle.cloudstorage.api.cipher.CryptoUtils;
import oracle.cloudstorage.api.cipher.ICipher;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.IHeaderReader;
import oracle.cloudstorage.api.header.IHeaderWriter;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAEnvelopeCipher
implements ICipher {
    private static final Logger logger = LoggerFactory.getLogger(RSAEnvelopeCipher.class);
    private static final Header[] HEADERS = new Header[]{Header.envelopeKey1, Header.envelopeKey2, Header.digestKey1, Header.digestKey2};
    private KeyPair keyPair = null;

    @Override
    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.validateKeyPair();
    }

    @Override
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public void validate() {
        this.validateKeyPair();
    }

    @Override
    public Header[] getRequiredHeaders() {
        return HEADERS;
    }

    protected void validateKeyPair() {
        KeyPair keyPair = this.getKeyPair();
        if (keyPair == null) {
            throw new IllegalArgumentException("Attempt to encrypt with null key pair");
        }
        PublicKey publicKey = keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Attempt to encrypt with null public key");
        }
        String publicAlgorithm = publicKey.getAlgorithm();
        if (!"RSA".equals(publicAlgorithm)) {
            throw new IllegalArgumentException("Attempt to encrypt with " + publicAlgorithm + " public key, expected " + "RSA");
        }
        PrivateKey privateKey = keyPair.getPrivate();
        if (privateKey == null) {
            throw new IllegalArgumentException("Attempt to encrypt with null private key");
        }
        String privateAlgorithm = privateKey.getAlgorithm();
        if (!"RSA".equals(privateAlgorithm)) {
            throw new IllegalArgumentException("Attempt to encrypt with " + privateAlgorithm + " private key, expected " + "RSA");
        }
    }

    @Override
    public String rotate(IHeaderWriter headers, PrivateKey decryptionKey) {
        KeyPair keyPair = this.getKeyPair();
        if (keyPair == null) {
            return "No KeyPair for re-encryption";
        }
        StringBuilder missing = new StringBuilder();
        for (Header header : this.getRequiredHeaders()) {
            String value = headers.getHeader(header);
            if (value != null && !value.trim().isEmpty()) continue;
            missing.append(header).append(", ");
        }
        if (missing.length() > 0) {
            missing.setLength(missing.length() - 2);
            return "Original metadata is missing encryption key(s): " + missing + ".";
        }
        try {
            String envelopeKey1 = headers.getHeader(Header.envelopeKey1);
            String envelopeKey2 = headers.getHeader(Header.envelopeKey2);
            String digestKey1 = headers.getHeader(Header.digestKey1);
            String digestKey2 = headers.getHeader(Header.digestKey2);
            String oldEnvelopeKey = envelopeKey1 + envelopeKey2;
            SecretKeySpec aes = new SecretKeySpec(CryptoUtils.decrypt(oldEnvelopeKey, decryptionKey), "AES");
            String envelopeKey = CryptoUtils.encrypt(aes.getEncoded(), keyPair.getPublic());
            envelopeKey1 = envelopeKey.substring(0, 256);
            envelopeKey2 = envelopeKey.substring(256, 512);
            String oldDigestKey = digestKey1 + digestKey2;
            SecretKeySpec hmac = new SecretKeySpec(CryptoUtils.decrypt(oldDigestKey, decryptionKey), "HMACSHA256");
            String hmacKey = CryptoUtils.encrypt(hmac.getEncoded(), keyPair.getPublic());
            digestKey1 = hmacKey.substring(0, 256);
            digestKey2 = hmacKey.substring(256, 512);
            headers.clearHeaders();
            headers.setHeader(Header.envelopeKey1.provide(envelopeKey1));
            headers.setHeader(Header.envelopeKey2.provide(envelopeKey2));
            headers.setHeader(Header.digestKey1.provide(digestKey1));
            headers.setHeader(Header.digestKey2.provide(digestKey2));
            return null;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Unable to rotate cipher keys.", e);
        }
    }

    @Override
    public CryptoUtils.DigestInputStream encrypt(IHeaderWriter headers, InputStream unencrypted) {
        KeyPair keyPair = this.getKeyPair();
        if (keyPair == null) {
            logger.debug(Marker.cipher.and(Marker.put), "No {} provided, skipping encryption.", (Object)KeyPair.class);
            return new CryptoUtils.DigestInputStream(unencrypted, null, null);
        }
        try {
            SecretKey aes = CryptoUtils.createAESKey();
            String envelopeKey = CryptoUtils.encrypt(aes.getEncoded(), keyPair.getPublic());
            String envelopeKey1 = envelopeKey.substring(0, 256);
            String envelopeKey2 = envelopeKey.substring(256, 512);
            SecretKey hmac = CryptoUtils.createHMACKey();
            String hmacKey = CryptoUtils.encrypt(hmac.getEncoded(), keyPair.getPublic());
            String digestKey1 = hmacKey.substring(0, 256);
            String digestKey2 = hmacKey.substring(256, 512);
            headers.setHeader(Header.envelopeKey1.provide(envelopeKey1));
            headers.setHeader(Header.envelopeKey2.provide(envelopeKey2));
            headers.setHeader(Header.digestKey1.provide(digestKey1));
            headers.setHeader(Header.digestKey2.provide(digestKey2));
            CryptoUtils.DigestInputStream encrypted = CryptoUtils.createEncryptionFilter(unencrypted, aes, hmac);
            logger.debug(Marker.cipher.and(Marker.put), "Encryption complete.");
            return encrypted;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Unable to encrypt", e);
        }
    }

    @Override
    public InputStream decrypt(IHeaderReader headers, InputStream encrypted) {
        String envelopeKey1 = headers.getHeader(Header.envelopeKey1);
        if (envelopeKey1 == null) {
            logger.debug(Marker.cipher.and(Marker.get), "No encryption headers found, skipping decryption.");
            return encrypted;
        }
        KeyPair keyPair = this.getKeyPair();
        if (keyPair == null) {
            logger.warn(Marker.cipher.and(Marker.get), "Encryped data found, but no keys provided on Session for decryption.");
            return encrypted;
        }
        try {
            String envelopeKey2 = headers.getHeader(Header.envelopeKey2);
            String envelopeKey = envelopeKey1 + envelopeKey2;
            String digestKey1 = headers.getHeader(Header.digestKey1);
            String digestKey2 = headers.getHeader(Header.digestKey2);
            String digestKey = digestKey1 + digestKey2;
            String digest = headers.getHeader(Header.digest);
            InputStream decrypted = CryptoUtils.decrypt(envelopeKey, digestKey, digest, encrypted, keyPair);
            logger.debug(Marker.cipher.and(Marker.get), "Decryption complete.");
            return decrypted;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Unable to decrypt", e);
        }
    }
}

