/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.reply;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.queryparam.Map;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.retry.RetryState;
import oracle.cloudstorage.text.Strings;
import oracle.cloudstorage.util.Throwables;

public class Reply
implements IReply {
    private final oracle.cloudstorage.api.header.Map headers = new oracle.cloudstorage.api.header.Map();
    private final Status status;
    private final String message;
    private final String txId;
    private final IReply.Context context;

    public Reply(java.util.Map<String, List<Object>> headers, int statusCode, IReply.Context context) {
        this(headers, statusCode, null, context);
    }

    public Reply(java.util.Map<String, ?> headers, int statusCode, String message, IReply.Context context) {
        List replyHeaders;
        Status status = Status.fromStatusCode(statusCode);
        this.status = status == null ? Status.NULL : status;
        String string = this.message = message == null ? this.status.getReasonPhrase() : message;
        this.txId = headers != null && headers.get("x-trans-id") != null ? (headers.get("x-trans-id") instanceof List ? ((replyHeaders = (List)headers.get("x-trans-id")) != null && !replyHeaders.isEmpty() ? (String)replyHeaders.get(0) : null) : (headers.get("x-trans-id") instanceof String ? (String)headers.get("x-trans-id") : null)) : null;
        this.headers.putNormalized(headers);
        this.context = context;
    }

    public Reply(IReply reply) {
        Status status = reply.getStatus();
        this.status = status == null ? Status.NULL : status;
        this.message = reply.getMessage();
        this.txId = reply.getTransId();
        this.headers.putAll(reply.getHeaders());
        this.context = reply.getContext();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isSuccessful() throws InterruptedException {
        return this.getStatus() != null && this.getStatus().getFamily() == Status.Family.SUCCESSFUL;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public oracle.cloudstorage.api.header.Map getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String key) {
        return this.headers.get(key);
    }

    @Override
    public String getHeader(Header header) {
        return this.getHeader(header.key);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.headers.entrySet().iterator();
    }

    @Override
    public String getContainerHeader(String containerSuffix) {
        String value = Header.container(this.getHeaders(), containerSuffix);
        return value;
    }

    @Override
    public String getObjectHeader(String objectSuffix) {
        String value = Header.object(this.getHeaders(), objectSuffix);
        return value;
    }

    @Override
    public IReply.Context getContext() {
        return this.context;
    }

    public String toString() {
        String reply = (Object)((Object)this.getStatus()) + " (" + this.getStatus().getStatusCode() + ")\n    " + Strings.join(this.getHeaders()) + (this.message == null ? "" : "\n    " + this.message);
        return reply;
    }

    @Override
    public String getTransId() {
        return this.txId;
    }

    public static class Context
    implements IReply.Context {
        private static final String UNKNOWN = "unknown";
        private static final String NO_REQUEST = "no request";
        private static final String NO_SESSION = "no session";
        private static final String NO_BUILDER = "no builder";
        private static final String NO_STATE = "no retry state";
        private static final String NO_REPLY = "no retry auth reply";
        private final List<Throwable> suppressed = new LinkedList<Throwable>();
        private final String method;
        private final String url;
        private final String storageToken;
        private final String maskedStorageToken;
        private final String storageUrl;
        private final oracle.cloudstorage.api.header.Map headers;
        private final String accountId;
        private final String containerId;
        private final String objectId;
        private final RetryState retryState;
        private final Map queryParams;
        private Status status;
        private String message;
        private String txId;

        public Context(IRequestBuilder builder, ISendable request, RetryState retryState) {
            ISession session = null;
            IAuthReply authReply = null;
            String method = UNKNOWN;
            String url = UNKNOWN;
            String storageToken = UNKNOWN;
            String maskedStorageToken = UNKNOWN;
            String storageUrl = UNKNOWN;
            String accountId = UNKNOWN;
            String containerId = UNKNOWN;
            String objectId = UNKNOWN;
            try {
                session = builder == null ? null : builder.getSession();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                authReply = retryState == null ? null : retryState.getAuthReply();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                method = request == null ? NO_REQUEST : request.getMethod().name().toUpperCase();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                url = request == null ? NO_REQUEST : request.getUrl();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                storageToken = session == null ? NO_SESSION : session.getStorageToken();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                maskedStorageToken = session == null ? NO_SESSION : session.getMaskedStorageToken();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                storageUrl = session == null ? NO_SESSION : session.getStorageUrl();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                accountId = builder == null ? NO_BUILDER : builder.getAccountId();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                containerId = builder == null ? NO_BUILDER : builder.getContainerId();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                objectId = builder == null ? NO_BUILDER : builder.getObjectId();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            this.method = method;
            this.url = url;
            this.storageToken = storageToken;
            this.maskedStorageToken = maskedStorageToken;
            this.storageUrl = storageUrl;
            this.accountId = accountId;
            this.containerId = containerId;
            this.objectId = objectId;
            this.retryState = retryState;
            this.headers = builder == null ? new oracle.cloudstorage.api.header.Map() : new oracle.cloudstorage.api.header.Map(builder.getSendable().getHeaders());
            this.queryParams = builder == null ? null : builder.getQueryParams();
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getRequestMethod() {
            return this.method;
        }

        @Override
        public String getRequestUrl() {
            return this.url;
        }

        @Override
        public oracle.cloudstorage.api.header.Map getRequestHeaders() {
            return this.headers;
        }

        @Override
        public String getStorageToken() {
            return this.storageToken;
        }

        @Override
        public String getMaskedStorageToken() {
            return this.maskedStorageToken;
        }

        @Override
        public String getStorageUrl() {
            return this.storageUrl;
        }

        @Override
        public String getAccountId() {
            return this.accountId;
        }

        @Override
        public String getContainerId() {
            return this.containerId;
        }

        @Override
        public String getObjectId() {
            return this.objectId;
        }

        @Override
        public RetryState getRetryState() {
            return this.retryState;
        }

        public void throwWithContext(Throwable cause) {
            String message = this.buildDetailedMessage();
            RuntimeException toThrow = new RuntimeException(message, cause);
            for (Throwable t : this.suppressed) {
                Throwables.addSuppressed(toThrow, t);
            }
            throw toThrow;
        }

        @Override
        public String buildDetailedMessage() {
            String attempt = UNKNOWN;
            String evaluation = UNKNOWN;
            String elapsedMillis = UNKNOWN;
            String retryAuthStatus = UNKNOWN;
            String retryStorageToken = UNKNOWN;
            String retryStorageUrl = UNKNOWN;
            ArrayList<String> headers = new ArrayList<String>();
            IAuthReply authReply = null;
            try {
                authReply = this.retryState == null ? null : this.retryState.getAuthReply();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                attempt = this.retryState == null ? NO_STATE : Integer.toString(this.retryState.getAttempt());
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                evaluation = this.retryState == null ? NO_STATE : Integer.toString(this.retryState.getEvaluation());
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                elapsedMillis = this.retryState == null ? NO_STATE : Long.toString(this.retryState.getElapsedMillis());
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                retryAuthStatus = authReply == null ? NO_REPLY : "" + (Object)((Object)authReply.getStatus());
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                retryStorageToken = authReply == null ? NO_REPLY : authReply.getMaskedStorageToken();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            try {
                retryStorageUrl = authReply == null ? NO_REPLY : authReply.getStorageUrl();
            }
            catch (Throwable t) {
                this.suppressed.add(t);
            }
            for (String key : this.headers.keySet()) {
                String value = UNKNOWN;
                try {
                    value = this.headers.mask(key);
                }
                catch (Throwable t) {
                    this.suppressed.add(t);
                }
                headers.add(key + ":" + value);
            }
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("\n          method: ").append(this.getRequestMethod()).append("\n             url: ").append(this.getRequestUrl()).append("\n   storage token: ").append(this.getMaskedStorageToken()).append("\n     storage url: ").append(this.getStorageUrl()).append("\n         account: ").append(this.getAccountId()).append("\n       container: ").append(this.getContainerId()).append("\n          object: ").append(this.getObjectId()).append("\n   retry attempt: ").append(attempt).append("\nretry evaluation: ").append(evaluation).append("\nretry elapsed ms: ").append(elapsedMillis).append("\n  re-auth status: ").append(retryAuthStatus).append("\n   re-auth token: ").append(retryStorageToken).append("\n     re-auth url: ").append(retryStorageUrl).append("\n         headers: ");
            for (String header : headers) {
                messageBuilder.append("\n            ").append(header);
            }
            if (this.queryParams != null) {
                messageBuilder.append("\n         query params: ").append(this.queryParams);
            }
            messageBuilder.append("\n          status: ").append((Object)this.status).append("\n        trans-id: ").append(this.txId).append("\n         message: ").append(this.message);
            return messageBuilder.toString();
        }

        @Override
        public Map getQueryParams() {
            return this.queryParams;
        }

        @Override
        public void updateContext(IReply reply) {
            this.status = reply.getStatus();
            this.txId = reply.getTransId();
            this.message = reply.getMessage();
        }
    }
}

