/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.request.processor.AbstractResponse;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class StandardSender
implements ISender {
    private static final Logger logger = LoggerFactory.getLogger(StandardSender.class);
    private static final int DEFAULT_CHUNK_SIZE = 8192;

    @Override
    public IResponse send(Logger logger, Marker marker, ISendable sendable) {
        HttpURLConnection connection = null;
        try {
            Strings.updateUserAgent(sendable.getHeaders());
            Transaction tx = this.connect(sendable);
            connection = tx.getConnection();
            logger.debug(marker, " Standard Request {}", (Object)tx);
            Response response = new Response(connection, sendable);
            tx.setResponse(response);
            logger.debug(marker, "Standard Response {}", (Object)tx);
            return response;
        }
        catch (RuntimeException e) {
            if (connection != null) {
                connection.disconnect();
            }
            throw e;
        }
        catch (Exception e) {
            if (connection != null) {
                connection.disconnect();
            }
            throw new RuntimeException(e);
        }
    }

    protected InputStream getInputStream(HttpURLConnection connection, boolean error) throws IOException {
        InputStream inputStream = error ? connection.getErrorStream() : connection.getInputStream();
        return inputStream;
    }

    protected OutputStream getOutputStream(URLConnection connection) throws IOException {
        OutputStream outputStream = connection.getOutputStream();
        return outputStream;
    }

    protected Transaction connect(ISendable sendable) throws IOException {
        StringBuilder spec = new StringBuilder(sendable.getUrl().toString());
        sendable.getQueryParams().appendTo(spec, false);
        URL url = new URL(spec.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        Transaction tx = new Transaction(sendable, connection);
        connection.setRequestMethod(sendable.getMethod().name().toUpperCase());
        int chunk = sendable.getChunk();
        if (chunk == 0) {
            chunk = 8192;
        }
        long contentLength = -1L;
        java.util.Map<String, List<Object>> headers = sendable.getHeaders().split();
        for (String key : headers.keySet()) {
            if (chunk <= 0 && key.equalsIgnoreCase(Header.expect.key)) continue;
            List<Object> values = headers.get(key);
            if (values.isEmpty()) {
                connection.addRequestProperty(key, "");
            }
            for (Object value : headers.get(key)) {
                if (contentLength < 0L && value != null && key.equalsIgnoreCase(Header.contentLength.key)) {
                    contentLength = Long.parseLong(value.toString());
                }
                connection.addRequestProperty(key, value == null ? "" : value.toString());
            }
        }
        int timeout = sendable.getConnectTimeout();
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
        }
        if ((timeout = sendable.getReadTimeout()) > 0) {
            connection.setReadTimeout(timeout);
        }
        connection.setDoInput(true);
        IContent content = sendable.getContent();
        if (content == null) {
            return tx;
        }
        connection.setDoOutput(true);
        if (chunk > 0) {
            connection.setChunkedStreamingMode(chunk);
            tx.chunk = chunk;
        } else if (contentLength > 0L) {
            connection.setFixedLengthStreamingMode((int)contentLength);
            tx.fixed = contentLength;
        }
        tx.requestHeaders = connection.getRequestProperties();
        long start = System.currentTimeMillis();
        OutputStream outputStream = this.getOutputStream(connection);
        tx.waitForOutputStream = System.currentTimeMillis() - start;
        content.prepareForRead().streamTo(outputStream);
        return tx;
    }

    private class Response
    extends AbstractResponse {
        private final HttpURLConnection connection;
        private final int statusCode;
        private final InputStream inputStream;
        private final Future<String> futureMd5;
        private final java.util.Map<String, List<Object>> headers = new HashMap<String, List<Object>>();

        Response(HttpURLConnection connection, ISendable sendable) throws IOException {
            this.connection = connection;
            int statusCode = connection.getResponseCode();
            if (statusCode == 100) {
                statusCode = 500;
            }
            this.statusCode = statusCode;
            this.inputStream = StandardSender.this.getInputStream(connection, statusCode >= 400);
            this.futureMd5 = sendable.getContent() == null ? null : sendable.getContent().getFutureMd5();
            for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
                if (header.getKey() == null || header.getKey().trim().isEmpty()) continue;
                ArrayList<String> values = new ArrayList<String>(header.getValue().size());
                for (String value : header.getValue()) {
                    values.add(value);
                }
                this.headers.put(header.getKey().toLowerCase(), values);
            }
        }

        @Override
        public int getStatus() {
            return this.statusCode;
        }

        @Override
        public java.util.Map<String, List<Object>> getHeaders() {
            return this.headers;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() {
            this.connection.disconnect();
        }

        @Override
        public Future<String> getFutureMd5() {
            return this.futureMd5;
        }
    }

    private static class Transaction {
        private static final AtomicLong next = new AtomicLong();
        private final ISendable sendable;
        private final HttpURLConnection conn;
        private java.util.Map<String, List<String>> requestHeaders;
        private IResponse response = null;
        private long waitForOutputStream = -1L;
        private int chunk = -1;
        private long fixed = -1L;

        Transaction(ISendable sendable, HttpURLConnection conn) {
            this.sendable = sendable;
            this.conn = conn;
        }

        private String serializeRequest() {
            StringBuilder msg = new StringBuilder(this.sendable.getRequestLogEvent().toString());
            if (logger.isTraceEnabled() && this.requestHeaders != null) {
                StringBuilder values = new StringBuilder();
                for (Map.Entry<String, List<String>> header : this.requestHeaders.entrySet()) {
                    values.setLength(0);
                    for (String value : header.getValue()) {
                        values.append((Object)value).append(',');
                    }
                    values.setLength(Math.min(0, values.length() - 1));
                    if (!values.equals(this.sendable.getHeaders().get(header.getKey()))) continue;
                    msg.append("\n  ").append(header.getKey()).append(':').append(Map.mask(header.getKey(), values)).append(" <=== modified");
                }
                for (String key : this.sendable.getHeaders().keySet()) {
                    if (this.requestHeaders.containsKey(key)) continue;
                    msg.append("\n  ").append(key).append(" <=== removed");
                }
            }
            msg.append("\nConnect timeout: ").append(this.conn.getConnectTimeout()).append(", Read timeout: ").append(this.conn.getReadTimeout()).append("\nStreaming chunk size:").append(this.chunk).append(", fixed streaming size:").append(this.fixed).append(", duration waited for output stream ").append(this.waitForOutputStream).append("ms");
            return msg.toString();
        }

        private String serializeResponse() {
            return this.sendable.getResponseLogEvent(this.response).toString();
        }

        void setResponse(IResponse response) {
            this.response = response;
        }

        HttpURLConnection getConnection() {
            return this.conn;
        }

        public String toString() {
            try {
                return this.response == null ? this.serializeRequest() : this.serializeResponse();
            }
            catch (RuntimeException e) {
                StringWriter s = new StringWriter();
                e.printStackTrace(new PrintWriter(s));
                return s.toString();
            }
        }
    }
}

