/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.session;

import java.io.InputStream;
import java.security.PrivateKey;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.AuthRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthKeepAliveStrategy;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.auth.IllegalAuthStateException;
import oracle.cloudstorage.api.auth.SendableAuthStrategy;
import oracle.cloudstorage.api.auth.SkipAuthStrategy;
import oracle.cloudstorage.api.cipher.CryptoUtils;
import oracle.cloudstorage.api.cipher.ICipher;
import oracle.cloudstorage.api.cipher.RSAEnvelopeCipher;
import oracle.cloudstorage.api.copy.CopyRequestBuilder;
import oracle.cloudstorage.api.copy.ICopyRequestBuilder;
import oracle.cloudstorage.api.copy.ICopyRequestProcessor;
import oracle.cloudstorage.api.delete.DeleteRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteRequestProcessor;
import oracle.cloudstorage.api.get.GetRequestBuilder;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.get.IGetRequestProcessor;
import oracle.cloudstorage.api.head.HeadRequestBuilder;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.head.IHeadRequestProcessor;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.post.IPostRequestBuilder;
import oracle.cloudstorage.api.post.IPostRequestProcessor;
import oracle.cloudstorage.api.post.PostRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestProcessor;
import oracle.cloudstorage.api.put.PutRequestBuilder;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.api.request.processor.ProcessorFactory;
import oracle.cloudstorage.api.request.processor.StandardSender;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Session
implements ISession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    public static final long MAX_NULL_TIMEOUT = Long.MIN_VALUE;
    private volatile boolean building = true;
    private ISender sender = new StandardSender();
    private ExecutorService executor = null;
    private IRetryStrategy retryStrategy = null;
    private IRetryStrategy keepAliveRetryStrategy = null;
    private long readTimeout = Long.MIN_VALUE;
    private long connectTimeout = Long.MIN_VALUE;
    private int chunk = 0;
    private int buffer = 65536;
    private IAuthStrategy authStrategy = new SendableAuthStrategy();
    private ICipher cipher = null;
    private IProcessorFactory processorFactory = new ProcessorFactory();

    protected Session() {
        this(true);
    }

    protected Session(boolean building) {
        this.building = building;
    }

    public void setExecutor(ExecutorService executor) {
        this.assertBuilding();
        this.executor = executor;
    }

    @Override
    public ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        return this.executor;
    }

    @Override
    public void retry(IRetryStrategy retryStrategy) {
        this.assertBuilding();
        this.retryStrategy = retryStrategy;
    }

    @Override
    public void initKeepAlive(IAuthRequestBuilder authRequestBuilder) {
        IAuthKeepAliveStrategy keepAlive = authRequestBuilder.getAuthKeepAlive();
        if (keepAlive == null) {
            logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "No {}.", (Object)IAuthKeepAliveStrategy.class);
            return;
        }
        IRetryStrategy keepAliveRetry = keepAlive.buildRetry(this.getAuthStrategy(), authRequestBuilder);
        if (keepAliveRetry == null) {
            logger.trace(oracle.cloudstorage.text.Marker.auth.marker, "{} already initialized to {}.", (Object)IAuthKeepAliveStrategy.class, (Object)keepAlive);
            return;
        }
        keepAlive.validate(this);
        this.keepAliveRetryStrategy = keepAliveRetry;
    }

    protected void setConnectTimeout(long connectTimeoutMillis) {
        this.assertBuilding();
        this.connectTimeout = connectTimeoutMillis;
    }

    protected void setReadTimeout(long readTimeoutMillis) {
        this.assertBuilding();
        this.readTimeout = readTimeoutMillis;
    }

    protected final void setChunk(int bytesPerChunk) {
        this.chunk = bytesPerChunk;
    }

    protected final void setBuffer(int bufferByteArraySize) {
        this.buffer = bufferByteArraySize;
    }

    @Override
    public final int getChunk() {
        return this.chunk;
    }

    @Override
    public final int getDefaultBuffer() {
        return this.buffer;
    }

    protected IAuthReply getAuthReply() {
        IAuthReply authReply = this.getAuthStrategy().getReply();
        return authReply;
    }

    @Override
    public String getStorageUrl() {
        this.assertBuilt();
        IAuthReply authReply = this.getAuthReply();
        String storageUrl = authReply == null ? null : authReply.getStorageUrl();
        return storageUrl;
    }

    @Override
    public String getStorageToken() {
        this.assertBuilt();
        IAuthReply authReply = this.getAuthReply();
        String storageToken = authReply == null ? null : authReply.getStorageToken();
        return storageToken;
    }

    @Override
    public String getMaskedStorageToken() {
        this.assertBuilt();
        IAuthReply authReply = this.getAuthReply();
        String maskedStorageToken = authReply == null ? null : authReply.getMaskedStorageToken();
        return maskedStorageToken;
    }

    @Override
    public long getReadTimeout() {
        this.assertBuilt();
        return this.readTimeout;
    }

    @Override
    public long getConnectTimeout() {
        this.assertBuilt();
        return this.connectTimeout;
    }

    protected final void setAuthStrategy(IAuthStrategy authStrategy) {
        this.assertBuilding();
        this.authStrategy = authStrategy;
    }

    @Override
    public final IAuthStrategy getAuthStrategy() {
        this.assertBuilt();
        return this.authStrategy;
    }

    protected final void setCipher(ICipher cipher) {
        this.assertBuilding();
        this.cipher = cipher;
    }

    protected final ICipher getCipher() {
        if (this.cipher == null) {
            this.cipher = new RSAEnvelopeCipher();
        }
        return this.cipher;
    }

    protected final void setSender(ISender sender) {
        this.sender = sender;
    }

    @Override
    public IResponse send(Logger logger, Marker marker, ISendable sendable) {
        if (!(sendable.getHeaders().containsKey(Header.storageUser) || sendable.getHeaders().containsKey(Header.storageToken) || sendable.getHeaders().containsKey(Header.basicAuthHeader))) {
            IllegalAuthStateException.validate(this.getAuthReply());
        }
        IResponse response = this.sender.send(logger, marker, sendable);
        return response;
    }

    @Override
    public IProcessorFactory getProcessorFactory() {
        this.assertBuilt();
        return this.processorFactory;
    }

    protected final void setRetryStrategy(IRetryStrategy retryStrategy) {
        this.assertBuilding();
        this.retryStrategy = retryStrategy;
    }

    @Override
    public final IRetryStrategy getRetryStrategy() {
        this.assertBuilt();
        return this.retryStrategy;
    }

    @Override
    public final IRetryStrategy getKeepAliveRetryStrategy() {
        this.assertBuilt();
        return this.keepAliveRetryStrategy;
    }

    public Session processorFactory(IProcessorFactory processorFactory) {
        this.assertBuilding();
        this.processorFactory = processorFactory;
        return this;
    }

    @Override
    public IAuthRequestBuilder.RetryStrategy auth() {
        this.assertBuilt();
        AuthRequestBuilder requestBuilder = new AuthRequestBuilder(null);
        IAuthStrategy authStrategy = this.getAuthStrategy();
        return (IAuthRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, authStrategy);
    }

    @Override
    public void skipAuth(String url) {
        this.assertBuilt();
        AuthRequestBuilder requestBuilder = new AuthRequestBuilder(null);
        SkipAuthStrategy strategy = new SkipAuthStrategy();
        strategy.skipAuth(url);
        this.authStrategy = strategy;
    }

    @Override
    public IDeleteRequestBuilder.RetryStrategy delete() throws InterruptedException {
        this.assertBuilt();
        this.getAuthStrategy().waitForAuth();
        DeleteRequestBuilder requestBuilder = new DeleteRequestBuilder(null);
        IDeleteRequestProcessor processor = this.getProcessorFactory().createDelete();
        return (IDeleteRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, processor);
    }

    @Override
    public IGetRequestBuilder.RetryStrategy get() throws InterruptedException {
        this.assertBuilt();
        this.getAuthStrategy().waitForAuth();
        GetRequestBuilder requestBuilder = new GetRequestBuilder(null);
        IGetRequestProcessor processor = this.getProcessorFactory().createGet();
        return (IGetRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, processor);
    }

    @Override
    public IHeadRequestBuilder.RetryStrategy head() throws InterruptedException {
        this.assertBuilt();
        this.getAuthStrategy().waitForAuth();
        HeadRequestBuilder requestBuilder = new HeadRequestBuilder(null);
        IHeadRequestProcessor processor = this.getProcessorFactory().createHead();
        return (IHeadRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, processor);
    }

    @Override
    public IPostRequestBuilder.RetryStrategy post() throws InterruptedException {
        this.assertBuilt();
        this.getAuthStrategy().waitForAuth();
        PostRequestBuilder requestBuilder = new PostRequestBuilder(null);
        IPostRequestProcessor processor = this.getProcessorFactory().createPost();
        return (IPostRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, processor);
    }

    @Override
    public IPutRequestBuilder.RetryStrategy put() throws InterruptedException {
        this.assertBuilt();
        this.getAuthStrategy().waitForAuth();
        PutRequestBuilder requestBuilder = new PutRequestBuilder(null);
        IPutRequestProcessor processor = this.getProcessorFactory().createPut();
        return (IPutRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, processor);
    }

    @Override
    public ICopyRequestBuilder.RetryStrategy copy() throws InterruptedException {
        this.assertBuilt();
        this.getAuthStrategy().waitForAuth();
        CopyRequestBuilder requestBuilder = new CopyRequestBuilder(null);
        ICopyRequestProcessor processor = this.getProcessorFactory().createCopy();
        return (ICopyRequestBuilder.RetryStrategy)requestBuilder.root((ISession)this, processor);
    }

    final void built() {
        this.assertBuilding();
        this.building = false;
    }

    protected final void assertBuilt() {
        if (this.building) {
            throw new IllegalStateException("Expected session building to be complete.");
        }
    }

    protected final void assertBuilding() {
        if (this.building) {
            return;
        }
        throw new IllegalStateException("Expected session building to be in progress.");
    }

    public static boolean isTimeoutSet(long timeout) {
        return timeout > Long.MIN_VALUE;
    }

    @Override
    public void validateCipher() {
        this.getCipher().validate();
    }

    @Override
    public InputStream encrypt(IPutRequestBuilder builder, InputStream unencrypted) {
        if (builder.skipCryptography() || this.cipher == null || this.cipher.getKeyPair() == null) {
            return unencrypted;
        }
        Map headers = builder.getSendable().getHeaders();
        CryptoUtils.DigestInputStream encrypted = this.cipher.encrypt(headers, unencrypted);
        return encrypted;
    }

    @Override
    public InputStream decrypt(IGetObjectReply headers, InputStream encrypted) {
        ICipher cipher = this.getCipher();
        InputStream decrypted = cipher.decrypt(headers, encrypted);
        return decrypted;
    }

    @Override
    public String rotate(Map headers, PrivateKey decryptionKey) {
        String failure = this.getCipher().rotate(headers, decryptionKey);
        return failure;
    }

    @Override
    public void close() {
        if (this.executor == null) {
            return;
        }
        this.executor.shutdown();
    }

    public String toString() {
        IAuthReply authReply = this.getAuthReply();
        String s = "Session: " + (authReply == null ? "unauthenticated" : authReply.getStorageUrl());
        return s;
    }
}

