/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import oracle.cloudstorage.ftm.DirectoryTransferTask;
import oracle.cloudstorage.ftm.DownloadConfig;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.MultiFileDownloadTask;
import oracle.cloudstorage.ftm.MultiFileTransferResult;
import oracle.cloudstorage.ftm.exception.NoObjectsFound;
import oracle.cloudstorage.ftm.internal.InputValidationUtils;
import oracle.cloudstorage.ftm.internal.RestApiUtils;

class DirectoryDownloadTask
extends DirectoryTransferTask {
    private DownloadConfig downloadConfig;

    public DirectoryDownloadTask(FileTransferManager fileTransferManager, DownloadConfig downloadConfig, String containerName, String objectPrefix, File directory, boolean includeSubdirectories) {
        super(fileTransferManager, containerName, objectPrefix, directory, includeSubdirectories);
        fileTransferManager.getRequestCount().getAndIncrement();
        this.downloadConfig = downloadConfig == null ? new DownloadConfig() : downloadConfig;
        this.transferProgressListener = this.downloadConfig.getTransferProgressListener();
    }

    @Override
    void doValidation() {
        InputValidationUtils.validateContainerName(this.containerName);
        InputValidationUtils.validateDestinationDirectory(this.directory);
    }

    @Override
    Callable<MultiFileTransferResult> createMultiFileTransferTask(List<FileObjectTransferConfig> fileObjectTransferConfigs) {
        return new MultiFileDownloadTask(this.fileTransferManager, this.downloadConfig, this.containerName, fileObjectTransferConfigs, true);
    }

    @Override
    List<FileObjectTransferConfig> createFileObjectTransferConfigs() {
        ArrayList<FileObjectTransferConfig> fileConfigs = new ArrayList<FileObjectTransferConfig>();
        List<String> objIds = RestApiUtils.getObjects(this.fileTransferManager.getFileTransferManagerConfig(), this.fileTransferManager.getSession(), this.containerName, this.objectPrefix);
        if (objIds.isEmpty()) {
            throw new NoObjectsFound();
        }
        String parentDir = this.directory.getAbsolutePath();
        if (this.objectPrefix == null || this.objectPrefix.isEmpty()) {
            for (String objId : objIds) {
                fileConfigs.add(new FileObjectTransferConfig(new File(parentDir + File.separator + objId), objId));
            }
        } else {
            int prefixIndex = this.objectPrefix.length();
            for (String objId : objIds) {
                fileConfigs.add(new FileObjectTransferConfig(new File(parentDir + File.separator + objId.substring(prefixIndex)), objId));
            }
        }
        return fileConfigs;
    }
}

