/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.MultiFileTransferResult;
import oracle.cloudstorage.ftm.TransferTask;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.model.TransferEventType;
import oracle.cloudstorage.ftm.model.TransferProgressEvent;
import oracle.cloudstorage.ftm.model.TransferProgressListener;

abstract class DirectoryTransferTask
implements Callable<MultiFileTransferResult> {
    protected FileTransferManager fileTransferManager;
    protected String containerName;
    protected String objectPrefix;
    protected File directory;
    protected boolean includeSubdirectories;
    protected TransferProgressListener transferProgressListener;

    public DirectoryTransferTask(FileTransferManager fileTransferManager, String containerName, String objectPrefix, File directory, boolean includeSubdirectories) {
        this.fileTransferManager = fileTransferManager;
        this.containerName = containerName;
        this.objectPrefix = objectPrefix == null ? "" : objectPrefix;
        this.directory = directory;
        this.includeSubdirectories = includeSubdirectories;
    }

    abstract void doValidation() throws ClientException;

    abstract List<FileObjectTransferConfig> createFileObjectTransferConfigs() throws ClientException;

    abstract Callable<MultiFileTransferResult> createMultiFileTransferTask(List<FileObjectTransferConfig> var1) throws ClientException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiFileTransferResult call() {
        try {
            this.transferProgressListener.progressUpdateReceived(new TransferProgressEvent(TransferEventType.TRANSFER_PREPARING_EVENT, null, null, 0, 0, 0, 0));
            this.doValidation();
            List<FileObjectTransferConfig> fileObjectTransferConfigs = this.createFileObjectTransferConfigs();
            Future<MultiFileTransferResult> future = this.fileTransferManager.getThreadPool().submit(this.createMultiFileTransferTask(fileObjectTransferConfigs));
            TransferTask<MultiFileTransferResult> transferTask = new TransferTask<MultiFileTransferResult>(future);
            MultiFileTransferResult multiFileTransferResult = transferTask.getResult();
            return multiFileTransferResult;
        }
        finally {
            this.fileTransferManager.getRequestCount().getAndDecrement();
        }
    }
}

