/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import oracle.cloudstorage.ftm.DirectoryTransferTask;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.MultiFileTransferResult;
import oracle.cloudstorage.ftm.MultiFileUploadTask;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.exception.DirectoryTraversalFailure;
import oracle.cloudstorage.ftm.internal.FtmFileFilter;
import oracle.cloudstorage.ftm.internal.InputValidationUtils;
import oracle.cloudstorage.ftm.internal.StringUtils;
import oracle.cloudstorage.ftm.internal.UploadFile;

class DirectoryUploadTask
extends DirectoryTransferTask {
    private UploadConfig uploadConfig;

    public DirectoryUploadTask(FileTransferManager fileTransferManager, UploadConfig uploadConfig, String containerName, String objectPrefix, File directory, boolean includeSubdirectories) {
        super(fileTransferManager, containerName, objectPrefix, directory, includeSubdirectories);
        fileTransferManager.getRequestCount().getAndIncrement();
        this.uploadConfig = uploadConfig == null ? new UploadConfig() : uploadConfig;
        this.transferProgressListener = this.uploadConfig.getTransferProgressListener();
    }

    @Override
    void doValidation() {
        InputValidationUtils.validateSourceDirectory(this.directory);
        UploadFile.verifyContainer(this.fileTransferManager.getFileTransferManagerConfig(), this.fileTransferManager.getSession(), this.containerName, this.uploadConfig.getStorageClass());
    }

    @Override
    Callable<MultiFileTransferResult> createMultiFileTransferTask(List<FileObjectTransferConfig> fileObjectTransferConfigs) {
        return new MultiFileUploadTask(this.fileTransferManager, this.uploadConfig, this.containerName, fileObjectTransferConfigs, true);
    }

    @Override
    List<FileObjectTransferConfig> createFileObjectTransferConfigs() {
        ArrayList<FileObjectTransferConfig> fileConfigs = new ArrayList<FileObjectTransferConfig>();
        List<File> fileList = new ArrayList<File>();
        if (!this.includeSubdirectories) {
            File[] files = this.directory.listFiles(new FtmFileFilter(this.uploadConfig.isExcludeHiddenFiles()));
            if (files == null) {
                throw new DirectoryTraversalFailure(this.directory.getAbsolutePath(), null);
            }
            fileList = Arrays.asList(files);
            for (File f : fileList) {
                String objectName = this.objectPrefix + f.getName();
                fileConfigs.add(new FileObjectTransferConfig(f, objectName));
            }
        } else {
            UploadDirFileVisitor fileVisitor = new UploadDirFileVisitor(fileList, this.uploadConfig.isExcludeHiddenFiles());
            try {
                Files.walkFileTree(this.directory.toPath(), fileVisitor);
                int dirPathSize = this.directory.getAbsolutePath().length();
                for (File f : fileList) {
                    String pathPrefix = f.getAbsolutePath().substring(dirPathSize);
                    String objectName = this.objectPrefix + (pathPrefix.length() - f.getName().length() > 1 ? pathPrefix : f.getName());
                    fileConfigs.add(new FileObjectTransferConfig(f, StringUtils.trimLeadingSlash(StringUtils.convertToUnixPath(objectName))));
                }
            }
            catch (Exception e) {
                throw new DirectoryTraversalFailure(this.directory.getAbsolutePath(), e);
            }
        }
        return fileConfigs;
    }

    private static class UploadDirFileVisitor
    extends SimpleFileVisitor<Path> {
        private List<File> fileList;
        private boolean excludeHiddenFiles;

        UploadDirFileVisitor(List<File> fileList, boolean excludeHiddenFiles) {
            this.fileList = fileList;
            this.excludeHiddenFiles = excludeHiddenFiles;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attr) {
            if (this.excludeHiddenFiles && file.toFile().isHidden()) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (this.excludeHiddenFiles && file.toFile().isHidden()) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            this.fileList.add(file.toFile());
            return FileVisitResult.CONTINUE;
        }
    }
}

