/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.ReAuthOnResponseStatus;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.CloudClient;
import oracle.cloudstorage.ftm.CloudStorageClass;
import oracle.cloudstorage.ftm.DirectoryDownloadTask;
import oracle.cloudstorage.ftm.DirectoryUploadTask;
import oracle.cloudstorage.ftm.DownloadConfig;
import oracle.cloudstorage.ftm.FileDownloadTask;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferAuth;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.FileUploadTask;
import oracle.cloudstorage.ftm.MultiFileDownloadTask;
import oracle.cloudstorage.ftm.MultiFileTransferResult;
import oracle.cloudstorage.ftm.MultiFileUploadTask;
import oracle.cloudstorage.ftm.TransferResult;
import oracle.cloudstorage.ftm.TransferTask;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.exception.AuthenticationFailure;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.FileTransferMangerShutdown;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.ExceptionUtils;
import oracle.cloudstorage.ftm.internal.FtmSession;
import oracle.cloudstorage.ftm.internal.FtmSessionBuilder;
import oracle.cloudstorage.ftm.internal.InputValidationUtils;
import oracle.cloudstorage.ftm.internal.MetadataUtils;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import oracle.cloudstorage.ftm.model.CloudAccount;
import oracle.cloudstorage.ftm.model.CloudContainer;
import oracle.cloudstorage.ftm.model.CloudObject;
import oracle.cloudstorage.ftm.model.DeleteObjectsResult;
import oracle.cloudstorage.ftm.model.ListContainersRequestConfig;
import oracle.cloudstorage.ftm.model.ListObjectsRequestConfig;
import oracle.cloudstorage.ftm.model.ObjectRestoreJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferManager
implements CloudClient {
    static final Logger logger = LoggerFactory.getLogger(FileTransferManager.class);
    private AtomicInteger requestCount = new AtomicInteger(0);
    private static String version;
    private static final String API_VERSION_FILEPATH = "oracle/cloudstorage/ftm/api-version.txt";
    private FileTransferAuth fileTransferAuth;
    private ISession session;
    private volatile boolean shutdown;
    private FileTransferManagerConfig managerConfig;
    private static String apiVersion;
    private ExecutorService threadPool;
    private static volatile FileTransferManager instance;

    private FileTransferManager(FileTransferManagerConfig managerConfig) {
        this.managerConfig = managerConfig != null ? managerConfig : new FileTransferManagerConfig();
        this.threadPool = Executors.newFixedThreadPool(100);
    }

    ExecutorService getThreadPool() {
        return this.threadPool;
    }

    AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    public static FileTransferManager getDefaultFileTransferManager(FileTransferAuth fileTransferAuth) throws ClientException, ServiceException {
        return FileTransferManager.getDefaultFileTransferManager(fileTransferAuth, null);
    }

    public ISession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static FileTransferManager getDefaultFileTransferManager(FileTransferAuth fileTransferAuth, FileTransferManagerConfig managerConfig) throws ClientException, ServiceException {
        if (instance == null || FileTransferManager.instance.shutdown) {
            Class<FileTransferManager> clazz = FileTransferManager.class;
            // MONITORENTER : oracle.cloudstorage.ftm.FileTransferManager.class
            if (instance == null || FileTransferManager.instance.shutdown) {
                FileTransferManager.getApiVersion();
                instance = new FileTransferManager(managerConfig);
            }
            // MONITOREXIT : clazz
        }
        if (managerConfig != null && instance.getFileTransferManagerConfig() != managerConfig) {
            instance.setFileTransferManagerConfig(managerConfig);
        }
        instance.setFileTransferAuth(fileTransferAuth);
        return instance;
    }

    public FileTransferManagerConfig getFileTransferManagerConfig() {
        return this.managerConfig;
    }

    public void setFileTransferManagerConfig(FileTransferManagerConfig managerConfig) {
        this.managerConfig = managerConfig;
    }

    public void setFileTransferAuth(FileTransferAuth fileTransferAuth) throws ClientException, ServiceException {
        this.fileTransferAuth = fileTransferAuth;
        FileTransferManager.instance.session = FileTransferManager.getSession(fileTransferAuth, this.managerConfig);
    }

    public TransferResult upload(UploadConfig uploadConfig, String containerName, String objectName, File file) throws ClientException, ServiceException {
        TransferResult result = null;
        try {
            TransferTask<TransferResult> uploadTask = this.uploadAsync(uploadConfig, containerName, objectName, file);
            result = uploadTask.getResult();
        }
        catch (ClientException ce) {
            ExceptionUtils.throwRootCause(ce);
        }
        return result;
    }

    public TransferTask<TransferResult> uploadAsync(UploadConfig uploadConfig, String containerName, String objectName, File file) throws ClientException, ServiceException {
        this.checkForShutdown();
        String object = objectName;
        if (objectName == null || objectName.isEmpty()) {
            object = file.getName();
        }
        Future<TransferResult> future = this.threadPool.submit(new FileUploadTask(this, uploadConfig, containerName, object, file, false));
        TransferTask<TransferResult> transferTask = new TransferTask<TransferResult>(future);
        return transferTask;
    }

    public MultiFileTransferResult uploadMultipleFiles(UploadConfig uploadConfig, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs) throws ClientException, ServiceException {
        MultiFileTransferResult result = null;
        try {
            TransferTask<MultiFileTransferResult> transferTask = this.uploadMultipleFilesAsync(uploadConfig, containerName, fileObjectTransferConfigs);
            result = transferTask.getResult();
        }
        catch (ClientException ce) {
            ExceptionUtils.throwRootCause(ce);
        }
        return result;
    }

    public TransferTask<MultiFileTransferResult> uploadMultipleFilesAsync(UploadConfig uploadConfig, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs) throws ClientException, ServiceException {
        this.checkForShutdown();
        Future<MultiFileTransferResult> future = this.threadPool.submit(new MultiFileUploadTask(this, uploadConfig, containerName, fileObjectTransferConfigs, false));
        TransferTask<MultiFileTransferResult> transferTask = new TransferTask<MultiFileTransferResult>(future);
        return transferTask;
    }

    public MultiFileTransferResult uploadDirectory(UploadConfig uploadConfig, String containerName, String objectPrefix, File directory, boolean includeSubdirectories) throws ClientException, ServiceException {
        MultiFileTransferResult result = null;
        try {
            TransferTask<MultiFileTransferResult> transferTask = this.uploadDirectoryAsync(uploadConfig, containerName, objectPrefix, directory, includeSubdirectories);
            result = transferTask.getResult();
        }
        catch (ClientException ce) {
            ExceptionUtils.throwRootCause(ce);
        }
        return result;
    }

    public TransferTask<MultiFileTransferResult> uploadDirectoryAsync(UploadConfig uploadConfig, String containerName, String objectPrefix, File directory, boolean includeSubdirectories) throws ClientException, ServiceException {
        this.checkForShutdown();
        Future<MultiFileTransferResult> future = this.threadPool.submit(new DirectoryUploadTask(this, uploadConfig, containerName, objectPrefix, directory, includeSubdirectories));
        TransferTask<MultiFileTransferResult> transferTask = new TransferTask<MultiFileTransferResult>(future);
        return transferTask;
    }

    public TransferResult download(DownloadConfig downloadConfig, String containerName, String objectName, File file) throws ClientException, ServiceException {
        TransferResult result = null;
        try {
            TransferTask<TransferResult> downloadTask = this.downloadAsync(downloadConfig, containerName, objectName, file);
            result = downloadTask.getResult();
        }
        catch (ClientException ce) {
            ExceptionUtils.throwRootCause(ce);
        }
        return result;
    }

    public TransferTask<TransferResult> downloadAsync(DownloadConfig downloadConfig, String containerName, String objectName, File file) throws ClientException, ServiceException {
        this.checkForShutdown();
        Future<TransferResult> future = this.threadPool.submit(new FileDownloadTask(this, downloadConfig, containerName, objectName, file, false));
        TransferTask<TransferResult> transferTask = new TransferTask<TransferResult>(future);
        return transferTask;
    }

    public MultiFileTransferResult downloadMultipleFiles(DownloadConfig downloadConfig, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs) throws ClientException, ServiceException {
        MultiFileTransferResult result = null;
        try {
            TransferTask<MultiFileTransferResult> transferTask = this.downloadMultipleFilesAsync(downloadConfig, containerName, fileObjectTransferConfigs);
            result = transferTask.getResult();
        }
        catch (ClientException ce) {
            ExceptionUtils.throwRootCause(ce);
        }
        return result;
    }

    public TransferTask<MultiFileTransferResult> downloadMultipleFilesAsync(DownloadConfig downloadConfig, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs) throws ClientException, ServiceException {
        this.checkForShutdown();
        Future<MultiFileTransferResult> future = this.threadPool.submit(new MultiFileDownloadTask(this, downloadConfig, containerName, fileObjectTransferConfigs, false));
        TransferTask<MultiFileTransferResult> transferTask = new TransferTask<MultiFileTransferResult>(future);
        return transferTask;
    }

    public MultiFileTransferResult downloadDirectory(DownloadConfig downloadConfig, String containerName, String objectPrefix, File destinationDirectory) throws ClientException, ServiceException {
        MultiFileTransferResult result = null;
        try {
            TransferTask<MultiFileTransferResult> transferTask = this.downloadDirectoryAsync(downloadConfig, containerName, objectPrefix, destinationDirectory);
            result = transferTask.getResult();
        }
        catch (ClientException ce) {
            ExceptionUtils.throwRootCause(ce);
        }
        return result;
    }

    public TransferTask<MultiFileTransferResult> downloadDirectoryAsync(DownloadConfig downloadConfig, String containerName, String objectPrefix, File destinationDirectory) throws ClientException, ServiceException {
        this.checkForShutdown();
        Future<MultiFileTransferResult> future = this.threadPool.submit(new DirectoryDownloadTask(this, downloadConfig, containerName, objectPrefix, destinationDirectory, false));
        TransferTask<MultiFileTransferResult> transferTask = new TransferTask<MultiFileTransferResult>(future);
        return transferTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.shutdown) {
            FileTransferManager fileTransferManager = this;
            synchronized (fileTransferManager) {
                if (this.shutdown) {
                    return;
                }
                logger.info("Shutdown started for FileTransferManager ...");
                this.shutdown = true;
            }
            this.waitForAllRequestsToComplete();
            this.threadPool.shutdown();
            try {
                this.threadPool.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.session != null) {
                this.session.close();
            }
            logger.info("Shutdown completed for FileTransferManager.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        if (!this.shutdown) {
            FileTransferManager fileTransferManager = this;
            synchronized (fileTransferManager) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                logger.info("Shutdown started for FileTransferManager ...");
            }
            this.threadPool.shutdownNow();
            if (this.session != null) {
                this.session.close();
            }
            logger.info("Shutdown completed for FileTransferManager.");
        }
    }

    private static ISession getSession(FileTransferAuth fileTransferAuth, FileTransferManagerConfig managerConfig) throws ClientException, AuthenticationFailure {
        IAuthReply authReply = null;
        ISession session = null;
        try {
            session = new FtmSessionBuilder(new FtmSession(managerConfig)).session();
            authReply = fileTransferAuth.getServiceName() != null && !fileTransferAuth.getServiceName().isEmpty() && fileTransferAuth.getIdentityDomain() != null && !fileTransferAuth.getIdentityDomain().isEmpty() ? session.auth().retry(new DefaultRetryStrategy(managerConfig)).keepAlive(new ReAuthOnResponseStatus(Status.UNAUTHORIZED, new Status[0])).url(fileTransferAuth.getServiceUrl()).user(fileTransferAuth.getServiceName(), fileTransferAuth.getIdentityDomain(), fileTransferAuth.getUser()).password(new String(fileTransferAuth.getAuthPassword())).send() : session.auth().retry(new DefaultRetryStrategy(managerConfig)).keepAlive(new ReAuthOnResponseStatus(Status.UNAUTHORIZED, new Status[0])).url(fileTransferAuth.getServiceUrl()).user(fileTransferAuth.getUser()).password(new String(fileTransferAuth.getAuthPassword())).send();
            logger.trace(authReply.toString());
            if (!authReply.isSuccessful()) {
                session.close();
                FileTransferManager.getApiVersion();
                logger.trace(authReply.getContext().buildDetailedMessage());
                if (authReply.getStatus().equals((Object)Status.UNAUTHORIZED)) {
                    logger.error("Authentication Failure! - verify your account information." + ExceptionUtils.getTransDetails(authReply.getContext().buildDetailedMessage()));
                    throw new AuthenticationFailure();
                }
                ServiceException se = RestApiUtils.convertToServiceException(authReply);
                logger.error(se.toStringForLogging());
                throw se;
            }
            return session;
        }
        catch (InterruptedException | RetryException e) {
            session.close();
            RestApiUtils.processRESTApiExecException(e);
        }
        catch (AuthenticationFailure | ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            logger.trace(e.toString());
            throw new ClientException("Failed to create an API session with cloud storage service. " + ExceptionUtils.getRootCauseMessage(e), e);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getApiVersion() {
        if (apiVersion != null) {
            return apiVersion;
        }
        Class<FileTransferManager> clazz = FileTransferManager.class;
        synchronized (FileTransferManager.class) {
            if (apiVersion != null) return apiVersion;
            StringBuilder ver = new StringBuilder();
            Properties prop = new Properties();
            ClassLoader cl = FileTransferManager.class.getClassLoader();
            try (InputStream input = cl.getResourceAsStream(API_VERSION_FILEPATH);){
                prop.load(input);
                String major = prop.getProperty("major");
                String minor = prop.getProperty("minor");
                String release = prop.getProperty("release");
                String build = prop.getProperty("build");
                String timestamp = prop.getProperty("timestamp");
                ver.append(major + "." + minor + "." + release);
                apiVersion = ver.toString();
                if (build != null) {
                    ver.append(" Build#" + build);
                }
                if (timestamp != null) {
                    ver.append(" TS:" + timestamp);
                }
                logger.info("File Transfer Manager API version: " + ver.toString());
                String string = apiVersion;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return string;
            }
            catch (IOException ex) {
                logger.trace(ex.getMessage());
                logger.info("Unable to get API version.");
            }
            return apiVersion;
        }
    }

    protected void finalize() throws Throwable {
        this.shutdownNow();
    }

    private void checkForShutdown() throws FileTransferMangerShutdown {
        if (this.shutdown) {
            FileTransferMangerShutdown shutdownError = new FileTransferMangerShutdown();
            throw shutdownError;
        }
    }

    private void waitForAllRequestsToComplete() {
        while (this.requestCount.intValue() != 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean objectExists(String containerName, String objectName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        return RestApiUtils.objectExists(this.managerConfig, this.session, containerName, objectName);
    }

    @Override
    public CloudContainer createContainer(String containerName, CloudStorageClass cloudStorageClass) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.createContainer(this.managerConfig, this.session, containerName, cloudStorageClass, false);
    }

    @Override
    public CloudObject getObject(String containerName, String objectName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        return RestApiUtils.getObject(this.managerConfig, this.session, containerName, objectName);
    }

    @Override
    public boolean containerExists(String containerName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.containerExists(this.managerConfig, this.session, containerName);
    }

    @Override
    public List<String> listContainers() throws ClientException, ServiceException {
        return RestApiUtils.listContainers(this.managerConfig, this.session);
    }

    @Override
    public List<String> listContainers(ListContainersRequestConfig listContainersRequestConfig) throws ClientException, ServiceException {
        InputValidationUtils.validateListContainersRequestConfig(listContainersRequestConfig);
        return RestApiUtils.listContainers(this.managerConfig, this.session, listContainersRequestConfig);
    }

    @Override
    public void deleteContainer(String containerName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        RestApiUtils.deleteContainer(this.managerConfig, this.session, containerName);
    }

    @Override
    public CloudContainer getContainer(String containerName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.getContainer(this.managerConfig, this.session, containerName);
    }

    @Override
    public void deleteObject(String containerName, String objectName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        RestApiUtils.deleteObject(this.managerConfig, this.session, containerName, objectName);
    }

    @Override
    public ObjectRestoreJob restoreObject(String containerName, String objectName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        return RestApiUtils.restoreObject(this.managerConfig, this.session, containerName, objectName);
    }

    @Override
    public List<String> listObjects(String containerName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.listObjects(this.managerConfig, this.session, containerName, null);
    }

    @Override
    public List<String> listObjects(String containerName, ListObjectsRequestConfig listObjectsRequestConfig) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.listObjects(this.managerConfig, this.session, containerName, listObjectsRequestConfig);
    }

    @Override
    public CloudAccount getAccount() throws ClientException, ServiceException {
        return RestApiUtils.getAccount(this.managerConfig, this.session);
    }

    @Override
    public ObjectRestoreJob getObjectRestoreJob(String containerName, String objectName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        return RestApiUtils.getObjectRestoreJob(this.managerConfig, this.session, containerName, objectName);
    }

    @Override
    public DeleteObjectsResult deleteObjects(String containerName, List<String> objectNames) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.deleteObjects(this.managerConfig, this.session, containerName, objectNames, this.threadPool);
    }

    @Override
    public CloudContainer createSSEEnabledContainer(String containerName, CloudStorageClass cloudStorageClass) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        return RestApiUtils.createContainer(this.managerConfig, this.session, containerName, cloudStorageClass, true);
    }

    @Override
    public void forceDeleteContainer(String containerName) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        RestApiUtils.forceDeleteContainer(this.managerConfig, this.session, containerName, this.threadPool);
    }

    @Override
    public void setObjectMetadata(String containerName, String objectName, Map<String, String> customMetadata, Map<String, String> systemMetadata) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        InputValidationUtils.validateObjectMetadataInput(customMetadata, systemMetadata);
        RestApiUtils.setObjectMetadata(this.managerConfig, this.session, containerName, objectName, MetadataUtils.cloneMetadata(customMetadata), MetadataUtils.cloneMetadata(systemMetadata));
    }

    @Override
    public void updateObjectMetadata(String containerName, String objectName, Map<String, String> customMetadata, Map<String, String> systemMetadata) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectName(objectName);
        InputValidationUtils.validateObjectMetadataInput(customMetadata, systemMetadata);
        RestApiUtils.updateObjectMetadata(this.managerConfig, this.session, containerName, objectName, MetadataUtils.cloneMetadata(customMetadata), MetadataUtils.cloneMetadata(systemMetadata));
    }

    @Override
    public void updateContainerMetadata(String containerName, Map<String, String> customMetadata, Map<String, String> systemMetadata) throws ClientException, ServiceException {
        InputValidationUtils.validateContainerName(containerName);
        InputValidationUtils.validateObjectMetadataInput(customMetadata, systemMetadata);
        RestApiUtils.updateContainerMetadata(this.managerConfig, this.session, containerName, MetadataUtils.cloneMetadata(customMetadata), MetadataUtils.cloneMetadata(systemMetadata));
    }

    @Override
    public void updateAccountMetadata(Map<String, String> customMetadata, Map<String, String> systemMetadata) throws ClientException, ServiceException {
        InputValidationUtils.validateObjectMetadataInput(customMetadata, systemMetadata);
        RestApiUtils.updateAccountMetadata(this.managerConfig, this.session, MetadataUtils.cloneMetadata(customMetadata), MetadataUtils.cloneMetadata(systemMetadata));
    }

    static {
        instance = null;
    }
}

