/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.util.concurrent.Callable;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.TransferResult;
import oracle.cloudstorage.ftm.TransferState;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.ObjectExists;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.internal.RestoreInProgressException;

abstract class FileTransferTask
implements Callable<TransferResult> {
    protected FileTransferManager fileTransferManager;
    protected String containerName;
    protected String objectName;
    protected File file;
    protected boolean multiFileTransfer;

    public FileTransferTask(FileTransferManager fileTransferManager, String containerName, String objectName, File file, boolean multiFileTransfer) {
        if (!multiFileTransfer) {
            fileTransferManager.getRequestCount().getAndIncrement();
        }
        this.fileTransferManager = fileTransferManager;
        this.containerName = containerName;
        this.objectName = objectName;
        this.file = file;
        this.multiFileTransfer = multiFileTransfer;
    }

    abstract void doValidation();

    abstract void doTransfer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferResult call() {
        TransferResult result;
        block12: {
            result = new TransferResult();
            result.setFileName(this.file.getName());
            result.setAbsoluteFilePath(this.file.getAbsolutePath());
            result.setObjectName(this.objectName);
            result.setContainer(this.containerName);
            result.setState(TransferState.InProgress);
            try {
                this.doValidation();
                this.doTransfer();
                result.setState(TransferState.Completed);
            }
            catch (RestoreInProgressException rpe) {
                result.setState(TransferState.RestoreInProgress);
                result.setRestoreCompletedPercentage(rpe.getCompletedPercentage());
            }
            catch (ClientException ce) {
                if (this.multiFileTransfer) {
                    if (ce instanceof ServiceException) {
                        result.setHttpStatusCode(((ServiceException)ce).getHttpStatusCode());
                    }
                    if (ce instanceof ObjectExists) {
                        result.setState(TransferState.Skipped);
                    } else {
                        result.setState(TransferState.Failed);
                    }
                    result.setMessage(ce.getMessage());
                    break block12;
                }
                throw ce;
            }
            finally {
                if (!this.multiFileTransfer) {
                    this.fileTransferManager.getRequestCount().getAndDecrement();
                }
            }
        }
        return result;
    }
}

