/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.FileTransferTask;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.internal.InputValidationUtils;
import oracle.cloudstorage.ftm.internal.UploadFile;

class FileUploadTask
extends FileTransferTask {
    private UploadConfig uploadConfig;

    public FileUploadTask(FileTransferManager fileTransferManager, UploadConfig uploadConfig, String containerName, String objectName, File file, boolean multiFileTransfer) {
        super(fileTransferManager, containerName, objectName, file, multiFileTransfer);
        this.uploadConfig = uploadConfig == null ? new UploadConfig() : uploadConfig;
    }

    @Override
    public void doValidation() {
        if (!this.multiFileTransfer) {
            InputValidationUtils.validateContainerName(this.containerName);
            UploadFile.verifyContainer(this.fileTransferManager.getFileTransferManagerConfig(), this.fileTransferManager.getSession(), this.containerName, this.uploadConfig.getStorageClass());
        }
        InputValidationUtils.validateObjectName(this.objectName);
    }

    @Override
    public void doTransfer() {
        UploadFile.upload(this.fileTransferManager, this.uploadConfig, this.fileTransferManager.getThreadPool(), this.containerName, this.objectName, this.file);
    }
}

