/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import oracle.cloudstorage.ftm.DownloadConfig;
import oracle.cloudstorage.ftm.FileDownloadTask;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.MultiFileTransferTask;
import oracle.cloudstorage.ftm.TransferResult;
import oracle.cloudstorage.ftm.internal.InputValidationUtils;

class MultiFileDownloadTask
extends MultiFileTransferTask {
    private DownloadConfig downloadConfig;

    public MultiFileDownloadTask(FileTransferManager fileTransferManager, DownloadConfig downloadConfig, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs, boolean directoryTransfer) {
        super(fileTransferManager, containerName, fileObjectTransferConfigs, directoryTransfer);
        this.downloadConfig = downloadConfig == null ? new DownloadConfig() : downloadConfig;
        this.setTransferProgressListener(this.downloadConfig.getTransferProgressListener());
    }

    @Override
    void doValidation() {
        if (!this.directoryTransfer) {
            InputValidationUtils.validateContainerName(this.containerName);
        }
    }

    @Override
    Callable<TransferResult> createFileTransferTask(String objectName, File file) {
        return new FileDownloadTask(this.fileTransferManager, this.downloadConfig, this.containerName, objectName, file, true);
    }
}

