/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.util.ArrayList;
import java.util.List;
import oracle.cloudstorage.ftm.MultiFileTransferState;
import oracle.cloudstorage.ftm.TransferResult;

public class MultiFileTransferResult {
    private MultiFileTransferState state;
    private List<TransferResult> completedTransferResults;
    private List<TransferResult> failedTransferResults;
    private List<TransferResult> skippedTransferResults;
    private int httpStatusCode;
    private String message;
    private String container;

    public MultiFileTransferResult() {
        this.completedTransferResults = new ArrayList<TransferResult>();
        this.failedTransferResults = new ArrayList<TransferResult>();
        this.skippedTransferResults = new ArrayList<TransferResult>();
    }

    public MultiFileTransferResult(MultiFileTransferState transferState, List<TransferResult> completedTransferResults, List<TransferResult> failedTransferResults, List<TransferResult> skippedTransferResults, int httpStatusCode, String message, String container) {
        this.state = transferState;
        this.completedTransferResults = completedTransferResults;
        this.failedTransferResults = failedTransferResults;
        this.skippedTransferResults = skippedTransferResults;
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        this.container = container;
    }

    public MultiFileTransferState getState() {
        return this.state;
    }

    public void setTransferState(MultiFileTransferState transferState) {
        this.state = transferState;
    }

    public List<TransferResult> getCompletedTransferResults() {
        return this.completedTransferResults;
    }

    public void setCompletedTransferResults(List<TransferResult> completedTransferResults) {
        this.completedTransferResults = completedTransferResults;
    }

    public List<TransferResult> getFailedTransferResults() {
        return this.failedTransferResults;
    }

    public List<TransferResult> getSkippedTransferResults() {
        return this.skippedTransferResults;
    }

    public void setFailedTransferResults(List<TransferResult> failedTransferResults) {
        this.failedTransferResults = failedTransferResults;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container: " + this.container + " State: " + (Object)((Object)this.state) + " httpStatusCode: " + this.httpStatusCode + " message: " + this.message + " Completed#: " + this.completedTransferResults.size() + " Failed#: " + this.failedTransferResults.size());
        if (this.completedTransferResults.size() > 0) {
            sb.append("\n Completed Transfers:");
            for (TransferResult tr : this.completedTransferResults) {
                sb.append("\n" + tr.toString());
            }
        }
        if (this.failedTransferResults.size() > 0) {
            sb.append("\n Failed Transfers:");
            for (TransferResult tr : this.failedTransferResults) {
                sb.append("\n" + tr.toString());
            }
        }
        if (this.skippedTransferResults.size() > 0) {
            sb.append("\n Skipped Transfers:");
            for (TransferResult tr : this.skippedTransferResults) {
                sb.append("\n" + tr.toString());
            }
        }
        return sb.toString();
    }
}

