/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.MultiFileTransferResult;
import oracle.cloudstorage.ftm.MultiFileTransferState;
import oracle.cloudstorage.ftm.TransferResult;
import oracle.cloudstorage.ftm.TransferState;
import oracle.cloudstorage.ftm.model.TransferEventType;
import oracle.cloudstorage.ftm.model.TransferProgressEvent;
import oracle.cloudstorage.ftm.model.TransferProgressListener;

abstract class MultiFileTransferTask
implements Callable<MultiFileTransferResult> {
    protected FileTransferManager fileTransferManager;
    protected String containerName;
    protected List<FileObjectTransferConfig> fileObjectTransferConfigs;
    protected boolean directoryTransfer;
    protected TransferProgressListener transferProgressListener;

    public MultiFileTransferTask(FileTransferManager fileTransferManager, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs, boolean directoryTransfer) {
        if (!directoryTransfer) {
            fileTransferManager.getRequestCount().getAndIncrement();
        }
        this.fileTransferManager = fileTransferManager;
        this.containerName = containerName;
        this.fileObjectTransferConfigs = fileObjectTransferConfigs;
        this.directoryTransfer = directoryTransfer;
    }

    public TransferProgressListener getTransferProgressListener() {
        return this.transferProgressListener;
    }

    public void setTransferProgressListener(TransferProgressListener transferProgressListener) {
        this.transferProgressListener = transferProgressListener;
    }

    abstract void doValidation();

    abstract Callable<TransferResult> createFileTransferTask(String var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiFileTransferResult call() {
        MultiFileTransferResult multiFileTransferResult = new MultiFileTransferResult();
        List<TransferResult> completedResults = multiFileTransferResult.getCompletedTransferResults();
        List<TransferResult> failedResults = multiFileTransferResult.getFailedTransferResults();
        List<TransferResult> skippedResults = multiFileTransferResult.getSkippedTransferResults();
        int totalTransfers = 0;
        int failedTransfers = 0;
        int skippedTransfers = 0;
        int completedTransfers = 0;
        try {
            HashMap<Future<TransferResult>, TransferResult> FutureTransferResults = new HashMap<Future<TransferResult>, TransferResult>();
            if (!this.directoryTransfer) {
                this.createProgressEvent(TransferEventType.TRANSFER_PREPARING_EVENT, null, null, totalTransfers, completedTransfers, failedTransfers, skippedTransfers);
            }
            this.doValidation();
            ArrayList<Future<TransferResult>> futures = new ArrayList<Future<TransferResult>>();
            totalTransfers = this.fileObjectTransferConfigs.size();
            this.createProgressEvent(TransferEventType.MULTIFILE_TRANSFER_STARTED_EVENT, null, null, totalTransfers, completedTransfers, failedTransfers, skippedTransfers);
            for (FileObjectTransferConfig fileObjectTransferConfig : this.fileObjectTransferConfigs) {
                String objectName = fileObjectTransferConfig.getObjectName();
                File file = fileObjectTransferConfig.getFile();
                TransferResult result = new TransferResult();
                result.setFileName(file.getName());
                result.setAbsoluteFilePath(file.getAbsolutePath());
                result.setContainer(this.containerName);
                result.setState(TransferState.InProgress);
                result.setObjectName(objectName);
                try {
                    Future<TransferResult> future = this.fileTransferManager.getThreadPool().submit(this.createFileTransferTask(objectName, file));
                    futures.add(future);
                    FutureTransferResults.put(future, result);
                }
                catch (RejectedExecutionException ree) {
                    result.setMessage(ree.getMessage());
                    result.setState(TransferState.Failed);
                    failedResults.add(result);
                    ++failedTransfers;
                }
            }
            for (Future future : futures) {
                TransferResult result = (TransferResult)FutureTransferResults.get(future);
                TransferEventType eventType = null;
                try {
                    result = (TransferResult)future.get();
                    if (result.getState().equals((Object)TransferState.Completed)) {
                        completedResults.add(result);
                        ++completedTransfers;
                        eventType = TransferEventType.TRANSFER_COMPLETED_EVENT;
                    } else if (result.getState().equals((Object)TransferState.Skipped)) {
                        skippedResults.add(result);
                        eventType = TransferEventType.TRANSFER_SKIPPED_EVENT;
                        ++skippedTransfers;
                    } else {
                        failedResults.add(result);
                        ++failedTransfers;
                        eventType = TransferEventType.TRANSFER_FAILED_EVENT;
                    }
                }
                catch (InterruptedException | CancellationException e) {
                    result.setMessage(e.getMessage());
                    result.setState(TransferState.Cancelled);
                    failedResults.add(result);
                    ++failedTransfers;
                    eventType = TransferEventType.TRANSFER_CANCELLED_EVENT;
                }
                catch (ExecutionException ee) {
                    result.setMessage(ee.getMessage());
                    result.setState(TransferState.Failed);
                    failedResults.add(result);
                    ++failedTransfers;
                    eventType = TransferEventType.TRANSFER_FAILED_EVENT;
                }
                this.createProgressEvent(eventType, result, null, totalTransfers, completedTransfers, failedTransfers, skippedTransfers);
            }
        }
        finally {
            if (!this.directoryTransfer) {
                this.fileTransferManager.getRequestCount().getAndDecrement();
            }
        }
        multiFileTransferResult.setContainer(this.containerName);
        if (failedResults.size() > 0) {
            if (completedResults.size() > 0) {
                multiFileTransferResult.setTransferState(MultiFileTransferState.PartiallyFailed);
            } else {
                multiFileTransferResult.setTransferState(MultiFileTransferState.Failed);
            }
        } else {
            multiFileTransferResult.setTransferState(MultiFileTransferState.Completed);
        }
        this.createProgressEvent(TransferEventType.MULTIFILE_TRANSFER_COMPLETED_EVENT, null, multiFileTransferResult, totalTransfers, completedTransfers, failedTransfers, skippedTransfers);
        return multiFileTransferResult;
    }

    private void createProgressEvent(TransferEventType eventType, TransferResult transferResult, MultiFileTransferResult multiFileTransferResult, int totalTransfers, int completedTransfers, int failedTransfers, int skippedTransfers) {
        TransferProgressEvent event = new TransferProgressEvent(eventType, transferResult, multiFileTransferResult, totalTransfers, completedTransfers, failedTransfers, skippedTransfers);
        try {
            if (this.transferProgressListener != null) {
                this.transferProgressListener.progressUpdateReceived(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

