/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.FileUploadTask;
import oracle.cloudstorage.ftm.MultiFileTransferTask;
import oracle.cloudstorage.ftm.TransferResult;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.internal.StringUtils;
import oracle.cloudstorage.ftm.internal.UploadFile;

class MultiFileUploadTask
extends MultiFileTransferTask {
    private UploadConfig uploadConfig;

    public MultiFileUploadTask(FileTransferManager fileTransferManager, UploadConfig uploadConfig, String containerName, List<FileObjectTransferConfig> fileObjectTransferConfigs, boolean directoryTransfer) {
        super(fileTransferManager, containerName, fileObjectTransferConfigs, directoryTransfer);
        this.uploadConfig = uploadConfig == null ? new UploadConfig() : uploadConfig;
        this.setTransferProgressListener(this.uploadConfig.getTransferProgressListener());
    }

    @Override
    void doValidation() {
        if (!this.directoryTransfer) {
            UploadFile.verifyContainer(this.fileTransferManager.getFileTransferManagerConfig(), this.fileTransferManager.getSession(), this.containerName, this.uploadConfig.getStorageClass());
        }
    }

    @Override
    Callable<TransferResult> createFileTransferTask(String objectName, File file) {
        return new FileUploadTask(this.fileTransferManager, this.uploadConfig, this.containerName, StringUtils.convertToUnixPath(objectName), file, true);
    }
}

