/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import oracle.cloudstorage.ftm.model.TransferProgressListener;

public abstract class TransferConfig
implements Cloneable {
    private int maxThreadsPerLargeObjectTransfer = 10;
    private TransferProgressListener transferProgressListener = TransferProgressListener.NOOP;

    public TransferConfig() {
    }

    public TransferConfig(int maxThreadsPerLargeObjectTransfer) {
        this.setMaxThreadsPerLargeObjectTransfer(maxThreadsPerLargeObjectTransfer);
    }

    public TransferConfig(int maxThreadsPerLargeObjectTransfer, TransferProgressListener transferProgressListener) {
        this.maxThreadsPerLargeObjectTransfer = maxThreadsPerLargeObjectTransfer;
        this.transferProgressListener = transferProgressListener;
    }

    public int getMaxThreadsPerLargeObjectTransfer() {
        return this.maxThreadsPerLargeObjectTransfer;
    }

    public void setMaxThreadsPerLargeObjectTransfer(int maxThreadsPerLargeObjectTransfer) {
        if (maxThreadsPerLargeObjectTransfer < 1 || maxThreadsPerLargeObjectTransfer > 100) {
            throw new IllegalArgumentException("Invalid input. It must be between 1 and 100");
        }
        this.maxThreadsPerLargeObjectTransfer = maxThreadsPerLargeObjectTransfer;
    }

    public TransferProgressListener getTransferProgressListener() {
        return this.transferProgressListener;
    }

    public void setTransferProgressListener(TransferProgressListener transferProgressListener) {
        this.transferProgressListener = transferProgressListener != null ? transferProgressListener : TransferProgressListener.NOOP;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

