/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm;

import oracle.cloudstorage.ftm.CloudStorageClass;
import oracle.cloudstorage.ftm.TransferConfig;
import oracle.cloudstorage.ftm.exception.InvalidSegmentSize;

public class UploadConfig
extends TransferConfig {
    private long segmentSize = 0xC800000L;
    private CloudStorageClass storageClass = CloudStorageClass.Standard;
    private String segmentsContainer;
    private boolean overwrite = true;
    private boolean excludeHiddenFiles;

    public UploadConfig() {
    }

    public UploadConfig(int maxThreadsPerLargeObjectTransfer, long segmentSize, CloudStorageClass storageClass, String segmentsContainer, boolean overwrite) {
        super(maxThreadsPerLargeObjectTransfer);
        this.segmentSize = segmentSize;
        this.storageClass = storageClass;
        this.segmentsContainer = segmentsContainer;
        this.overwrite = overwrite;
    }

    public UploadConfig(long segmentSize, CloudStorageClass storageClass, String segmentsContainer, boolean overwrite) {
        this.segmentSize = segmentSize;
        this.storageClass = storageClass;
        this.segmentsContainer = segmentsContainer;
        this.overwrite = overwrite;
    }

    public UploadConfig(long segmentSize, CloudStorageClass storageClass, String segmentsContainer, boolean overwrite, boolean excludeHiddenFiles) {
        this(segmentSize, storageClass, segmentsContainer, overwrite);
        this.excludeHiddenFiles = excludeHiddenFiles;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(long segmentSize) {
        if (segmentSize < 0x100000L || segmentSize > 5368709122L) {
            throw new InvalidSegmentSize("1 MiB", "5 GiB");
        }
        this.segmentSize = segmentSize;
    }

    public CloudStorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(CloudStorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getSegmentsContainer() {
        return this.segmentsContainer;
    }

    public void setSegmentsContainer(String segmentsContainer) {
        this.segmentsContainer = segmentsContainer;
    }

    public boolean isExcludeHiddenFiles() {
        return this.excludeHiddenFiles;
    }

    public void setExcludeHiddenFiles(boolean excludeHiddenFiles) {
        this.excludeHiddenFiles = excludeHiddenFiles;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

