/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.cli;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.cloudstorage.ftm.DownloadConfig;
import oracle.cloudstorage.ftm.FileObjectTransferConfig;
import oracle.cloudstorage.ftm.FileTransferAuth;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.MultiFileTransferResult;
import oracle.cloudstorage.ftm.TransferResult;
import oracle.cloudstorage.ftm.TransferState;
import oracle.cloudstorage.ftm.TransferTask;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.cli.FTMParameters;
import oracle.cloudstorage.ftm.cli.FileTransferManagerCLI;
import oracle.cloudstorage.ftm.cli.logging.LogLevel;
import oracle.cloudstorage.ftm.cli.tools.FTMKeyManager;
import oracle.cloudstorage.ftm.exception.ObjectExists;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.model.AccountMetadata;
import oracle.cloudstorage.ftm.model.CloudAccount;
import oracle.cloudstorage.ftm.model.CloudContainer;
import oracle.cloudstorage.ftm.model.CloudObject;
import oracle.cloudstorage.ftm.model.ContainerMetadata;
import oracle.cloudstorage.ftm.model.ListContainersRequestConfig;
import oracle.cloudstorage.ftm.model.ListObjectsRequestConfig;
import oracle.cloudstorage.ftm.model.ObjectMetadata;
import oracle.cloudstorage.ftm.model.ObjectRestoreJob;
import oracle.cloudstorage.ftm.model.TransferEventType;
import oracle.cloudstorage.ftm.model.TransferProgressEvent;
import oracle.cloudstorage.ftm.model.TransferProgressListener;

public class FileTransferManagerApiDriver {
    private FileTransferManager fileTransferManager;
    private FileTransferManagerConfig fileTransferManagerConfig;
    private FileTransferAuth fileTransferManagerAuth;
    private FTMParameters ftmParams;
    private static final int MAX_LISTING_SIZE = 10000;
    long dataSize = 0L;

    public FileTransferManagerApiDriver(FTMParameters params) {
        this.ftmParams = params;
        this.fileTransferManagerConfig = new FileTransferManagerConfig();
        this.fileTransferManagerConfig.setMaxRestApiRetries(this.ftmParams.retries);
    }

    FileTransferManagerApiDriver(int retries) {
        this.fileTransferManagerConfig = new FileTransferManagerConfig();
        this.fileTransferManagerConfig.setMaxRestApiRetries(this.ftmParams.retries);
    }

    public void shutDownFileTransferManager() {
        this.fileTransferManager.shutdown();
    }

    public boolean authenticate() {
        FTMKeyManager km = new FTMKeyManager();
        if (this.ftmParams.authkey != null) {
            this.ftmParams.password = km.getPassword(FTMKeyManager.decodeKey(String.valueOf(this.ftmParams.authkey)).toCharArray());
        }
        if (this.ftmParams.password == null || this.ftmParams.saveAuthKey) {
            char[] password = System.console().readPassword("Enter your password: ", new Object[0]);
            this.ftmParams.password = Arrays.copyOf(password, password.length);
            Arrays.fill(password, ' ');
        }
        try {
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "Auth Reuqest url: " + this.ftmParams.authUrl + ", service: " + this.ftmParams.service + ", identity domain: " + this.ftmParams.identityDomain + ", user: " + this.ftmParams.user + ", password: XXXXX ");
            this.fileTransferManagerAuth = this.ftmParams.isGuidUser ? new FileTransferAuth(this.ftmParams.user, this.ftmParams.password, this.ftmParams.authUrl) : new FileTransferAuth(this.ftmParams.user, this.ftmParams.password, this.ftmParams.service, this.ftmParams.authUrl, this.ftmParams.identityDomain);
            this.fileTransferManager = FileTransferManager.getDefaultFileTransferManager(this.fileTransferManagerAuth, this.fileTransferManagerConfig);
            if (this.ftmParams.saveAuthKey) {
                km.storePassword(this.ftmParams.password);
                km.saveKey(FileTransferManagerCLI.propFilePath, km.generateKey().toCharArray());
            }
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("authenticating", se);
            return false;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(Thread progressThread) {
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
        long segmentSize = this.ftmParams.segmentSize * 1024L * 1024L;
        List<File> files = this.validateFiles();
        if (files == null) {
            return false;
        }
        if (!this.authenticate()) {
            return false;
        }
        if (progressThread != null && !progressThread.isAlive()) {
            progressThread.start();
        }
        CloudContainer container = null;
        UploadConfig uploadConfig = null;
        try {
            uploadConfig = new UploadConfig(this.ftmParams.maxThreads, segmentSize, this.ftmParams.storageClass, this.ftmParams.segmentsContainer, this.ftmParams.overwrite);
        }
        catch (IllegalArgumentException ex) {
            this.ExceptionLogger("Thread Count: " + ex.getMessage());
            return false;
        }
        try {
            container = this.fileTransferManager.getContainer(this.ftmParams.container);
        }
        catch (ServiceException se) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINEST, "GET Container Exception ", se.getMessage());
        }
        if (this.ftmParams.ssencryption) {
            if (container == null) {
                this.fileTransferManager.createSSEEnabledContainer(this.ftmParams.container, this.ftmParams.storageClass);
            } else if (container.getServerSideEncryptionPolicy() == null || container.getServerSideEncryptionPolicy().isEmpty()) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Container [" + this.ftmParams.container + "] already exists and it is NOT configured for encryption." + " Try a new container or one that is configured for encryption.");
                return false;
            }
        } else if (container != null && container.getServerSideEncryptionPolicy() != null && !container.getServerSideEncryptionPolicy().isEmpty()) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Container [" + this.ftmParams.container + "] already exists and it is configured for encryption." + " Try a new container or one that is not configured for encryption.");
            return false;
        }
        if (files.size() > 1) {
            return this.uploadMultipleFiles(uploadConfig, files);
        }
        if (files.get(0).isDirectory()) {
            return this.uploadDirectory(uploadConfig, files.get(0));
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Uploading file: " + this.ftmParams.fileName + " to container: " + this.ftmParams.container);
        try {
            long startTime = System.currentTimeMillis();
            TransferResult uploadResult = this.fileTransferManager.upload(uploadConfig, this.ftmParams.container, this.ftmParams.destinationObjectName, files.get(0));
            long endTime = System.currentTimeMillis();
            if (uploadResult.getState().equals((Object)TransferState.Completed)) {
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File successfully uploaded: " + this.ftmParams.fileName);
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Estimated Transfer Rate: " + this.getTransferRate(files.get(0).length(), endTime - startTime) + "KB/s");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (ObjectExists oe) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, this.ftmParams.fileName + " SKIPPED. It already exists in container: " + this.ftmParams.container);
            boolean bl = false;
            return bl;
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("uploading files", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(Thread progressThread) {
        if (!this.authenticate()) {
            return false;
        }
        if (progressThread != null && !progressThread.isAlive()) {
            progressThread.start();
        }
        if (this.ftmParams.directory) {
            File file;
            if (!this.ftmParams.outputFilePath.contains(File.separator)) {
                this.ftmParams.outputFilePath = Paths.get("", new String[0]).toAbsolutePath() + File.separator + this.ftmParams.outputFilePath;
            }
            if (!(file = new File(this.ftmParams.outputFilePath)).mkdir()) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Could not create directory: " + this.ftmParams.outputFilePath);
                return false;
            }
            return this.downloadDirectory(file);
        }
        if (!this.ftmParams.outputFilePath.contains(File.separator)) {
            this.ftmParams.outputFilePath = Paths.get("", new String[0]).toAbsolutePath() + File.separator + this.ftmParams.outputFilePath;
        }
        File file = new File(this.ftmParams.outputFilePath);
        DownloadConfig downloadConfig = null;
        try {
            downloadConfig = new DownloadConfig(this.ftmParams.maxThreads);
        }
        catch (IllegalArgumentException ex) {
            this.ExceptionLogger("Thread Count: " + ex.getMessage());
            return false;
        }
        downloadConfig.setDownloadRestoredObjectOnly(true);
        FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Downloading file: " + this.ftmParams.fileName);
        try {
            long startTime = System.currentTimeMillis();
            TransferResult downloadResult = this.fileTransferManager.download(downloadConfig, this.ftmParams.container, this.ftmParams.fileName, file);
            long endTime = System.currentTimeMillis();
            if (downloadResult.getState().equals((Object)TransferState.Completed)) {
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File successfully downloaded to: " + this.ftmParams.outputFilePath);
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Estimated Transfer Rate: " + this.getTransferRate(file.length(), endTime - startTime) + "KB/s");
                boolean bl = true;
                return bl;
            }
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Download Failed - result code: " + downloadResult.getHttpStatusCode() + ", message: " + downloadResult.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("downloading files", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadDirectory(UploadConfig uploadConfig, File dir) {
        boolean result = true;
        this.dataSize = 0L;
        uploadConfig.setTransferProgressListener(new TransferProgressListener(){

            @Override
            public void progressUpdateReceived(TransferProgressEvent event) {
                if (event.getEventType().equals((Object)TransferEventType.TRANSFER_COMPLETED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File uploaded: " + event.getTransferResult().getFileName());
                    File f = new File(event.getTransferResult().getAbsoluteFilePath());
                    FileTransferManagerApiDriver.this.dataSize += f.length();
                } else if (event.getEventType().equals((Object)TransferEventType.TRANSFER_SKIPPED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File skipped: " + event.getTransferResult().getFileName());
                    FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, event.getTransferResult().getMessage());
                } else if (event.getEventType().equals((Object)TransferEventType.TRANSFER_FAILED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File failed: " + event.getTransferResult().getFileName());
                    FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, event.getTransferResult().getMessage());
                }
                FileTransferManagerCLI.consoleHandler.flush();
            }
        });
        FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Uploading directory: " + this.ftmParams.fileName + " to container: " + this.ftmParams.container);
        try {
            long startTime = System.currentTimeMillis();
            TransferTask<MultiFileTransferResult> uploadTask = this.fileTransferManager.uploadDirectoryAsync(uploadConfig, this.ftmParams.container, this.ftmParams.destinationObjectName + File.separatorChar, dir, true);
            MultiFileTransferResult uploadResult = uploadTask.getResult();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) attempted: " + (uploadResult.getCompletedTransferResults().size() + uploadResult.getFailedTransferResults().size()));
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) succeeded: " + uploadResult.getCompletedTransferResults().size());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) skipped: " + uploadResult.getSkippedTransferResults().size() + ". See Log for details.");
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) failed: " + uploadResult.getFailedTransferResults().size() + ". See Log for details.");
            long endTime = System.currentTimeMillis();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Estimated Transfer Rate: " + this.getTransferRate(this.dataSize, endTime - startTime) + "KB/s");
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("uploading directory", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadMultipleFiles(UploadConfig uploadConfig, List<File> files) {
        boolean result = true;
        uploadConfig.setTransferProgressListener(new TransferProgressListener(){

            @Override
            public void progressUpdateReceived(TransferProgressEvent event) {
                if (event.getEventType().equals((Object)TransferEventType.TRANSFER_COMPLETED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File uploaded: " + event.getTransferResult().getFileName());
                    File f = new File(event.getTransferResult().getAbsoluteFilePath());
                    FileTransferManagerApiDriver.this.dataSize += f.length();
                } else if (event.getEventType().equals((Object)TransferEventType.TRANSFER_SKIPPED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File skipped: " + event.getTransferResult().getFileName());
                    FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, event.getTransferResult().getMessage());
                } else if (event.getEventType().equals((Object)TransferEventType.TRANSFER_FAILED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File failed: " + event.getTransferResult().getFileName());
                    FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, event.getTransferResult().getMessage());
                }
                FileTransferManagerCLI.consoleHandler.flush();
            }
        });
        LinkedList<FileObjectTransferConfig> fileTransfers = new LinkedList<FileObjectTransferConfig>();
        for (File file : files) {
            fileTransfers.add(new FileObjectTransferConfig(file, file.getName()));
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Uploading file: " + this.ftmParams.fileName + " to container: " + this.ftmParams.container);
        try {
            long startTime = System.currentTimeMillis();
            TransferTask<MultiFileTransferResult> uploadTask = this.fileTransferManager.uploadMultipleFilesAsync(uploadConfig, this.ftmParams.container, fileTransfers);
            MultiFileTransferResult uploadResult = uploadTask.getResult();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) attempted: " + (uploadResult.getCompletedTransferResults().size() + uploadResult.getFailedTransferResults().size()));
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) succeeded: " + uploadResult.getCompletedTransferResults().size());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) skipped: " + uploadResult.getSkippedTransferResults().size() + "\nSee Log for details");
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File(s) failed: " + uploadResult.getFailedTransferResults().size() + "\nSee Log for details");
            long endTime = System.currentTimeMillis();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Estimated Transfer Rate: " + this.getTransferRate(this.dataSize, endTime - startTime) + "KB/s");
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("uploading files", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadDirectory(File destDir) {
        DownloadConfig downloadConfig = new DownloadConfig();
        boolean result = false;
        this.dataSize = 0L;
        downloadConfig.setTransferProgressListener(new TransferProgressListener(){

            @Override
            public void progressUpdateReceived(TransferProgressEvent event) {
                if (event.getEventType().equals((Object)TransferEventType.TRANSFER_COMPLETED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File downladed: " + event.getTransferResult().getFileName());
                    File f = new File(event.getTransferResult().getAbsoluteFilePath());
                    FileTransferManagerApiDriver.this.dataSize += f.length();
                } else if (event.getEventType().equals((Object)TransferEventType.TRANSFER_FAILED_EVENT)) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "File failed: " + event.getTransferResult().getFileName());
                    FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, event.getTransferResult().getMessage());
                }
                FileTransferManagerCLI.consoleHandler.flush();
            }
        });
        try {
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Downloading files with path: " + this.ftmParams.fileName + " from container: " + this.ftmParams.container);
            if (this.ftmParams.fileName.endsWith("*")) {
                this.ftmParams.fileName = this.ftmParams.fileName.substring(0, this.ftmParams.fileName.length() - 1);
            }
            long startTime = System.currentTimeMillis();
            TransferTask<MultiFileTransferResult> downloadTask = this.fileTransferManager.downloadDirectoryAsync(downloadConfig, this.ftmParams.container, this.ftmParams.fileName, destDir);
            MultiFileTransferResult downloadResult = downloadTask.getResult();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Files Attempted: " + downloadResult.getCompletedTransferResults().size() + "\nFiles Downloaded: " + downloadResult.getCompletedTransferResults().size() + "\nFiles Failed: " + downloadResult.getFailedTransferResults().size());
            long endTime = System.currentTimeMillis();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Estimated Transfer Rate: " + this.getTransferRate(this.dataSize, endTime - startTime) + "KB/s");
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "Download Completed. State:" + downloadResult.toString());
            result = true;
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("downloading directory", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore() {
        if (!this.authenticate()) {
            return false;
        }
        if (this.ftmParams.statusOnly) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Getting Restore status: " + this.ftmParams.fileName);
            try {
                ObjectRestoreJob restoreJob = this.fileTransferManager.getObjectRestoreJob(this.ftmParams.container, this.ftmParams.fileName);
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Restore Status: " + restoreJob.getJobStatus().toString() + " Restore Percentage: " + restoreJob.getCompletedPercentage() + "%");
            }
            catch (ServiceException se) {
                this.ServiceExceptionLogger("getting restore status", se);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    this.ExceptionLogger("Could not get Restore Status. File may be in archived state.");
                } else {
                    this.ExceptionLogger(e.getMessage());
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.shutDownFileTransferManager();
            }
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Restoring object: " + this.ftmParams.fileName);
        try {
            ObjectRestoreJob restoreJob = this.fileTransferManager.restoreObject(this.ftmParams.container, this.ftmParams.fileName);
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Restore Status: " + restoreJob.getJobStatus().toString() + " Restore Percentage: " + restoreJob.getCompletedPercentage() + "%");
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("restoring object", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Thread progressThread) {
        if (!this.ftmParams.outputFilePath.contains(File.separator)) {
            this.ftmParams.outputFilePath = Paths.get("", new String[0]).toAbsolutePath() + File.separator + this.ftmParams.outputFilePath;
        }
        if (!this.authenticate()) {
            return false;
        }
        if (progressThread != null && !progressThread.isAlive()) {
            progressThread.start();
        }
        try {
            if (this.ftmParams.fileName.length() == 0) {
                if (this.ftmParams.force) {
                    this.fileTransferManager.forceDeleteContainer(this.ftmParams.container);
                } else {
                    this.fileTransferManager.deleteContainer(this.ftmParams.container);
                }
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Container successfully deleted: " + this.ftmParams.container);
            } else {
                this.fileTransferManager.deleteObject(this.ftmParams.container, this.ftmParams.fileName);
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Object successfully deleted: " + this.ftmParams.fileName);
            }
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("deleting", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listContainers() {
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
        if (!this.authenticate()) {
            return false;
        }
        try {
            List<String> containers;
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "Listing containers...");
            ListContainersRequestConfig listContainersRequestConfig = new ListContainersRequestConfig();
            listContainersRequestConfig.setPrefix(this.ftmParams.prefix);
            listContainersRequestConfig.setDelimiter(this.ftmParams.delimiter);
            listContainersRequestConfig.setMarker(this.ftmParams.marker);
            listContainersRequestConfig.setEndMarker(this.ftmParams.endMarker);
            if (this.ftmParams.limit > 0) {
                listContainersRequestConfig.setLimit(this.ftmParams.limit);
            }
            String marker = "";
            do {
                if (!marker.isEmpty()) {
                    listContainersRequestConfig.setMarker(marker);
                }
                containers = this.fileTransferManager.listContainers(listContainersRequestConfig);
                for (String container : containers) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, container);
                }
                if (containers.size() > 1) {
                    marker = containers.get(containers.size() - 1);
                }
                if (containers.size() != 10000 || this.ftmParams.listAll) continue;
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "There may be more items to be listed in your query since you have reached the maximum listing limit. You can get all of your items with the --all flag which will span multiple requests. OR specify --marker with the following value to get remaining items: " + marker);
            } while (containers.size() == 10000 && this.ftmParams.listAll);
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("listing containers", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listObjects() {
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
        if (!this.authenticate()) {
            return false;
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "Listing objects in container: " + this.ftmParams.container);
        try {
            List<String> objects;
            ListObjectsRequestConfig listObjectsRequestConfig = new ListObjectsRequestConfig();
            listObjectsRequestConfig.setPrefix(this.ftmParams.prefix);
            listObjectsRequestConfig.setDelimiter(this.ftmParams.delimiter);
            listObjectsRequestConfig.setMarker(this.ftmParams.marker);
            listObjectsRequestConfig.setEndMarker(this.ftmParams.endMarker);
            if (this.ftmParams.limit > 0) {
                listObjectsRequestConfig.setLimit(this.ftmParams.limit);
            }
            String marker = "";
            do {
                if (!marker.isEmpty()) {
                    listObjectsRequestConfig.setMarker(marker);
                }
                objects = this.fileTransferManager.listObjects(this.ftmParams.container, listObjectsRequestConfig);
                for (String object : objects) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, object);
                }
                if (objects.size() > 1) {
                    marker = objects.get(objects.size() - 1);
                }
                if (objects.size() != 10000 || this.ftmParams.listAll) continue;
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "There may be more items to be listed in your query since you have reached the maximum listing limit. You can get all of your items with the --all flag which will span multiple requests. OR specify --marker with the following value to get remaining items: " + marker);
            } while (objects.size() == 10000 && this.ftmParams.listAll);
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("listing objects", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean describeAccount() {
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
        if (!this.authenticate()) {
            return false;
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "describing account...");
        try {
            CloudAccount account = this.fileTransferManager.getAccount();
            String archivePolicy = account.getMetadata().getPolicyArchive() == null ? "N/A" : account.getMetadata().getPolicyArchive();
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "                 Name: " + account.getName());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "      Container Count: " + account.getContainerCount());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "         Object Count: " + account.getObjectCount());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "           Bytes Used: " + account.getBytesUsed());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "          Bytes Quota: " + account.getMetadata().getQuotaBytes());
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "       Archive Policy: " + archivePolicy);
            FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Georeplication Policy: " + account.getMetadata().getPolicyGeoreplication());
            AccountMetadata metadata = account.getMetadata();
            if (metadata.getCustomMetadata() != null && metadata.getCustomMetadata().size() > 0) {
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "\nCustom Metadata");
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "---------------");
            }
            for (String key : metadata.getCustomMetadata().keySet()) {
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, key + ": " + metadata.getCustomMetadata().get(key));
            }
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("describing account", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean describeContainer() {
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
        if (!this.authenticate()) {
            return false;
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "describing container: " + this.ftmParams.container);
        try {
            CloudContainer cloudContainer = this.fileTransferManager.getContainer(this.ftmParams.container);
            if (cloudContainer == null) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Container not found: " + this.ftmParams.container);
            } else {
                ContainerMetadata metadata;
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "                  Name: " + cloudContainer.getName());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "          Object Count: " + cloudContainer.getObjectCount());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "            Bytes Used: " + cloudContainer.getBytesUsed());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "         Storage Class: " + cloudContainer.getStorageClass());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "         Creation Date: " + cloudContainer.getCreationDate());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "         Last Modified: " + cloudContainer.getLastModifiedDate());
                if (cloudContainer.getServerSideEncryptionPolicy() != null) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Server Side Encryption: " + cloudContainer.getServerSideEncryptionPolicy());
                }
                if ((metadata = cloudContainer.getMetadata()).getCustomMetadata() != null && metadata.getCustomMetadata().size() > 0) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "\nCustom Metadata");
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "---------------");
                }
                for (String key : metadata.getCustomMetadata().keySet()) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, key + ": " + metadata.getCustomMetadata().get(key));
                }
            }
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("describing container", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean describeObject() {
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
        if (!this.authenticate()) {
            return false;
        }
        FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "describing object in container[" + this.ftmParams.container + "]: " + this.ftmParams.fileName);
        try {
            CloudObject cloudObject = this.fileTransferManager.getObject(this.ftmParams.container, this.ftmParams.fileName);
            if (cloudObject == null) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Object not found in container: " + this.ftmParams.container);
            } else {
                ObjectMetadata metadata;
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "          Name: " + cloudObject.getName());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "     Container: " + cloudObject.getContainer());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "          ETag: " + cloudObject.getETag());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "Content Length: " + cloudObject.getContentLength());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "  Content Type: " + cloudObject.getContentType());
                FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, " Last Modified: " + cloudObject.getLastModifiedDate());
                if (cloudObject.getManifest() != null && !cloudObject.getManifest().isEmpty()) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "      Manifest: " + cloudObject.getManifest());
                }
                if (cloudObject.isSLO()) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "           SLO: True");
                }
                if ((metadata = cloudObject.getObjectMetadata()).getCustomMetadata() != null && metadata.getCustomMetadata().size() > 0) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "\nCustom Metadata");
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, "---------------");
                }
                for (Map.Entry<String, String> entry : metadata.getCustomMetadata().entrySet()) {
                    FileTransferManagerCLI.cliLogger.log(LogLevel.INFO, entry.getKey() + ": " + entry.getValue());
                }
            }
        }
        catch (ServiceException se) {
            this.ServiceExceptionLogger("describing object", se);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.ExceptionLogger("Object [" + this.ftmParams.fileName + "] Not Found in container: " + this.ftmParams.container + ". " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutDownFileTransferManager();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setObjectMetadata() {
        block9: {
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
            if (!this.authenticate()) {
                return false;
            }
            try {
                if (this.ftmParams.custommetadata != null && this.ftmParams.metadata != null) {
                    this.fileTransferManager.updateObjectMetadata(this.ftmParams.container, this.ftmParams.fileName, this.ftmParams.custommetadata, this.ftmParams.metadata);
                    break block9;
                }
                boolean bl = false;
                return bl;
            }
            catch (ServiceException se) {
                this.ServiceExceptionLogger("Setting object metadata", se);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.ExceptionLogger("Setting object metadata " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                this.shutDownFileTransferManager();
            }
        }
        this.describeObject();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setContainerMetadata() {
        block9: {
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
            if (!this.authenticate()) {
                return false;
            }
            try {
                if (this.ftmParams.custommetadata != null && this.ftmParams.metadata != null) {
                    this.fileTransferManager.updateContainerMetadata(this.ftmParams.container, this.ftmParams.custommetadata, this.ftmParams.metadata);
                    break block9;
                }
                boolean bl = false;
                return bl;
            }
            catch (ServiceException se) {
                this.ServiceExceptionLogger("Setting container metadata", se);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.ExceptionLogger("Setting container metadata " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                this.shutDownFileTransferManager();
            }
        }
        this.describeContainer();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAccountMetadata() {
        block9: {
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, this.ftmParams.toString());
            if (!this.authenticate()) {
                return false;
            }
            try {
                if (this.ftmParams.custommetadata != null && this.ftmParams.metadata != null) {
                    this.fileTransferManager.updateAccountMetadata(this.ftmParams.custommetadata, this.ftmParams.metadata);
                    break block9;
                }
                boolean bl = false;
                return bl;
            }
            catch (ServiceException se) {
                this.ServiceExceptionLogger("Setting account metadata", se);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.ExceptionLogger("Setting account metadata " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                this.shutDownFileTransferManager();
            }
        }
        this.describeAccount();
        return true;
    }

    private List<File> validateFiles() {
        LinkedList<File> files = new LinkedList<File>();
        if (this.ftmParams.fileName.contains(",")) {
            String[] names;
            for (String name : names = this.ftmParams.fileName.split(",")) {
                File file = new File(name);
                if (!file.exists()) {
                    FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "File not found: " + name);
                    return null;
                }
                if (file.isDirectory()) {
                    FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Directories cannot be specified with Files. [" + name + "] is a directory.");
                    return null;
                }
                files.add(file);
            }
        } else {
            File file = new File(this.ftmParams.fileName);
            if (!file.exists()) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "File/Directory not found: " + this.ftmParams.fileName);
                return null;
            }
            files.add(file);
        }
        return files;
    }

    private String getTransferRate(long fileSize, long delta) {
        String rate = "-- ";
        int kbs = (int)((double)fileSize / 1024.0 / ((double)delta / 1000.0));
        if (kbs > 0) {
            rate = "" + kbs;
        }
        return rate;
    }

    private void ServiceExceptionLogger(String msg, ServiceException se) {
        FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Exception " + msg + ": " + se.getMessage() + "\n StatusCode: " + se.getHttpStatusCode() + "\nTransaction Id: " + se.getRequestId());
        if (se.getCause() != null) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "cause " + se.getCause());
        }
    }

    private void ExceptionLogger(String msg) {
        FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Exception: " + msg);
    }
}

