/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.cli;

import java.io.File;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import oracle.cloudstorage.ftm.cli.FileTransferManagerApiDriver;
import oracle.cloudstorage.ftm.cli.logging.ConsoleFormatter;
import oracle.cloudstorage.ftm.cli.logging.FileFormatter;
import oracle.cloudstorage.ftm.cli.logging.LogLevel;
import oracle.cloudstorage.ftm.cli.tools.Parser;
import org.apache.log4j.PropertyConfigurator;

public class FileTransferManagerCLI {
    public static String propFilePath = "ftmcli.properties";
    private static final LogManager logManager = LogManager.getLogManager();
    public static final Logger cliLogger = Logger.getLogger("oracle.cloudstorage.ftm.cli");
    private static final String logHeaderformat = "%d{yyyy/MM/dd HH:mm:ss.SSS} [%5p] %t (%F) - %m%n";
    public static final ConsoleFormatter consoleFormatter = new ConsoleFormatter();
    public static final Handler consoleHandler = new StreamHandler(System.out, consoleFormatter);
    protected static Handler logHandler = null;
    public static volatile int kilobytesPerSec = 0;
    public static final FileFormatter fileFormatter = new FileFormatter();

    public static void initLogging(String logFile) {
        Properties properties = new Properties();
        properties.setProperty("log4j.appender.MyFile.File", logFile);
        properties.setProperty("log4j.rootCategory", "ALL");
        properties.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.stdout.layout.ConversionPattern", logHeaderformat);
        properties.setProperty("log4j.rootLogger", "ALL,MyFile");
        properties.setProperty("log4j.appender.MyFile", "org.apache.log4j.RollingFileAppender");
        properties.setProperty("log4j.appender.MyFile.MaxFileSize", "1024MB");
        properties.setProperty("log4j.appender.MyFile.MaxBackupIndex", "100");
        properties.setProperty("log4j.appender.MyFile.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.MyFile.layout.ConversionPattern", logHeaderformat);
        PropertyConfigurator.configure(properties);
    }

    public static void main(String[] args) {
        System.setProperty("http.agent", "Oracle-FTMCLI/2.2.5");
        if (!FileTransferManagerCLI.setupLogging(args)) {
            return;
        }
        Parser ftmParser = new Parser();
        if (!FileTransferManagerCLI.processPropertiesFile(args, ftmParser)) {
            cliLogger.log((Level)LogLevel.ERROR, "Failure to process the specified properties file.");
            return;
        }
        ftmParser.setEnvVars(System.getenv());
        Thread progressThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long btime;
                String progressBar = "###";
                long ctime = btime = System.currentTimeMillis();
                while (!Thread.interrupted()) {
                    if (progressBar.length() > 100) {
                        System.out.print("\r                                                                                \r");
                        progressBar = "###";
                    }
                    if (btime + 20000L < ctime) {
                        btime = ctime;
                        progressBar = progressBar + '#';
                    }
                    try {
                        System.out.print("\r");
                        System.out.print("###" + progressBar + "-");
                        Thread.sleep(200L);
                        System.out.print("\r");
                        System.out.print("###" + progressBar + "\\");
                        Thread.sleep(200L);
                        System.out.print("\r");
                        System.out.print("###" + progressBar + "|");
                        Thread.sleep(200L);
                        System.out.print("\r");
                        System.out.print("###" + progressBar + "/");
                        consoleHandler.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ctime = System.currentTimeMillis();
                }
                return;
            }
        });
        if (args.length == 0) {
            System.out.println("Usage: java -jar ftmcli.jar <command> [-A, --auth-url <auth url>] \n                                      [-S, --service <service>] \n                                      [-I, --identity-domain <identity domain>] \n                                      [-U, --user <user>] \n                                      [-d, --debug] \n                                      [-i, --silent] \n                                      [-v, --version] \n                                      [-h, --help] \n                                      [--properties-file <file path>] \n                                      [--save-auth-key] \n\nCommands: \nupload      Upload a file or a directory to a container.\ndownload    Download an object or a virtual directory from a container.\nrestore     Restore an object from an Archive container.\nlist        List containers in the account or objects in a container.\ndelete      Delete a container in the account or an object in a container.\ndescribe    Describes the attributes of a container in the account or an object in a container.\nset         Set the metadata attribute(s) of a container in the account or an object in a container.\n\nTo get a list of the options and arguments for a specific command, run that command\nwith the --help option\n\nExamples: \njava -jar ftmcli.jar upload --help \n\njava -jar ftmcli.jar download --auth-url https://storage.us.oraclecloud.com --service Storage \\ \n--identity-domain acme --user john.doe@oracle.com mycontainer data.txt \n\njava -jar ftmcli.jar upload mycontainer log.txt \n\njava -jar ftmcli.jar list -A https://storage.us.oraclecloud.com -S Storage -I acme \\ \n-U john.doe@oracle.com mycontainer\n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
        } else {
            try {
                boolean result = FileTransferManagerCLI.processArgs(ftmParser, args, progressThread);
                if (result) {
                    System.exit(0);
                } else {
                    System.exit(1);
                }
            }
            catch (Exception e) {
                cliLogger.log((Level)LogLevel.ERROR, "Exception: " + e.getMessage());
                cliLogger.log(LogLevel.FINE, "Exception: " + e.getStackTrace().toString());
            }
        }
    }

    public static boolean processPropertiesFile(String[] args, Parser parser) {
        boolean result = false;
        String propertiesPath = propFilePath;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equalsIgnoreCase("--properties-file") && !args[i].equalsIgnoreCase("-P") && !args[i].equalsIgnoreCase("--P")) continue;
            propertiesPath = args[i + 1];
        }
        if (!new File(propertiesPath).exists()) {
            cliLogger.log(LogLevel.INFO, "The properties file was not found - proceeding without it...");
            result = true;
        } else if (!parser.readPropertiesFile(propertiesPath)) {
            result = false;
        } else {
            result = true;
            propFilePath = propertiesPath;
        }
        return result;
    }

    public static boolean processArgs(Parser ftmParser, String[] args, Thread progressThread) {
        switch (args[0].toLowerCase()) {
            case "upload": {
                if (!ftmParser.parseUploadOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                return ftmDriver.upload(progressThread);
            }
            case "download": {
                if (!ftmParser.parseDownloadOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                return ftmDriver.download(progressThread);
            }
            case "restore": {
                if (!ftmParser.parseRestoreOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                return ftmDriver.restore();
            }
            case "delete": {
                if (!ftmParser.parseDeleteOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                return ftmDriver.delete(progressThread);
            }
            case "list": {
                if (!ftmParser.parseListOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                if (ftmParser.params.container.isEmpty()) {
                    return ftmDriver.listContainers();
                }
                return ftmDriver.listObjects();
            }
            case "describe": {
                if (!ftmParser.parseDescribeOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                if (!ftmParser.params.fileName.isEmpty()) {
                    return ftmDriver.describeObject();
                }
                if (!ftmParser.params.container.isEmpty() && ftmParser.params.fileName.isEmpty()) {
                    return ftmDriver.describeContainer();
                }
                return ftmDriver.describeAccount();
            }
            case "set": {
                if (!ftmParser.parseSetOptions(args)) break;
                FileTransferManagerApiDriver ftmDriver = new FileTransferManagerApiDriver(ftmParser.params);
                if (!ftmParser.params.fileName.isEmpty()) {
                    return ftmDriver.setObjectMetadata();
                }
                if (!ftmParser.params.container.isEmpty() && ftmParser.params.fileName.isEmpty()) {
                    return ftmDriver.setContainerMetadata();
                }
                return ftmDriver.setAccountMetadata();
            }
            case "-v": 
            case "-version": 
            case "--version": {
                cliLogger.log(LogLevel.INFO, "Version 2.2.5");
                return true;
            }
            case "--help": 
            case "-help": 
            case "-h": 
            case "help": {
                System.out.println("Usage: java -jar ftmcli.jar <command> [-A, --auth-url <auth url>] \n                                      [-S, --service <service>] \n                                      [-I, --identity-domain <identity domain>] \n                                      [-U, --user <user>] \n                                      [-d, --debug] \n                                      [-i, --silent] \n                                      [-v, --version] \n                                      [-h, --help] \n                                      [--properties-file <file path>] \n                                      [--save-auth-key] \n\nCommands: \nupload      Upload a file or a directory to a container.\ndownload    Download an object or a virtual directory from a container.\nrestore     Restore an object from an Archive container.\nlist        List containers in the account or objects in a container.\ndelete      Delete a container in the account or an object in a container.\ndescribe    Describes the attributes of a container in the account or an object in a container.\nset         Set the metadata attribute(s) of a container in the account or an object in a container.\n\nTo get a list of the options and arguments for a specific command, run that command\nwith the --help option\n\nExamples: \njava -jar ftmcli.jar upload --help \n\njava -jar ftmcli.jar download --auth-url https://storage.us.oraclecloud.com --service Storage \\ \n--identity-domain acme --user john.doe@oracle.com mycontainer data.txt \n\njava -jar ftmcli.jar upload mycontainer log.txt \n\njava -jar ftmcli.jar list -A https://storage.us.oraclecloud.com -S Storage -I acme \\ \n-U john.doe@oracle.com mycontainer\n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
                return true;
            }
            default: {
                cliLogger.log((Level)LogLevel.ERROR, "Invalid Command: " + args[0]);
                cliLogger.log(LogLevel.INFO, "Usage: java -jar ftmcli.jar <command> [-A, --auth-url <auth url>] \n                                      [-S, --service <service>] \n                                      [-I, --identity-domain <identity domain>] \n                                      [-U, --user <user>] \n                                      [-d, --debug] \n                                      [-i, --silent] \n                                      [-v, --version] \n                                      [-h, --help] \n                                      [--properties-file <file path>] \n                                      [--save-auth-key] \n\nCommands: \nupload      Upload a file or a directory to a container.\ndownload    Download an object or a virtual directory from a container.\nrestore     Restore an object from an Archive container.\nlist        List containers in the account or objects in a container.\ndelete      Delete a container in the account or an object in a container.\ndescribe    Describes the attributes of a container in the account or an object in a container.\nset         Set the metadata attribute(s) of a container in the account or an object in a container.\n\nTo get a list of the options and arguments for a specific command, run that command\nwith the --help option\n\nExamples: \njava -jar ftmcli.jar upload --help \n\njava -jar ftmcli.jar download --auth-url https://storage.us.oraclecloud.com --service Storage \\ \n--identity-domain acme --user john.doe@oracle.com mycontainer data.txt \n\njava -jar ftmcli.jar upload mycontainer log.txt \n\njava -jar ftmcli.jar list -A https://storage.us.oraclecloud.com -S Storage -I acme \\ \n-U john.doe@oracle.com mycontainer\n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
                return false;
            }
        }
        return false;
    }

    public static boolean setupLogging(String[] args) {
        cliLogger.setLevel(Level.ALL);
        cliLogger.setUseParentHandlers(false);
        consoleHandler.setLevel(LogLevel.INFO);
        consoleHandler.setFormatter(consoleFormatter);
        boolean silent = false;
        boolean enableTrace = false;
        try {
            logHandler = new FileHandler("ftmcli.log", true);
            for (String arg : args) {
                if (arg.equalsIgnoreCase("--debug") || arg.equalsIgnoreCase("-debug") || arg.equalsIgnoreCase("-d")) {
                    enableTrace = true;
                }
                if (!arg.equalsIgnoreCase("--silent") && !arg.equalsIgnoreCase("-silent") && !arg.equals("-i")) continue;
                silent = true;
            }
            if (enableTrace) {
                FileTransferManagerCLI.initLogging("ftmcli.trace");
            } else {
                FileTransferManagerCLI.initLogging("/dev/null");
            }
            if (silent) {
                consoleHandler.setLevel(LogLevel.ERROR);
            }
        }
        catch (Exception e) {
            cliLogger.log((Level)LogLevel.ERROR, "Failure creating log file: " + e.getMessage());
            return false;
        }
        logHandler.setLevel(LogLevel.FINE);
        logHandler.setFormatter(fileFormatter);
        cliLogger.addHandler(logHandler);
        cliLogger.addHandler(consoleHandler);
        logManager.addLogger(cliLogger);
        return true;
    }
}

