/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.cli.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import oracle.cloudstorage.ftm.cli.FileTransferManagerCLI;
import oracle.cloudstorage.ftm.cli.logging.LogLevel;

public class FTMKeyManager {
    static String lockStr = "WVd882zDBXXIDgw4";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKey(String propertiesFile, char[] key) {
        try {
            File propFile = new File(propertiesFile);
            if (!propFile.exists()) {
                propFile.createNewFile();
            }
        }
        catch (IOException e1) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.WARNING, "Exception creating ftmcli.properties: " + e1.getMessage());
        }
        Properties ftmcliProperties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(propertiesFile);
            ftmcliProperties.load(is);
            ftmcliProperties.setProperty("auth-key", String.valueOf(key));
            ftmcliProperties.store(new FileOutputStream(propertiesFile), "saving authkey");
        }
        catch (IOException e) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.WARNING, "Exception saving auth-key to ftmcli.properties: " + e.getMessage());
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    public void storePassword(char[] pswd) {
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            ks.load(null, lockStr.toCharArray());
            KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(lockStr.toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            SecretKey generatedSecret = factory.generateSecret(new PBEKeySpec(pswd));
            KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(generatedSecret);
            ks.setEntry("FTMsecretKey", skEntry, keyStorePP);
            FileOutputStream fos = null;
            fos = new FileOutputStream("ftmcliKeystore");
            ks.store(fos, lockStr.toCharArray());
            fos.close();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.WARNING, "Exception saving auth-key to keystore: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getPassword(char[] key) {
        char[] pswd = null;
        FileInputStream fis = null;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("JCEKS");
            fis = new FileInputStream("ftmcliKeystore");
            KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(key);
            ks.load(fis, key);
            KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ks.getEntry("FTMsecretKey", keyStorePP);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(skEntry.getSecretKey(), PBEKeySpec.class);
            pswd = keySpec.getPassword();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException | InvalidKeySpecException e) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.WARNING, "Exception processing keystore. Your auth-key may be invalid.");
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                FileTransferManagerCLI.cliLogger.log(LogLevel.WARNING, "Exception closing keystore: " + e.getMessage());
            }
        }
        return pswd;
    }

    public String generateKey() {
        String encryptedStr = "";
        try {
            SecretKeySpec skeyspec = new SecretKeySpec(lockStr.getBytes(StandardCharsets.US_ASCII), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeyspec);
            byte[] encrypted = cipher.doFinal(String.valueOf(lockStr).getBytes(StandardCharsets.US_ASCII));
            encryptedStr = DatatypeConverter.printBase64Binary((byte[])encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedStr;
    }

    public static String decodeKey(String strEncrypted) {
        String decodedStr = "";
        try {
            SecretKeySpec skeyspec = new SecretKeySpec(lockStr.getBytes(StandardCharsets.US_ASCII), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeyspec);
            byte[] decordedValue = DatatypeConverter.parseBase64Binary((String)strEncrypted);
            byte[] decrypted = cipher.doFinal(decordedValue);
            decodedStr = new String(decrypted, StandardCharsets.US_ASCII);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decodedStr;
    }
}

