/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.cli.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import oracle.cloudstorage.ftm.CloudStorageClass;
import oracle.cloudstorage.ftm.cli.FTMParameters;
import oracle.cloudstorage.ftm.cli.FileTransferManagerCLI;
import oracle.cloudstorage.ftm.cli.logging.LogLevel;

public class Parser {
    public FTMParameters params = new FTMParameters();
    private static final int OPTIONAL_ARG_WITH_FILE = 3;
    private static final int OPTIONAL_ARG_WITH_CONTAINER = 2;
    private OptionSpec<String> url;
    private OptionSpec<String> identityDomain;
    private OptionSpec<String> service;
    private OptionSpec<String> user;
    private OptionSpec<String> meta;
    private OptionSpec<String> custommeta;
    private OptionSpec<Void> debug;
    private OptionSpec<Void> silent;
    private OptionSpec<Void> saveAuthKey;
    private OptionSpec<Integer> maxThreads;
    private OptionSpec<Integer> retries;
    public final int MAX_OBJECT_SIZE_MB = 5024;
    public final int MIN_SEGMENT_SIZE_MB = 1;

    public boolean readPropertiesFile(String propertiesFile) {
        Properties ftmcliProperties = new Properties();
        try (FileInputStream is = new FileInputStream(propertiesFile);){
            ftmcliProperties.load(is);
            if (ftmcliProperties.containsKey("auth-url")) {
                this.params.authUrl = ftmcliProperties.getProperty("auth-url");
            }
            if (ftmcliProperties.containsKey("service")) {
                this.params.service = ftmcliProperties.getProperty("service");
            }
            if (ftmcliProperties.containsKey("identity-domain")) {
                this.params.identityDomain = ftmcliProperties.getProperty("identity-domain");
            }
            if (ftmcliProperties.containsKey("user")) {
                this.params.user = ftmcliProperties.getProperty("user");
            }
            if (ftmcliProperties.containsKey("auth-key")) {
                this.params.authkey = ftmcliProperties.getProperty("auth-key").toCharArray();
            }
            if (ftmcliProperties.containsKey("max-threads")) {
                this.params.maxThreads = Integer.parseInt(ftmcliProperties.getProperty("max-threads"));
            }
            if (ftmcliProperties.containsKey("retries")) {
                this.params.retries = Integer.parseInt(ftmcliProperties.getProperty("retries"));
            }
            if (ftmcliProperties.containsKey("segment-size")) {
                this.params.segmentSize = Integer.parseInt(ftmcliProperties.getProperty("segment-size"));
            }
            if (ftmcliProperties.containsKey("segments-container")) {
                this.params.segmentsContainer = ftmcliProperties.getProperty("segments-container");
            }
            this.params.storageClass = ftmcliProperties.containsKey("storage-class") && ftmcliProperties.getProperty("storage-class").equalsIgnoreCase(CloudStorageClass.Archive.toString()) ? CloudStorageClass.Archive : CloudStorageClass.Standard;
            if (ftmcliProperties.containsKey("https-proxy-host") && !ftmcliProperties.getProperty("https-proxy-host").isEmpty()) {
                System.setProperty("https.proxyHost", ftmcliProperties.getProperty("https-proxy-host"));
            }
            if (ftmcliProperties.containsKey("https-proxy-port") && !ftmcliProperties.getProperty("https-proxy-port").isEmpty()) {
                System.setProperty("https.proxyPort", ftmcliProperties.getProperty("https-proxy-port"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "Properties file not found: " + propertiesFile + ". Moving forward with the request.");
        }
        catch (NumberFormatException ne) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Failure to parse values in properties file: " + propertiesFile);
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, ne.toString());
            return false;
        }
        catch (IOException e) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Failure to process " + propertiesFile);
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, e.toString());
            return false;
        }
        return true;
    }

    public void setEnvVars(Map<String, String> map) {
        if (map.containsKey("FTM_AUTH_URL")) {
            this.params.authUrl = map.get("FTM_AUTH_URL");
        }
        if (map.containsKey("FTM_SERVICE")) {
            this.params.service = map.get("FTM_SERVICE");
        }
        if (map.containsKey("FTM_IDOMAIN")) {
            this.params.identityDomain = map.get("FTM_IDOMAIN");
        }
        if (map.containsKey("FTM_USER")) {
            this.params.user = map.get("FTM_USER");
        }
    }

    private OptionParser parseGeneralOptions() {
        OptionParser parser = new OptionParser();
        this.url = parser.acceptsAll(Arrays.asList("A", "auth-url")).withRequiredArg();
        this.identityDomain = parser.acceptsAll(Arrays.asList("I", "identity-domain")).withRequiredArg();
        this.service = parser.acceptsAll(Arrays.asList("S", "service")).withRequiredArg();
        this.user = parser.acceptsAll(Arrays.asList("U", "user")).withRequiredArg();
        this.maxThreads = parser.acceptsAll(Arrays.asList("T", "max-threads")).withRequiredArg().ofType(Integer.class);
        this.debug = parser.acceptsAll(Arrays.asList("d", "debug"));
        this.silent = parser.acceptsAll(Arrays.asList("i", "silent"));
        this.saveAuthKey = parser.accepts("save-auth-key");
        this.retries = parser.acceptsAll(Arrays.asList("R", "retries")).withRequiredArg().ofType(Integer.class);
        parser.acceptsAll(Arrays.asList("P", "properties-file")).withRequiredArg();
        return parser;
    }

    private boolean validateAndSetGeneralOptions(OptionSet options) {
        if (this.url.value(options) != null) {
            this.params.authUrl = this.url.value(options);
        } else if (this.params.authUrl.length() == 0) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "--auth-url not provided in config file or as a parameter.");
            return false;
        }
        if (this.params.authUrl.endsWith("/auth/v1.0")) {
            this.params.authUrl = this.params.authUrl.substring(0, this.params.authUrl.length() - "/auth/v1.0".length());
        }
        if (this.user.value(options) != null) {
            this.params.user = this.user.value(options);
        }
        if (this.params.user.contains(":")) {
            this.params.isGuidUser = true;
        } else if (this.params.user.length() == 0) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "--user not provided in config file or as a parameter.");
            return false;
        }
        if (this.identityDomain.value(options) != null) {
            this.params.identityDomain = this.identityDomain.value(options);
        }
        if (this.service.value(options) != null) {
            this.params.service = this.service.value(options);
        }
        if (!this.params.isGuidUser) {
            if (this.params.identityDomain.length() == 0) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "--identity-domain not specified in config file or as a parameter. It is required for your user.");
                return false;
            }
            if (this.params.service.length() == 0) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "--service not specified in config file or as a parameter. It is required for your user.");
                return false;
            }
        }
        if (this.maxThreads.value(options) != null) {
            this.params.maxThreads = this.maxThreads.value(options);
        }
        if (this.retries.value(options) != null) {
            this.params.retries = this.retries.value(options);
        }
        if (options.has(this.silent)) {
            this.params.silent = true;
        }
        if (options.has(this.saveAuthKey)) {
            this.params.saveAuthKey = true;
        }
        if (options.has(this.debug)) {
            this.params.debug = true;
        }
        return true;
    }

    private boolean validateAndSetContainerAndFileName(OptionSpec<String> nonOptions, OptionSet options) {
        if (nonOptions.values(options).size() < 3) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Specify both container name and file name.");
            return false;
        }
        if (nonOptions.values(options).size() > 3) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Unexpected parameter: " + nonOptions.values(options).get(3) + ", where container: " + nonOptions.values(options).get(1) + " and file: " + nonOptions.values(options).get(2));
            return false;
        }
        this.params.container = nonOptions.values(options).get(1);
        this.params.fileName = nonOptions.values(options).get(2);
        return true;
    }

    public boolean parseSetOptions(String[] args) {
        OptionSet options;
        OptionParser parser = this.parseGeneralOptions();
        OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
        this.meta = parser.acceptsAll(Arrays.asList("M", "metadata")).withRequiredArg();
        this.custommeta = parser.acceptsAll(Arrays.asList("C", "custom-metadata")).withRequiredArg();
        NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
        if (nonOptions.values(options = parser.parse(args)).size() > 3) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Unexpected parameter: " + (String)nonOptions.values(options).get(2) + ", where container: " + (String)nonOptions.values(options).get(1));
            return false;
        }
        if (nonOptions.values(options).size() == 3) {
            this.params.container = (String)nonOptions.values(options).get(1);
            this.params.fileName = (String)nonOptions.values(options).get(2);
        } else if (nonOptions.values(options).size() == 2) {
            this.params.container = (String)nonOptions.values(options).get(1);
            this.params.fileName = "";
        } else if (nonOptions.values(options).size() == 1) {
            this.params.container = "";
            this.params.fileName = "";
        }
        if (options.has(help)) {
            System.out.println("java -jar ftmcli.jar set <container>\n\nDescription: Set metadata for a container or object if specified.\nOtherwise set metadata on account.\n\n-M, --metadata          <name:value> \n                         Sets the metadata item. The option can be repeated.\n                         e.g. -M X-Delete-After:86400\n-C, --custom-metadata   <name:value> \n                         Sets the metadata item. The option can be repeated.\n                         Differs from --metadata because FTM adds a prefix to \n                         distinguish custom metadata.\n                         e.g. -M org:findev -M account:b99\n-R, --retries           <retries> \n                         Number of times the request must be retried in case of failure.\n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
            return false;
        }
        if (options.valuesOf(this.meta) != null) {
            this.params.metadata = this.getMetadataMap(options.valuesOf(this.meta));
        }
        if (options.valuesOf(this.custommeta) != null) {
            this.params.custommetadata = this.getMetadataMap(options.valuesOf(this.custommeta));
        }
        return true;
    }

    public boolean parseUploadOptions(String[] args) {
        try {
            OptionParser parser = this.parseGeneralOptions();
            OptionSpecBuilder overwrite = parser.acceptsAll(Arrays.asList("o", "overwrite"));
            OptionSpecBuilder skip = parser.acceptsAll(Arrays.asList("s", "skip"));
            OptionSpecBuilder archive = parser.acceptsAll(Arrays.asList("a", "archive"));
            OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
            OptionSpecBuilder ssencryption = parser.acceptsAll(Arrays.asList("e", "server-side-encryption"));
            ArgumentAcceptingOptionSpec<Long> segmentSize = parser.acceptsAll(Arrays.asList("G", "segment-size")).withRequiredArg().ofType(Long.class);
            ArgumentAcceptingOptionSpec<String> segmentsContainer = parser.acceptsAll(Arrays.asList("C", "segments-container")).withRequiredArg();
            ArgumentAcceptingOptionSpec<String> objectName = parser.acceptsAll(Arrays.asList("N", "object-name")).withRequiredArg();
            NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
            OptionSet options = parser.parse(args);
            if (options.has(help)) {
                System.out.println("java -jar ftmcli.jar upload <container> <file or directory> \n\nDescription: Uploads the object to the specified container.\n\nOptional Arguments: \n-N, --object-name       <object name> \n                         Upload the file and store with the specified name in the container.\n-T, --max-threads       <threads> \n                         Maximum number of threads to be used in this upload request. \n-G, --segment-size      <size> \n                         The segment size in MB. \n-C, --segment-container <container> \n                         The container in which the segments must be stored.\n-R, --retries           <retries> \n                         Number of times the request must be retried in case of failure.\n-s, --skip              Skips a file if an object with the same name exists in the destination\n                        container. If option not specified, overwrites the object.\n-a, --archive           The object must be archived in the specified Archive container.\n-e, --server-side-encryption \n                        Upload the file to Server Side Encryption enabled container.\n\nFor more examples, see the reference documentation at\nhttp://www.oracle.com/pls/topic/lookup?ctx=cloud&id=CSCLR-GUID-5BB8647F-DDAD-4371-A519-1116402245FB");
                return false;
            }
            if (!this.validateAndSetGeneralOptions(options)) {
                return false;
            }
            if (options.has(overwrite)) {
                this.params.overwrite = true;
            }
            if (options.has(skip)) {
                this.params.skip = true;
                this.params.overwrite = false;
            } else {
                this.params.overwrite = true;
            }
            if (options.has(ssencryption)) {
                this.params.ssencryption = true;
            }
            if (options.has(archive)) {
                this.params.storageClass = CloudStorageClass.Archive;
            }
            if (segmentSize.value(options) != null) {
                this.params.segmentSize = (Long)segmentSize.value(options);
            }
            if (!this.validateAndSetContainerAndFileName(nonOptions, options)) {
                return false;
            }
            this.params.segmentsContainer = segmentsContainer.value(options) != null ? (String)segmentsContainer.value(options) : this.params.container + "_segments";
            if (objectName.value(options) != null) {
                if (this.params.fileName.contains(",")) {
                    FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "--object-name is not supported with multiple files.");
                    return false;
                }
                this.params.destinationObjectName = ((String)objectName.value(options)).replace("\\", "/");
            } else {
                this.params.destinationObjectName = this.params.fileName.replace("\\", "/");
            }
            while (this.params.destinationObjectName.startsWith("/")) {
                this.params.destinationObjectName = this.params.destinationObjectName.substring(1);
            }
            if (this.params.segmentSize > 5024L) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Specified Segment Size is too large. It may not exceed 5024MB.");
                return false;
            }
            if (this.params.segmentSize < 1L) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Specified Segment Size is too small. It must be 1MB or higher.");
                return false;
            }
        }
        catch (OptionException oe) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Parsing Exception - " + oe.getMessage());
            return false;
        }
        return true;
    }

    public boolean parseDownloadOptions(String[] args) {
        try {
            OptionParser parser = this.parseGeneralOptions();
            OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
            OptionSpecBuilder directory = parser.accepts("directory");
            ArgumentAcceptingOptionSpec<String> outputFilePath = parser.acceptsAll(Arrays.asList("O", "output-file")).withRequiredArg();
            NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
            OptionSet options = parser.parse(args);
            if (options.has(help)) {
                System.out.println("Usage: java -jar ftmcli.jar download <container> <file or directory> \n\nDescription: Downloads the object from the specified container.\n\nOptional Arguments: \n-O, --output-file       <file> \n                         Download the object and save the file with the specified name on the \n                         local file system. \n-T, --max-threads       <threads> \n                         Maximum number of threads to be used in this download request. \n-R, --retries           <retries> \n                         Number of times the request must be retried in case of failure.\n--directory             Downloads a directory with the specified file name being the prefix.\n\nFor more examples, see the reference documentation at\nhttp://www.oracle.com/pls/topic/lookup?ctx=cloud&id=CSCLR-GUID-5BB8647F-DDAD-4371-A519-1116402245FB");
                return false;
            }
            if (options.has(directory)) {
                this.params.directory = true;
            }
            if (!this.validateAndSetGeneralOptions(options)) {
                return false;
            }
            if (!this.validateAndSetContainerAndFileName(nonOptions, options)) {
                return false;
            }
            this.params.outputFilePath = outputFilePath.value(options) != null ? (String)outputFilePath.value(options) : (System.getProperty("os.name").startsWith("Windows") ? this.params.fileName.replace(":/", "/") : this.params.fileName);
        }
        catch (OptionException oe) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Parsing Exception - " + oe.getMessage());
            return false;
        }
        return true;
    }

    public boolean parseRestoreOptions(String[] args) {
        try {
            OptionParser parser = this.parseGeneralOptions();
            OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
            OptionSpecBuilder statusOnly = parser.acceptsAll(Arrays.asList("s", "status-only"));
            NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
            OptionSet options = parser.parse(args);
            if (options.has(help)) {
                System.out.println("java -jar ftmcli.jar restore <container> <file or directory> \n\nDescription: Restores the archived object in an archive container.\n\nOptional Arguments: \n-R, --retries           <retries> \n                         Number of times the request must be retried in case of failure.\n-s, --status-only       Report the restore status without initiating a restore. \n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
                return false;
            }
            if (!this.validateAndSetGeneralOptions(options)) {
                return false;
            }
            if (!this.validateAndSetContainerAndFileName(nonOptions, options)) {
                return false;
            }
            if (options.has(statusOnly)) {
                this.params.statusOnly = true;
            }
        }
        catch (OptionException oe) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Parsing Exception - " + oe.getMessage());
            return false;
        }
        return true;
    }

    public boolean parseDeleteOptions(String[] args) {
        try {
            OptionParser parser = this.parseGeneralOptions();
            NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
            OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
            OptionSpecBuilder force = parser.acceptsAll(Arrays.asList("f", "force"));
            OptionSet options = parser.parse(args);
            if (options.has(help)) {
                System.out.println("java -jar ftmcli.jar delete <container> <file or directory> \n\nDescription: Deletes object in the container if object is specified. \nOtherwise deletes container in the account.\n\nOptional Arguments: \n-R, --retries           <retries> \n                         Number of times the request is retried in case of failure(s).  \n-f, --force             Delete a container and all its contents. Option ignored for objects. \n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
                return false;
            }
            if (!this.validateAndSetGeneralOptions(options)) {
                return false;
            }
            if (nonOptions.values(options).size() > 3) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Unexpected parameter: " + (String)nonOptions.values(options).get(3) + ", where container: " + (String)nonOptions.values(options).get(1) + " and file: " + (String)nonOptions.values(options).get(2));
                return false;
            }
            if (nonOptions.values(options).size() == 2) {
                this.params.container = (String)nonOptions.values(options).get(1);
            } else if (nonOptions.values(options).size() == 3) {
                this.params.container = (String)nonOptions.values(options).get(1);
                this.params.fileName = (String)nonOptions.values(options).get(2);
            }
            if (options.has(force)) {
                this.params.force = true;
            }
        }
        catch (OptionException oe) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Parsing Exception - " + oe.getMessage());
            return false;
        }
        return true;
    }

    public boolean parseListOptions(String[] args) {
        try {
            OptionParser parser = this.parseGeneralOptions();
            OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
            ArgumentAcceptingOptionSpec<String> prefix = parser.acceptsAll(Arrays.asList("X", "prefix")).withRequiredArg();
            ArgumentAcceptingOptionSpec<String> delimeter = parser.acceptsAll(Arrays.asList("D", "delimiter")).withRequiredArg();
            ArgumentAcceptingOptionSpec<String> marker = parser.acceptsAll(Arrays.asList("M", "marker")).withRequiredArg();
            ArgumentAcceptingOptionSpec<String> endMarker = parser.acceptsAll(Arrays.asList("E", "end-marker")).withRequiredArg();
            ArgumentAcceptingOptionSpec<Integer> limit = parser.acceptsAll(Arrays.asList("L", "limit")).withRequiredArg().ofType(Integer.class);
            OptionSpecBuilder all = parser.acceptsAll(Arrays.asList("a", "all"));
            NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
            OptionSet options = parser.parse(args);
            if (options.has(help)) {
                System.out.println("java -jar ftmcli.jar list <container>\n\nDescription: Lists objects in the container if container is specified.\n Otherwise lists containers in the account.\n\nOptional Arguments: \n-R, --retries           <retries> \n                         Number of times the request must be retried in case of failure.\n-X, --prefix            <prefix> \n                         Lists the objects with names that start with the specified prefix\n-D, --delimiter         <delimiter> \n                         Delimiter for the listing query.\n-M, --marker            <marker> \n                         Return objects with names greater than the specified string.\n-E, --end-marker        <end-marker> \n                         Return objects with names less than the specified string.\n-L, --limit             <limit> \n                         Limit the number of objects listed to the specified value.\n                         The default and maximum value is 10000.\n-a, --all               Returns all objects even if it has to run multiple queries to get more\n                        than 10000 objects.\n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
                return false;
            }
            if (!this.validateAndSetGeneralOptions(options)) {
                return false;
            }
            if (nonOptions.values(options).size() > 2) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Unexpected parameter: " + (String)nonOptions.values(options).get(2) + ", where container: " + (String)nonOptions.values(options).get(1));
                return false;
            }
            if (nonOptions.values(options).size() == 2) {
                this.params.container = (String)nonOptions.values(options).get(1);
                this.params.fileName = "";
            } else if (nonOptions.values(options).size() == 1) {
                this.params.container = "";
                this.params.fileName = "";
            }
            if (prefix.value(options) != null) {
                this.params.prefix = (String)prefix.value(options);
            }
            if (delimeter.value(options) != null) {
                this.params.delimiter = (String)delimeter.value(options);
            }
            if (marker.value(options) != null) {
                this.params.marker = (String)marker.value(options);
            }
            if (endMarker.value(options) != null) {
                this.params.endMarker = (String)endMarker.value(options);
            }
            if (limit.value(options) != null) {
                this.params.limit = (Integer)limit.value(options);
            }
            if (options.has(all)) {
                this.params.listAll = true;
            }
        }
        catch (OptionException oe) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Parsing Exception - " + oe.getMessage());
            return false;
        }
        return true;
    }

    public boolean parseDescribeOptions(String[] args) {
        try {
            OptionParser parser = this.parseGeneralOptions();
            NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
            OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "help"));
            OptionSet options = parser.parse(args);
            if (options.has(help)) {
                System.out.println("java -jar ftmcli.jar describe <container> <object> \n\nDescription: Display key attributes of an object or container if specified.\nOtherwise describe the account.\n\nFor more examples, see the reference documentation at\nhttp://docs.oracle.com/en/cloud/iaas/storage-cloud/csclr/preparing-use-oracle-storage-cloud-file-transfer-manager-cli.html");
                return false;
            }
            if (!this.validateAndSetGeneralOptions(options)) {
                return false;
            }
            if (nonOptions.values(options).size() > 3) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Unexpected parameter: " + (String)nonOptions.values(options).get(2) + ", where container: " + (String)nonOptions.values(options).get(1));
                return false;
            }
            if (nonOptions.values(options).size() == 3) {
                this.params.container = (String)nonOptions.values(options).get(1);
                this.params.fileName = (String)nonOptions.values(options).get(2);
            } else if (nonOptions.values(options).size() == 2) {
                this.params.container = (String)nonOptions.values(options).get(1);
                this.params.fileName = "";
            } else if (nonOptions.values(options).size() == 1) {
                this.params.container = "";
                this.params.fileName = "";
            }
        }
        catch (OptionException oe) {
            FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Parsing Exception - " + oe.getMessage());
            return false;
        }
        return true;
    }

    private HashMap<String, String> getMetadataMap(List<String> pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String meta : pairs) {
            String[] pair = meta.split(":");
            if (pair.length < 2) {
                FileTransferManagerCLI.cliLogger.log((Level)LogLevel.ERROR, "Invalid metadata key/value pair: " + meta);
                return null;
            }
            String val = meta.substring(pair[0].length() + 1);
            FileTransferManagerCLI.cliLogger.log(LogLevel.FINE, "Adding metadata key: " + pair[0] + " val: " + val);
            map.put(pair[0], val);
        }
        return map;
    }
}

