/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.ftm.ArchiveRestoreStatus;
import oracle.cloudstorage.ftm.DownloadConfig;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.ObjectNotRestored;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.internal.DownloadSegmentResult;
import oracle.cloudstorage.ftm.internal.FileSegmentDownloadTask;
import oracle.cloudstorage.ftm.internal.FileUtils;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import oracle.cloudstorage.ftm.internal.RestoreInProgressException;
import oracle.cloudstorage.ftm.internal.RestoreJob;
import oracle.cloudstorage.ftm.internal.SLOSegmentManifest;
import oracle.cloudstorage.ftm.model.CloudObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFile {
    static final Logger logger = LoggerFactory.getLogger(DownloadFile.class);

    public static void download(FileTransferManager fileTransferManager, DownloadConfig downloadConfig, ExecutorService threadPool, String containerName, String objectName, File file) throws ClientException, ServiceException {
        ISession session = fileTransferManager.getSession();
        FileTransferManagerConfig managerConfig = fileTransferManager.getFileTransferManagerConfig();
        boolean downloaArchivedSloAsSingleFile = false;
        String tempDirPath = null;
        try {
            Map<String, String> objHeaders = RestApiUtils.getObjectHeadersWithMultipartManifest(managerConfig, session, containerName, objectName);
            String staticLargeObject = objHeaders.get("x-static-large-object");
            boolean isFileSlo = false;
            if (staticLargeObject != null && staticLargeObject.equalsIgnoreCase("True")) {
                isFileSlo = true;
            }
            boolean isArchiveContainer = RestApiUtils.isArchiveContainer(managerConfig, session, containerName);
            String manifest = objHeaders.get(Header.dynamicLargeObjectManifest);
            if (isArchiveContainer) {
                logger.trace("Downloading from archive storage container ...");
                ArchiveRestoreStatus restoreStatus = ArchiveRestoreStatus.valueOf(objHeaders.get("x-archive-restore-status").toUpperCase(Locale.US));
                logger.trace("Archived status of the file " + (Object)((Object)restoreStatus));
                if (!restoreStatus.equals((Object)ArchiveRestoreStatus.RESTORED)) {
                    if (downloadConfig.isDownloadRestoredObjectOnly()) {
                        throw new ObjectNotRestored(objectName);
                    }
                    logger.info("Restoring the archived object " + containerName + "/" + objectName);
                    String jobId = RestApiUtils.startRestore(managerConfig, session, containerName, objectName);
                    RestoreJob restoreJob = RestApiUtils.getRestoreJob(managerConfig, session, containerName, jobId);
                    if (!restoreJob.isCompleted()) {
                        int completedPercentage = restoreJob.getCompletedPercentage();
                        if (isFileSlo && !downloaArchivedSloAsSingleFile && completedPercentage > 1) {
                            completedPercentage = 1;
                        }
                        RestoreInProgressException rpe = new RestoreInProgressException(containerName, objectName, completedPercentage);
                        logger.info(rpe.getMessage());
                        throw rpe;
                    }
                }
            }
            if (isFileSlo) {
                if (!isArchiveContainer || !downloaArchivedSloAsSingleFile) {
                    LinkedHashMap<String, SLOSegmentManifest> sloSegmentRestoreJobIdMap;
                    RestoreJob sloRestoreJob;
                    logger.info("Downloading a SLO " + containerName + "/" + objectName + " from " + (isArchiveContainer ? "archive" : "standard") + " container ...");
                    tempDirPath = FileUtils.createTempDir(containerName);
                    List<SLOSegmentManifest> segmentManifestList = RestApiUtils.getSLOSegmentManifest(managerConfig, session, containerName, objectName, tempDirPath);
                    logger.debug("SLO manifest:\n " + SLOSegmentManifest.toString(segmentManifestList));
                    if (isArchiveContainer && !(sloRestoreJob = RestApiUtils.getSLOSegementsRestoreJob(managerConfig, session, sloSegmentRestoreJobIdMap = RestApiUtils.startSLOSegementsRestore(managerConfig, session, segmentManifestList))).isCompleted()) {
                        RestoreInProgressException rpe = new RestoreInProgressException(containerName, objectName, sloRestoreJob.getCompletedPercentage());
                        logger.info(rpe.getMessage());
                        throw rpe;
                    }
                    DownloadFile.downloadSlo(fileTransferManager, downloadConfig, threadPool, file, segmentManifestList);
                    logger.info("Download completed successfully for a SLO " + containerName + "/" + objectName);
                } else {
                    logger.info("Downloading a SLO file from archive container as a single file ...");
                    RestApiUtils.downloadRegularFile(managerConfig, session, containerName, objectName, file, false);
                    logger.info("Download completed successfully!");
                }
            } else if (manifest != null && manifest.length() >= 1) {
                DownloadFile.downloadDlo(fileTransferManager, downloadConfig, containerName, threadPool, file, objectName);
            } else {
                logger.info("Downloading a regular object " + containerName + "/" + objectName + " ...");
                RestApiUtils.downloadRegularFile(managerConfig, session, containerName, objectName, file, false);
                logger.info("Download completed successfully for " + containerName + "/" + objectName);
            }
        }
        catch (ClientException ce) {
            throw ce;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            logger.error("Exception - " + e.getMessage());
            logger.trace("Exception -", e);
            throw new ClientException(e);
        }
    }

    private static FileChannel getFileChannel(File file, long fileSize) throws IOException {
        FileChannel fc = null;
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.CREATE);
        options.add(StandardOpenOption.SPARSE);
        options.add(StandardOpenOption.WRITE);
        options.add(StandardOpenOption.READ);
        options.add(StandardOpenOption.TRUNCATE_EXISTING);
        fc = FileChannel.open(file.toPath(), options, new FileAttribute[0]);
        fc.position(fileSize - 1L);
        byte[] dummyData = new byte[]{0};
        fc.write(ByteBuffer.wrap(dummyData));
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadDlo(FileTransferManager fileTransferManager, DownloadConfig downloadConfig, String containerName, ExecutorService threadPool, File file, String objectName) throws InterruptedException, ExecutionException, IOException {
        logger.info("Downloading a DLO " + containerName + "/" + objectName + " to file " + file.getAbsolutePath() + " ...");
        Map<String, String> objHeaders = RestApiUtils.getObjectHeaders(fileTransferManager.getFileTransferManagerConfig(), fileTransferManager.getSession(), containerName, objectName);
        long objectSize = Long.parseLong(objHeaders.get("content-length"));
        String manifest = objHeaders.get(Header.dynamicLargeObjectManifest);
        String segmentContainer = manifest.substring(0, manifest.indexOf(47));
        LinkedList<Future<DownloadSegmentResult>> futures = new LinkedList<Future<DownloadSegmentResult>>();
        try (FileChannel fc = DownloadFile.getFileChannel(file, objectSize);){
            long fileOffset = 0L;
            HashMap<String, DownloadSegmentResult> downloadResults = new HashMap<String, DownloadSegmentResult>();
            int listSizeLimit = 10000;
            List<String> segmentList = RestApiUtils.listDloSegments(fileTransferManager.getFileTransferManagerConfig(), fileTransferManager.getSession(), manifest, null, listSizeLimit);
            while (!segmentList.isEmpty()) {
                for (int i = 0; i < segmentList.size(); ++i) {
                    String objectId = segmentList.get(i);
                    boolean skipMsg = false;
                    block14: while (futures.size() == downloadConfig.getMaxThreadsPerLargeObjectTransfer()) {
                        if (!skipMsg) {
                            logger.trace("Waiting for current threads to complete...");
                            skipMsg = true;
                        }
                        Thread.sleep(100L);
                        for (Future future : futures) {
                            if (!future.isDone()) continue;
                            DownloadSegmentResult result = (DownloadSegmentResult)future.get();
                            if (!result.isDownloadResult()) {
                                logger.error("Download failed!");
                            }
                            downloadResults.put(result.getObject(), result);
                            futures.remove(future);
                            continue block14;
                        }
                    }
                    CloudObject segmentObj = RestApiUtils.getObject(fileTransferManager.getFileTransferManagerConfig(), fileTransferManager.getSession(), segmentContainer, objectId, true, false);
                    long l = segmentObj.getContentLength();
                    logger.debug("Downloading segment " + objectId + " ...");
                    Future<DownloadSegmentResult> f = threadPool.submit(new FileSegmentDownloadTask(fileTransferManager, RestApiUtils.uriEncode(objectId), segmentContainer, l, fc, fileOffset));
                    fileOffset += l;
                    futures.add(f);
                }
                DownloadFile.waitForAllFuturesToComplete(futures, downloadResults);
                if (segmentList.size() == listSizeLimit) {
                    segmentList = RestApiUtils.listDloSegments(fileTransferManager.getFileTransferManagerConfig(), fileTransferManager.getSession(), manifest, segmentList.get(segmentList.size() - 1), listSizeLimit);
                    continue;
                }
                segmentList.clear();
            }
            logger.info("Download completed successfully for DLO " + containerName + "/" + objectName);
        }
        finally {
            DownloadFile.cancelSegmentDownloadTasks(futures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadSlo(FileTransferManager fileTransferManager, DownloadConfig downloadConfig, ExecutorService threadPool, File file, List<SLOSegmentManifest> segmentManifestList) throws InterruptedException, ExecutionException, IOException {
        logger.debug("Downloading a SLO to file " + file.getAbsolutePath() + " ...");
        LinkedList<Future<DownloadSegmentResult>> futures = new LinkedList<Future<DownloadSegmentResult>>();
        try (FileChannel fc = DownloadFile.getFileChannel(file, SLOSegmentManifest.getSLOSize(segmentManifestList));){
            long fileOffset = 0L;
            HashMap<String, DownloadSegmentResult> downloadResults = new HashMap<String, DownloadSegmentResult>();
            for (int i = 0; i < segmentManifestList.size(); ++i) {
                String objectId = segmentManifestList.get(i).getObjectName();
                boolean skipMsg = false;
                block13: while (futures.size() == downloadConfig.getMaxThreadsPerLargeObjectTransfer()) {
                    if (!skipMsg) {
                        logger.trace("Waiting for current threads to complete...");
                        skipMsg = true;
                    }
                    Thread.sleep(100L);
                    for (Future future : futures) {
                        if (!future.isDone()) continue;
                        DownloadSegmentResult result = (DownloadSegmentResult)future.get();
                        if (!result.isDownloadResult()) {
                            logger.error("Download failed!");
                        }
                        downloadResults.put(result.getObject(), result);
                        futures.remove(future);
                        continue block13;
                    }
                }
                logger.debug("Downloading segment " + objectId + "...");
                Future<DownloadSegmentResult> f = threadPool.submit(new FileSegmentDownloadTask(fileTransferManager, RestApiUtils.uriEncode(objectId), RestApiUtils.uriEncode(segmentManifestList.get(i).getSegmentContainer()), segmentManifestList.get(i).getBytes(), fc, fileOffset));
                fileOffset += segmentManifestList.get(i).getBytes();
                futures.add(f);
            }
            DownloadFile.waitForAllFuturesToComplete(futures, downloadResults);
            logger.debug("Download completed successfully for a SLO to file " + file.getAbsolutePath() + " ...");
        }
        finally {
            DownloadFile.cancelSegmentDownloadTasks(futures);
        }
    }

    public static String getSegmentFileName(String segmentName, String tempDirPath) {
        String[] objArray = segmentName.split("/");
        return tempDirPath + objArray[0] + "." + objArray[objArray.length - 1];
    }

    private static void waitForAllFuturesToComplete(LinkedList<Future<DownloadSegmentResult>> futures, Map<String, DownloadSegmentResult> downloadResults) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            DownloadSegmentResult result = (DownloadSegmentResult)future.get();
            downloadResults.put(result.getObject(), result);
            if (result.isDownloadResult()) continue;
            logger.error("Download failed!");
        }
    }

    private static void cancelSegmentDownloadTasks(List<Future<DownloadSegmentResult>> futures) {
        for (Future<DownloadSegmentResult> future : futures) {
            future.cancel(true);
        }
    }
}

