/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.queryparam.QueryParam;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.Md5ChecksumFailed;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFullObject
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(DownloadFullObject.class);
    private FileTransferManagerConfig managerConfig;
    private ISession session;
    private File file;
    private String container;
    private String objectName;
    private boolean isMultiPartManifest;

    DownloadFullObject(FileTransferManagerConfig managerConfig, ISession session, File file, String container, String objectName, boolean isMultiPartManifest) {
        this.managerConfig = managerConfig;
        this.session = session;
        this.file = file;
        this.container = container;
        this.objectName = objectName;
        this.isMultiPartManifest = isMultiPartManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int retryCount = 0;
        boolean retry = false;
        ClientException lastError = null;
        do {
            retry = false;
            if (retryCount > 0) {
                logger.info(" file download...retry count: " + retryCount);
            }
            InputStream inputStream = null;
            Closeable getObjectReply = null;
            try (FileOutputStream outStream = new FileOutputStream(this.file);){
                getObjectReply = this.isMultiPartManifest ? ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)((IGetRequestBuilder.ConnectTimeout)this.session.get().retry(new DefaultRetryStrategy(this.managerConfig))).param(QueryParam.multipartManifest.provide("get")).container(RestApiUtils.uriEncode(this.container))).object(RestApiUtils.uriEncode(this.objectName))).send() : ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)((IGetRequestBuilder.ConnectTimeout)this.session.get().retry(new DefaultRetryStrategy(this.managerConfig))).container(RestApiUtils.uriEncode(this.container))).object(RestApiUtils.uriEncode(this.objectName))).send();
                logger.trace(getObjectReply.toString());
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (getObjectReply.isSuccessful()) {
                    inputStream = getObjectReply.getData();
                    int read = 0;
                    byte[] bytes = new byte[8192];
                    while ((read = inputStream.read(bytes)) != -1) {
                        md.update(bytes, 0, read);
                        ((OutputStream)outStream).write(bytes, 0, read);
                    }
                    byte[] digest = md.digest();
                    StringBuffer hexString = new StringBuffer();
                    for (int i = 0; i < digest.length; ++i) {
                        String hex = Integer.toHexString(0xFF & digest[i]);
                        if (hex.length() == 1) {
                            hexString.append('0');
                        }
                        hexString.append(hex);
                    }
                    logger.trace("Computed MD5: " + hexString.toString());
                    logger.trace("Header eTag : " + getObjectReply.getHeader(Header.eTag));
                    if (getObjectReply.getHeader(Header.eTag).equals(hexString.toString())) {
                        return;
                    }
                    logger.warn("MD5 verification failed. Downloaded MD5: " + hexString.toString());
                    retry = true;
                    lastError = new Md5ChecksumFailed(this.container, this.objectName);
                } else {
                    lastError = new ServiceException(getObjectReply.getStatus().getStatusCode(), null, getObjectReply.getMessage());
                    retry = false;
                }
            }
            catch (IOException ioe) {
                logger.error("Exception caught downloading file: " + this.objectName + "\n" + ioe.getMessage());
                lastError = new ClientException(ioe.getMessage(), ioe);
                retry = true;
            }
            catch (ClientException ce) {
                lastError = ce;
            }
            catch (InterruptedException | RetryException e) {
                logger.error("Exception caught downloading file: " + this.objectName + "\n" + e.getMessage());
                lastError = RestApiUtils.convertRESTApiExecExceptionToServiceEx(e);
                retry = false;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Exception caught downloading file: " + this.objectName + "\n" + e.getMessage());
                lastError = new ClientException(e.getMessage(), e);
                retry = false;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (getObjectReply != null) {
                        getObjectReply.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("IO Exception while downloading file: " + this.objectName + "\n" + e.getMessage());
                }
            }
            if (retryCount >= 3) {
                retry = false;
            }
            ++retryCount;
        } while (retry);
        throw lastError;
    }
}

