/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.net.UnknownHostException;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.exception.ClientException;

public class ExceptionUtils {
    public static void throwRootCause(ClientException ce) throws ClientException {
        if (ce == null) {
            return;
        }
        ClientException lastException = null;
        if (ce.getCause() != null) {
            Throwable t = ce.getCause();
            if (t instanceof ClientException) {
                lastException = (ClientException)t;
            }
            while (t != null && t.getCause() != null) {
                if (!((t = t.getCause()) instanceof ClientException)) continue;
                lastException = (ClientException)t;
            }
            if (lastException != null) {
                throw lastException;
            }
        }
        throw ce;
    }

    public static String getRootCauseMessage(Throwable throwable) {
        String lastMsg = "";
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            lastMsg = t.getMessage();
            if (t instanceof UnknownHostException) {
                return "Unknown host " + lastMsg;
            }
            if (t.getCause() == null) break;
        }
        return lastMsg;
    }

    public static String getExceptionDetail(String detailedMsg, String key) {
        String ret = "";
        if (detailedMsg != null && !detailedMsg.isEmpty() && key != null && !key.isEmpty()) {
            String[] tokens = detailedMsg.split("\n");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (!token.startsWith(key + ":") || token.length() <= (key + ":").length()) continue;
                return token.substring((key + ":").length()).trim();
            }
        }
        return ret;
    }

    public static String getRetryExceptionDetail(RetryException re, String key) {
        String ret = "";
        if (re != null) {
            return ExceptionUtils.getExceptionDetail(re.getMessage(), key);
        }
        return ret;
    }

    public static String getTransDetails(String detailedMsg) {
        StringBuilder sb = new StringBuilder();
        sb.append("[method: " + ExceptionUtils.getExceptionDetail(detailedMsg, "method") + ", ");
        sb.append("url: " + ExceptionUtils.getExceptionDetail(detailedMsg, "url") + ", ");
        sb.append("status: " + ExceptionUtils.getExceptionDetail(detailedMsg, "status") + ", ");
        sb.append("trans-id: " + ExceptionUtils.getExceptionDetail(detailedMsg, "trans-id") + ", ");
        sb.append("message: " + ExceptionUtils.getExceptionDetail(detailedMsg, "message") + "]");
        return sb.toString();
    }
}

