/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.Md5ChecksumFailed;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.DownloadSegmentResult;
import oracle.cloudstorage.ftm.internal.FileSegmentOutputStream;
import oracle.cloudstorage.ftm.internal.Md5ChecksumUtils;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSegmentDownloadTask
implements Callable<DownloadSegmentResult> {
    static final Logger logger = LoggerFactory.getLogger(FileSegmentDownloadTask.class);
    private FileTransferManagerConfig managerConfig;
    private String segmentsContainer = "";
    private String object = null;
    private ISession session = null;
    private FileChannel fc = null;
    private long fileOffset;
    private long segmentSize;

    FileSegmentDownloadTask(FileTransferManager fileTransferManager, String object, String segmentsContainer, long segmentSize, FileChannel fc, long fileOffset) {
        this.managerConfig = fileTransferManager.getFileTransferManagerConfig();
        this.session = fileTransferManager.getSession();
        this.object = object;
        this.segmentsContainer = segmentsContainer;
        this.fc = fc;
        this.fileOffset = fileOffset;
        this.segmentSize = segmentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadSegmentResult call() {
        DownloadSegmentResult ret = new DownloadSegmentResult(this.segmentsContainer, this.object);
        int retryCount = 0;
        boolean retry = false;
        ClientException lastError = null;
        Closeable getObjectReply = null;
        do {
            retry = false;
            if (retryCount > 0) {
                logger.info("Retrying segment [" + this.object + "] download...retry count: " + retryCount);
            }
            InputStream inStream = null;
            try (FileSegmentOutputStream os = new FileSegmentOutputStream(this.fc, this.fileOffset, this.segmentSize);){
                MessageDigest md = MessageDigest.getInstance("MD5");
                getObjectReply = ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)((IGetRequestBuilder.ConnectTimeout)this.session.get().retry(new DefaultRetryStrategy(this.managerConfig))).chunk(65536).container(this.segmentsContainer)).object(this.object)).send();
                logger.trace(getObjectReply.toString());
                inStream = getObjectReply.getData();
                if (getObjectReply.isSuccessful()) {
                    int read = 0;
                    byte[] bytes = new byte[65536];
                    while ((read = inStream.read(bytes)) != -1) {
                        os.write(bytes, 0, read);
                        md.update(bytes, 0, read);
                    }
                    String computedMd5 = Md5ChecksumUtils.getChecksum(md);
                    String headerEtag = getObjectReply.getHeader(Header.eTag);
                    logger.trace("Segment Computed MD5: " + computedMd5 + " Segment Header eTag : " + headerEtag);
                    ret.setETag(headerEtag);
                    if (headerEtag.equals(computedMd5)) {
                        ret.setDownloadResult(true);
                        inStream.close();
                        logger.info("Segment [ " + this.object + " ] downloaded successfully!");
                        logger.trace("Segment [ " + this.object + " ] downloaded to file with offset " + os.getFileChannelOffset() + ", size:" + os.getStreamSize());
                        DownloadSegmentResult downloadSegmentResult = ret;
                        return downloadSegmentResult;
                    }
                    logger.warn("MD5 verification failed. Segment Computed MD5: " + computedMd5 + ", Segment Header eTag : " + headerEtag);
                    retry = true;
                    lastError = new Md5ChecksumFailed(this.segmentsContainer, this.object);
                } else {
                    lastError = new ServiceException(getObjectReply.getStatus().getStatusCode(), null, getObjectReply.getMessage());
                    retry = false;
                }
            }
            catch (IOException ioe) {
                logger.error("Failure downloading file: " + this.object + "\n" + ioe.getMessage());
                retry = true;
                lastError = new ClientException(ioe.getMessage(), ioe);
            }
            catch (ClientException ce) {
                logger.error("Failure downloading file: " + this.object + "\n" + ce.getMessage());
                lastError = ce;
            }
            catch (InterruptedException | NoSuchAlgorithmException otherEx) {
                logger.error("Failure downloading file: " + this.object + "\n" + otherEx.getMessage());
                retry = false;
                lastError = new ClientException(otherEx.getMessage(), otherEx);
            }
            catch (RetryException e) {
                lastError = RestApiUtils.convertRESTApiExecExceptionToServiceEx(e);
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (getObjectReply != null) {
                        getObjectReply.close();
                    }
                }
                catch (IOException e) {
                    logger.trace("Failed to close  input stream or  IGetObjectReply for " + this.object + "\n" + e.getMessage());
                }
            }
            if (retryCount >= 3) {
                retry = false;
            }
            ++retryCount;
        } while (retry);
        throw lastError;
    }
}

