/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSegmentInputStream
extends InputStream {
    static final Logger logger = LoggerFactory.getLogger(FileSegmentInputStream.class);
    private RandomAccessFile file;
    private File srcFile;
    private final long fileOffset;
    private final long streamSize;
    private long segmentOffset;

    public FileSegmentInputStream(File file, long fileOffset, long streamSize) throws IOException {
        if (fileOffset >= file.length()) {
            throw new IOException("Invalid offset " + fileOffset + ": file length " + file.length() + " bytes");
        }
        if (streamSize > file.length() - fileOffset) {
            throw new IOException("Invalid offset " + fileOffset + " and length " + streamSize + ": file length " + file.length() + " bytes");
        }
        this.fileOffset = fileOffset;
        this.segmentOffset = 0L;
        this.streamSize = streamSize;
        this.srcFile = file;
        logger.trace("FileSegmentInputStream created for segment [" + fileOffset + " / " + streamSize + "]");
    }

    public long remaining() {
        return this.streamSize - this.segmentOffset;
    }

    public void init() throws IOException {
        try {
            this.file = new RandomAccessFile(this.srcFile, "r");
            this.file.seek(this.fileOffset);
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File " + this.srcFile.getCanonicalPath() + " not found: " + ex.getMessage());
        }
    }

    @Override
    public int read() throws IOException {
        if (this.remaining() > 0L) {
            ++this.segmentOffset;
            return this.file.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long remaining = this.remaining();
        if (remaining == 0L) {
            return -1;
        }
        try {
            int numToRead = remaining < (long)len ? (int)remaining : len;
            int result = this.file.read(b, off, numToRead);
            this.segmentOffset += (long)result;
            return result;
        }
        catch (IOException ex) {
            throw new IOException("Unable to read " + len + " bytes from file segment [" + this.fileOffset + " / " + this.streamSize + "] : " + ex.getMessage());
        }
    }

    @Override
    public long skip(long len) throws IOException {
        long numToSkip = len > this.remaining() ? this.remaining() : len;
        this.segmentOffset += numToSkip;
        this.file.seek(this.file.getFilePointer() + numToSkip);
        return numToSkip;
    }

    @Override
    public int available() throws IOException {
        if (this.remaining() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.segmentOffset = 0L;
        if (this.file != null) {
            this.file.close();
        }
        this.init();
    }
}

