/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSegmentOutputStream
extends OutputStream {
    static final Logger logger = LoggerFactory.getLogger(FileSegmentOutputStream.class);
    private final long streamSize;
    private long streamPosition = 0L;
    private long fileChannelOffset;
    private FileChannel fileChannel;

    public FileSegmentOutputStream(FileChannel fileChannel, long fileChannelOffset, long streamSize) {
        this.streamSize = streamSize;
        this.fileChannelOffset = fileChannelOffset;
        this.fileChannel = fileChannel;
        logger.trace("FileSegmentOutputStream created for segment [" + fileChannelOffset + " / " + streamSize + "]");
    }

    private long remaining() {
        return this.streamSize - this.streamPosition;
    }

    @Override
    public void write(int b) throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long remaining = this.remaining();
        if (remaining > 0L) {
            if (remaining < (long)len) {
                logger.error("Write buffer len (" + len + " bytes) is larger than available space " + remaining + " bytes in the channel. fileChannelOffset: " + this.fileChannelOffset + ", streamPosition: " + this.streamPosition + ", throwing IndexOutOfBoundsException.");
                throw new IndexOutOfBoundsException();
            }
            long position = this.fileChannelOffset + this.streamPosition;
            int bytesWritten = this.fileChannel.write(ByteBuffer.wrap(b, off, len), position);
            if (bytesWritten != len) {
                logger.warn("Unexpected #bytes written. bytesWritten  " + bytesWritten + ", len: " + len);
            }
            this.streamPosition += (long)bytesWritten;
            if (this.remaining() <= 0L) {
                this.close();
            }
        }
    }

    public long getStreamSize() {
        return this.streamSize;
    }

    public long getFileChannelOffset() {
        return this.fileChannelOffset;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

