/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import oracle.cloudstorage.ftm.internal.SLOSegmentManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static String createTempDir(String objectName) throws IOException {
        String dirPrefix = objectName + "_" + System.currentTimeMillis() + "_";
        Path dirPath = Files.createTempDirectory(dirPrefix, new FileAttribute[0]);
        dirPath.toFile().deleteOnExit();
        return dirPath.toString() + File.separator;
    }

    public static List<SLOSegmentManifest> getSLOSegementManifest(File file) {
        ArrayList<SLOSegmentManifest> segmentManifestList = new ArrayList<SLOSegmentManifest>();
        try (FileInputStream fis = new FileInputStream(file);
             JsonReader jsonReader = Json.createReader(fis);){
            JsonArray jsonArray = jsonReader.readArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jObj = jsonArray.getJsonObject(i);
                String lasModified = "";
                try {
                    lasModified = jObj.getString("last_modified");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                String contenType = "";
                try {
                    contenType = jObj.getString("content_type");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                segmentManifestList.add(new SLOSegmentManifest(jObj.getString("hash"), lasModified, jObj.getJsonNumber("bytes").longValueExact(), jObj.getString("name"), contenType));
            }
        }
        catch (IOException e) {
            logger.debug("Failed to get SLO manifest. " + e.getMessage());
        }
        return segmentManifestList;
    }

    public static File getExistingParent(File dir) {
        File ret = dir;
        if (!dir.isDirectory()) {
            ret = dir.getParentFile();
        }
        while (ret != null && !ret.exists()) {
            ret = ret.getParentFile();
        }
        return ret;
    }
}

