/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.Sendable;
import oracle.cloudstorage.api.request.processor.StandardSender;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.internal.FtmSendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class FtmStandardSender
extends StandardSender {
    static final Logger logger = LoggerFactory.getLogger(FtmStandardSender.class);

    @Override
    public IResponse send(Logger loggerInput, Marker marker, ISendable sendable) {
        Map headers = sendable.getHeaders();
        String apiUserAgent = "Oracle-FTMAPI/" + FileTransferManager.getApiVersion();
        String systemHttpAgent = System.getProperty("http.agent", "");
        if (!systemHttpAgent.isEmpty()) {
            apiUserAgent = systemHttpAgent + " " + apiUserAgent;
        }
        headers.setHeader(Header.provide("user-agent", apiUserAgent));
        if (FtmStandardSender.isV0Url(sendable.getUrl())) {
            FtmSendable ftmSendable = new FtmSendable((Sendable)sendable);
            return super.send(loggerInput, marker, ftmSendable);
        }
        return super.send(loggerInput, marker, sendable);
    }

    private static boolean isV0Url(String url) {
        return url.endsWith("?restore") || url.contains("?jobs&jobId=");
    }
}

