/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.util.Map;
import oracle.cloudstorage.ftm.exception.FailedToCreateParentDirectory;
import oracle.cloudstorage.ftm.exception.FileNotWritable;
import oracle.cloudstorage.ftm.exception.InvalidContainerName;
import oracle.cloudstorage.ftm.exception.InvalidDestinationDirectory;
import oracle.cloudstorage.ftm.exception.InvalidDestinationFile;
import oracle.cloudstorage.ftm.exception.InvalidMetadataInput;
import oracle.cloudstorage.ftm.exception.InvalidObjectName;
import oracle.cloudstorage.ftm.exception.InvalidQueryParameterLimit;
import oracle.cloudstorage.ftm.exception.InvalidSourceDirectory;
import oracle.cloudstorage.ftm.model.ListContainersRequestConfig;

public class InputValidationUtils {
    public static void validateContainerName(String containerName) throws InvalidContainerName {
        if (containerName == null || containerName.isEmpty() || containerName.contains("/") || containerName.contains("\\")) {
            throw new InvalidContainerName();
        }
    }

    public static void validateObjectName(String objectName) throws InvalidContainerName {
        if (objectName == null || objectName.isEmpty() || objectName.startsWith("/")) {
            throw new InvalidObjectName();
        }
    }

    public static void validateObjectMetadataInput(Map<String, String> customMetadata, Map<String, String> systemMetadata) throws InvalidMetadataInput {
        if (customMetadata == null && systemMetadata == null) {
            throw new InvalidMetadataInput();
        }
        if ((customMetadata == null || customMetadata.isEmpty()) && (systemMetadata == null || systemMetadata.isEmpty())) {
            throw new InvalidMetadataInput();
        }
    }

    public static void validateSourceDirectory(File directory) throws InvalidSourceDirectory {
        if (directory == null || !directory.exists()) {
            throw new InvalidSourceDirectory();
        }
        if (!directory.isDirectory() || !directory.canRead()) {
            throw new InvalidSourceDirectory();
        }
    }

    public static void validateDestinationDirectory(File directory) throws InvalidDestinationDirectory {
        if (directory == null) {
            throw new InvalidDestinationDirectory();
        }
        if (directory.exists()) {
            if (!directory.isDirectory() || !directory.canWrite()) {
                throw new InvalidDestinationDirectory();
            }
        } else {
            try {
                if (!directory.mkdirs() && !directory.exists()) {
                    throw new InvalidDestinationDirectory();
                }
            }
            catch (InvalidDestinationDirectory e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidDestinationDirectory(e);
            }
        }
    }

    public static void validateDestinationFile(File file) throws FailedToCreateParentDirectory, FileNotWritable, InvalidDestinationFile {
        if (file == null) {
            throw new InvalidDestinationFile();
        }
        if (file.exists()) {
            if (!file.isFile()) {
                throw new InvalidDestinationFile();
            }
            if (!file.canWrite()) {
                throw new FileNotWritable();
            }
        } else {
            File parentDir = file.getParentFile();
            if (parentDir == null) {
                return;
            }
            if (parentDir.exists()) {
                if (!parentDir.isDirectory() || !parentDir.canWrite()) {
                    throw new InvalidDestinationFile();
                }
            } else {
                try {
                    if (!parentDir.mkdirs() && !parentDir.exists()) {
                        throw new FailedToCreateParentDirectory(parentDir.getAbsolutePath());
                    }
                }
                catch (FailedToCreateParentDirectory e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new FailedToCreateParentDirectory(parentDir.getAbsolutePath(), e);
                }
            }
        }
    }

    public static void validateListContainersRequestConfig(ListContainersRequestConfig listContainersRequestConfig) throws InvalidQueryParameterLimit {
        if (listContainersRequestConfig != null) {
            if (listContainersRequestConfig.getLimit() > Integer.MIN_VALUE && listContainersRequestConfig.getLimit() < 1) {
                throw new InvalidQueryParameterLimit();
            }
            if (listContainersRequestConfig.getLimit() > 10000) {
                throw new InvalidQueryParameterLimit();
            }
        }
    }
}

