/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.internal.FileSegmentChecksumInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5ChecksumUtils {
    static final Logger logger = LoggerFactory.getLogger(Md5ChecksumUtils.class);

    public static String getChecksum(MessageDigest md) {
        byte[] digest = md.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String getChecksum(String s) throws ClientException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException(e);
        }
        md.update(s.getBytes(StandardCharsets.UTF_8));
        return Md5ChecksumUtils.getChecksum(md);
    }

    public static String getFileCheckSum(File file) throws NoSuchAlgorithmException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[1024];
            int bytesRead = 0;
            bytesRead = fileInputStream.read(bytes);
            while (bytesRead != -1) {
                md.update(bytes, 0, bytesRead);
                bytesRead = fileInputStream.read(bytes);
            }
            String string = Md5ChecksumUtils.getChecksum(md);
            return string;
        }
    }

    public static FileSegmentChecksumInfo getFileSegmentChecksum(FileInputStream fis, long segmentSize) throws IOException {
        byte[] bytes = new byte[65536];
        long segmentInputStreamSize = 0L;
        MessageDigest md = null;
        String md5 = "";
        try {
            md = MessageDigest.getInstance("MD5");
            int bytesRead = 0;
            do {
                if ((bytesRead = fis.read(bytes)) <= 0) continue;
                segmentInputStreamSize += (long)bytesRead;
                md.update(bytes, 0, bytesRead);
            } while (segmentInputStreamSize < segmentSize && bytesRead != -1);
            md5 = Md5ChecksumUtils.getChecksum(md);
            return new FileSegmentChecksumInfo(md5, segmentInputStreamSize);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to compute the MD5 checksum. " + e.getMessage());
            throw new ClientException(e);
        }
    }
}

