/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import oracle.cloudstorage.ftm.internal.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtils {
    static final Logger logger = LoggerFactory.getLogger(MetadataUtils.class);
    public static final String OBJ_META_DATA_KEY_PREFIX = "x-object-meta-";
    public static final String CONTAINER_META_DATA_KEY_PREFIX = "x-container-meta-";
    public static final String ACCOUNT_META_DATA_KEY_PREFIX = "x-account-meta-";

    public static Map<String, String> mergeCustomMetadata(Map<String, String> customMetadataInput, Map<String, String> currentCustomMetadata, String keyPrefix) {
        Map<String, String> normInputMetadata = MetadataUtils.normalizedKeyCustomMetadata(customMetadataInput, keyPrefix);
        HashMap<String, String> mergedCustomMetadata = new HashMap<String, String>();
        mergedCustomMetadata.putAll(normInputMetadata);
        for (Map.Entry<String, String> entry : currentCustomMetadata.entrySet()) {
            String metakey = entry.getKey().toLowerCase();
            if (normInputMetadata.containsKey(metakey)) continue;
            mergedCustomMetadata.put(metakey, entry.getValue());
        }
        return mergedCustomMetadata;
    }

    public static Map<String, String> mergeSystemMetadata(Map<String, String> systemMetadataInput, Map<String, String> currentSystemMetadata) {
        Map<String, String> normInputMetadata = MetadataUtils.normalizedKeySystemMetadata(systemMetadataInput);
        HashMap<String, String> mergedSystemMetadata = new HashMap<String, String>();
        mergedSystemMetadata.putAll(normInputMetadata);
        for (Map.Entry<String, String> entry : currentSystemMetadata.entrySet()) {
            String metakey = entry.getKey().toLowerCase();
            if (normInputMetadata.containsKey(metakey)) continue;
            String value = entry.getValue();
            if (metakey.equals("content-type") && value.contains(";charset=")) {
                value = value.substring(0, value.indexOf(";charset="));
            }
            mergedSystemMetadata.put(metakey, value);
        }
        return mergedSystemMetadata;
    }

    public static Map<String, String> normalizedKeyCustomMetadata(Map<String, String> customMetadata, String keyPrefix) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (customMetadata == null) {
            return ret;
        }
        for (Map.Entry<String, String> entry : customMetadata.entrySet()) {
            String newKey = entry.getKey().toLowerCase().replaceAll("_", "-");
            newKey = keyPrefix + StringUtils.trimMetadataKeyPrefix(newKey);
            ret.put(newKey, entry.getValue());
        }
        return ret;
    }

    public static Map<String, String> normalizedKeySystemMetadata(Map<String, String> systemMetadata) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (systemMetadata == null) {
            return ret;
        }
        for (Map.Entry<String, String> entry : systemMetadata.entrySet()) {
            ret.put(entry.getKey().toLowerCase().replaceAll("_", "-"), entry.getValue());
        }
        return ret;
    }

    public static Map<String, String> cloneMetadata(Map<String, String> metadata) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (metadata == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static void encodeMetadata(Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            metadata.put(entry.getKey(), RestApiUtils.uriEncode(entry.getValue()));
        }
    }
}

