/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.json.JsonArray;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.delete.IDeleteContainerReply;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.get.IGetAccountReply;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadAccountReply;
import oracle.cloudstorage.api.head.IHeadContainerReply;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.post.IPostContainerReply;
import oracle.cloudstorage.api.post.IPostObjectReply;
import oracle.cloudstorage.api.post.IPostRequestBuilder;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.queryparam.Map;
import oracle.cloudstorage.api.queryparam.QueryParam;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.ArchiveRestoreStatus;
import oracle.cloudstorage.ftm.CloudStorageClass;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.ContainerNotEmpty;
import oracle.cloudstorage.ftm.exception.ContainerNotFound;
import oracle.cloudstorage.ftm.exception.ForceDeleteContainerException;
import oracle.cloudstorage.ftm.exception.NotAnArchiveContainer;
import oracle.cloudstorage.ftm.exception.ObjectNotFound;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.DownloadFile;
import oracle.cloudstorage.ftm.internal.DownloadFullObject;
import oracle.cloudstorage.ftm.internal.ExceptionUtils;
import oracle.cloudstorage.ftm.internal.FileUtils;
import oracle.cloudstorage.ftm.internal.InputValidationUtils;
import oracle.cloudstorage.ftm.internal.MetadataUtils;
import oracle.cloudstorage.ftm.internal.PutRetryStrategy;
import oracle.cloudstorage.ftm.internal.RestoreJob;
import oracle.cloudstorage.ftm.internal.RestoreJobDetails;
import oracle.cloudstorage.ftm.internal.SLOSegmentManifest;
import oracle.cloudstorage.ftm.internal.StringUtils;
import oracle.cloudstorage.ftm.model.AccountMetadata;
import oracle.cloudstorage.ftm.model.CloudAccount;
import oracle.cloudstorage.ftm.model.CloudContainer;
import oracle.cloudstorage.ftm.model.CloudObject;
import oracle.cloudstorage.ftm.model.ContainerMetadata;
import oracle.cloudstorage.ftm.model.DeleteObjectsResult;
import oracle.cloudstorage.ftm.model.ListContainersRequestConfig;
import oracle.cloudstorage.ftm.model.ListObjectsRequestConfig;
import oracle.cloudstorage.ftm.model.ObjectMetadata;
import oracle.cloudstorage.ftm.model.ObjectRestoreJob;
import oracle.cloudstorage.ftm.model.RestoreJobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiUtils {
    static final Logger logger = LoggerFactory.getLogger(DownloadFile.class);
    static final int MAX_OBJECTS_LISTED = 10000;
    static final int MAX_PUT_RETRIES = 2;
    static final int MAX_CLIENT_RETRY_ATTEMPTS = 3;
    private static final String[] transactionHeaders = new String[]{"connection", "date", "x-trans-id", "server"};
    private static final List<String> TRANS_STD_HEADERS = Arrays.asList(transactionHeaders);
    static final String CONTAINER_METADATA_SSE_POLICY_HEADER_KEY = "X-Server-Side-Encryption";
    static final String CONTAINER_METADATA_SSE_POLICY_NONE = "NONE";
    static final String CONTAINER_METADATA_SSE_POLICY_BASE_ENCRYPTION = "BASE_ENCRYPTION";

    public static void processRESTApiExecException(Exception e) throws ServiceException {
        throw RestApiUtils.convertRESTApiExecExceptionToServiceEx(e);
    }

    public static ServiceException convertRESTApiExecExceptionToServiceEx(Exception e) throws ServiceException {
        logger.trace("REST API execution exception: ", e);
        if (e instanceof RetryException) {
            String status = ExceptionUtils.getRetryExceptionDetail((RetryException)e, "status");
            String message = ExceptionUtils.getRetryExceptionDetail((RetryException)e, "message");
            String txId = ExceptionUtils.getRetryExceptionDetail((RetryException)e, "trans-id");
            String exMessage = ExceptionUtils.getTransDetails(((RetryException)e).getMessage());
            logger.error(exMessage);
            if (!status.equals("null")) {
                return new ServiceException(Status.valueOf(status).getStatusCode(), txId, message);
            }
            return new ServiceException(ExceptionUtils.getRootCauseMessage(e));
        }
        logger.error(ExceptionUtils.getRootCauseMessage(e));
        return new ServiceException(ExceptionUtils.getRootCauseMessage(e));
    }

    public static CloudAccount getAccount(FileTransferManagerConfig managerConfig, ISession session) throws ServiceException {
        try {
            IHeadAccountReply headAccountReply = ((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).send();
            if (!headAccountReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headAccountReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headAccountReply);
            }
            return RestApiUtils.getAccount(headAccountReply.getContext().getStorageUrl(), headAccountReply);
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return null;
        }
    }

    private static CloudAccount getAccount(String storageUrl, IHeadAccountReply headAccountReply) {
        CloudAccount cloudAccount = new CloudAccount();
        cloudAccount.setName(storageUrl.substring(storageUrl.lastIndexOf(47) + 1));
        cloudAccount.setLastModifiedDate(RestApiUtils.getDateFromHeaderValue(headAccountReply.getHeader("x-last-modified-timestamp")));
        cloudAccount.setBytesUsed(Long.parseLong(headAccountReply.getHeader("x-account-bytes-used")));
        cloudAccount.setObjectCount(Long.parseLong(headAccountReply.getHeader("x-account-object-count")));
        cloudAccount.setContainerCount(Long.parseLong(headAccountReply.getHeader("x-account-container-count")));
        AccountMetadata metadata = cloudAccount.getMetadata();
        if (headAccountReply.getHeader("x-account-meta-quota-bytes") != null) {
            metadata.setQuotaBytes(Long.parseLong(headAccountReply.getHeader("x-account-meta-quota-bytes")));
        }
        if (headAccountReply.getHeader("x-account-meta-policy-georeplication") != null) {
            metadata.setPolicyGeoreplication(headAccountReply.getHeader("x-account-meta-policy-georeplication"));
        }
        if (headAccountReply.getHeader("x-account-meta-policy-archive") != null) {
            metadata.setPolicyArchive(headAccountReply.getHeader("x-account-meta-policy-archive"));
        }
        metadata.setCustomMetadata(RestApiUtils.getAccountCustomMetadata(headAccountReply.getHeaders()));
        return cloudAccount;
    }

    private static java.util.Map<String, String> getAccountCustomMetadata(java.util.Map<String, String> metadata) {
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("x-account-meta-") || key.equals("x-account-meta-quota-bytes") || key.equals("x-account-meta-policy-georeplication") || key.equals("x-account-meta-policy-archive")) continue;
            customMetadata.put(key, entry.getValue());
        }
        return customMetadata;
    }

    public static void updateAccountMetadata(FileTransferManagerConfig managerConfig, ISession session, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) {
        RestApiUtils.doAccountPost(managerConfig, session, MetadataUtils.normalizedKeyCustomMetadata(customMetadata, "x-account-meta-"), MetadataUtils.normalizedKeySystemMetadata(systemMetadata));
    }

    public static void doAccountPost(FileTransferManagerConfig managerConfig, ISession session, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) throws ServiceException {
        try {
            IPostContainerReply postContainerReply;
            oracle.cloudstorage.api.header.Map headers = new oracle.cloudstorage.api.header.Map();
            if (customMetadata != null) {
                for (String key : customMetadata.keySet()) {
                    headers.put(Header.provide(key, RestApiUtils.uriEncode(customMetadata.get(key))));
                }
            }
            if (systemMetadata != null) {
                for (String key : systemMetadata.keySet()) {
                    headers.put(Header.provide(key, systemMetadata.get(key)));
                }
            }
            if (!(postContainerReply = ((IPostRequestBuilder.Container)((IPostRequestBuilder.Header)((IPostRequestBuilder.ConnectTimeout)session.post().retry(new DefaultRetryStrategy(managerConfig))).header(headers)).container("")).send()).isSuccessful()) {
                logger.trace("POST detailed message:" + postContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(postContainerReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static void doObjectHead(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        try {
            IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.QueryParam)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).param(QueryParam.multipartManifest.provide("get"))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
            if (!headObjectReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headObjectReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static void setObjectMetadata(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) {
        java.util.Map<String, String> inputCustomMetadata = MetadataUtils.normalizedKeyCustomMetadata(customMetadata, "x-object-meta-");
        MetadataUtils.encodeMetadata(inputCustomMetadata);
        RestApiUtils.doObjectPost(managerConfig, session, containerName, objectName, inputCustomMetadata, MetadataUtils.normalizedKeySystemMetadata(systemMetadata));
    }

    public static void updateObjectMetadata(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) {
        java.util.Map<String, String> inputCustomMetadata = MetadataUtils.normalizedKeyCustomMetadata(customMetadata, "x-object-meta-");
        MetadataUtils.encodeMetadata(inputCustomMetadata);
        CloudObject co = RestApiUtils.getObject(managerConfig, session, containerName, objectName);
        RestApiUtils.doObjectPost(managerConfig, session, containerName, objectName, MetadataUtils.mergeCustomMetadata(inputCustomMetadata, co.getObjectMetadata().getCustomMetadata(), "x-object-meta-"), MetadataUtils.mergeSystemMetadata(systemMetadata, co.getObjectMetadata().getSystemMetadata()));
    }

    public static void doObjectPost(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) throws ServiceException {
        try {
            IPostObjectReply postObjectReply;
            oracle.cloudstorage.api.header.Map headers = new oracle.cloudstorage.api.header.Map();
            if (customMetadata != null) {
                for (String key : customMetadata.keySet()) {
                    headers.put(Header.object(StringUtils.trimMetadataKeyPrefix(key), (Object)customMetadata.get(key)));
                }
            }
            if (systemMetadata != null) {
                for (String key : systemMetadata.keySet()) {
                    headers.put(Header.provide(key, systemMetadata.get(key)));
                }
            }
            if (!(postObjectReply = ((IPostRequestBuilder.Container)((IPostRequestBuilder.Header)((IPostRequestBuilder.ConnectTimeout)session.post().retry(new DefaultRetryStrategy(managerConfig))).header(headers)).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName)).send()).isSuccessful()) {
                if (postObjectReply.getStatus() == Status.NOT_FOUND) {
                    throw new ObjectNotFound();
                }
                logger.trace("POST detailed message:" + postObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(postObjectReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static boolean objectExists(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        try {
            IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.QueryParam)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).param(QueryParam.multipartManifest.provide("get"))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
            if (!headObjectReply.isSuccessful()) {
                if (headObjectReply.getStatus().getStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                    return false;
                }
                logger.trace("HEAD detailed message:" + headObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headObjectReply);
            }
            return true;
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return false;
        }
    }

    public static void deleteObject(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ClientException, ServiceException {
        if (!RestApiUtils.containerExists(managerConfig, session, containerName)) {
            throw new ContainerNotFound();
        }
        java.util.Map<Object, Object> objHeaders = new HashMap();
        try {
            objHeaders = RestApiUtils.getObjectHeadersWithMultipartManifest(managerConfig, session, containerName, objectName);
        }
        catch (ServiceException se) {
            if (se.getHttpStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                throw new ObjectNotFound();
            }
            throw se;
        }
        String staticLargeObject = null;
        if (objHeaders != null) {
            staticLargeObject = (String)objHeaders.get("x-static-large-object");
        }
        boolean isSlo = false;
        if (staticLargeObject != null && staticLargeObject.equalsIgnoreCase("True")) {
            isSlo = true;
        }
        if (isSlo) {
            RestApiUtils.doMultipartDelete(managerConfig, session, containerName, objectName);
        } else {
            RestApiUtils.doObjectDelete(managerConfig, session, containerName, objectName);
        }
    }

    public static DeleteObjectsResult deleteObjects(final FileTransferManagerConfig managerConfig, final ISession session, final String containerName, List<String> objectNames, ExecutorService threadPool) throws ClientException, ServiceException {
        DeleteObjectsResult ret = null;
        ArrayList<String> deletedObjects = new ArrayList<String>();
        ArrayList<DeleteObjectsResult.DeleteObjectError> deleteObjectErrors = new ArrayList<DeleteObjectsResult.DeleteObjectError>();
        LinkedHashMap<String, Future<Void>> futures = new LinkedHashMap<String, Future<Void>>();
        for (final String objectName : objectNames) {
            boolean skipMsg = false;
            while (futures.size() == 10) {
                if (!skipMsg) {
                    logger.trace("Waiting for current threads to complete...");
                    skipMsg = true;
                }
                RestApiUtils.waitForDeleteTaskCompletion(futures, deletedObjects, deleteObjectErrors, false);
            }
            Future<Void> f = threadPool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    InputValidationUtils.validateObjectName(objectName);
                    RestApiUtils.deleteObject(managerConfig, session, containerName, objectName);
                    return null;
                }
            });
            futures.put(objectName, f);
        }
        RestApiUtils.waitForDeleteTaskCompletion(futures, deletedObjects, deleteObjectErrors, true);
        ret = new DeleteObjectsResult(deletedObjects, deleteObjectErrors);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForDeleteTaskCompletion(LinkedHashMap<String, Future<Void>> futures, List<String> deletedObjects, List<DeleteObjectsResult.DeleteObjectError> deleteObjectErrors, boolean waitForAll) {
        Iterator<Map.Entry<String, Future<Void>>> entryItr = futures.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, Future<Void>> entry = entryItr.next();
            try {
                entry.getValue().get();
                deletedObjects.add(entry.getKey());
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause != null) {
                    if (cause instanceof ContainerNotFound) {
                        throw (ContainerNotFound)cause;
                    }
                    if (cause instanceof ClientException) {
                        deleteObjectErrors.add(new DeleteObjectsResult.DeleteObjectError(entry.getKey(), (ClientException)cause));
                    }
                }
            }
            catch (InterruptedException e) {
                deleteObjectErrors.add(new DeleteObjectsResult.DeleteObjectError(entry.getKey(), new ClientException(e)));
            }
            finally {
                entryItr.remove();
                if (waitForAll) continue;
                break;
            }
        }
    }

    public static void doContainerHead(FileTransferManagerConfig managerConfig, ISession session, String containerName) throws ServiceException {
        try {
            IHeadContainerReply headContainerReply = ((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).send();
            if (!headContainerReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headContainerReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static boolean containerExists(FileTransferManagerConfig managerConfig, ISession session, String containerName) throws ServiceException {
        try {
            IHeadContainerReply headContainerReply = ((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).send();
            if (!headContainerReply.isSuccessful()) {
                if (headContainerReply.getStatus().getStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                    return false;
                }
                logger.trace("HEAD detailed message:" + headContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headContainerReply);
            }
            return true;
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return false;
        }
    }

    public static void putContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName, CloudStorageClass cloudStorageClass, boolean sseEnabled) throws ServiceException {
        IPutContainerReply putContainerReply = null;
        try {
            oracle.cloudstorage.api.header.Map headers = new oracle.cloudstorage.api.header.Map();
            if (cloudStorageClass.equals((Object)CloudStorageClass.Archive)) {
                headers.put(Header.provide("X-Storage-Class", "Archive"));
            }
            if (sseEnabled) {
                headers.put(CONTAINER_METADATA_SSE_POLICY_HEADER_KEY, CONTAINER_METADATA_SSE_POLICY_BASE_ENCRYPTION);
            }
            if (!(putContainerReply = ((IPutRequestBuilder.Container)((IPutRequestBuilder.Header)((IPutRequestBuilder.ConnectTimeout)session.put().retry(new PutRetryStrategy(managerConfig))).header(headers)).container(RestApiUtils.uriEncode(containerName))).send()).isSuccessful()) {
                logger.trace("PUT container detailed message:" + putContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(putContainerReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static CloudContainer createContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName, CloudStorageClass cloudStorageClass, boolean sseEnabled) throws ServiceException {
        if (RestApiUtils.containerExists(managerConfig, session, containerName)) {
            logger.trace("Following container already exists: " + containerName);
            throw new ServiceException("Following container already exists: " + containerName);
        }
        RestApiUtils.putContainer(managerConfig, session, containerName, cloudStorageClass, sseEnabled);
        return RestApiUtils.getContainer(managerConfig, session, containerName);
    }

    public static CloudContainer getContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName) throws ServiceException {
        try {
            IHeadContainerReply headContainerReply = ((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).send();
            if (!headContainerReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headContainerReply);
            }
            return RestApiUtils.getContainer(containerName, headContainerReply);
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return null;
        }
    }

    public static void updateContainerMetadata(FileTransferManagerConfig managerConfig, ISession session, String containerName, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) {
        RestApiUtils.doContainerPost(managerConfig, session, containerName, MetadataUtils.normalizedKeyCustomMetadata(customMetadata, "x-container-meta-"), MetadataUtils.normalizedKeySystemMetadata(systemMetadata));
    }

    public static void doContainerPost(FileTransferManagerConfig managerConfig, ISession session, String containerName, java.util.Map<String, String> customMetadata, java.util.Map<String, String> systemMetadata) throws ServiceException {
        try {
            IPostContainerReply postContainerReply;
            oracle.cloudstorage.api.header.Map headers = new oracle.cloudstorage.api.header.Map();
            if (customMetadata != null) {
                for (String key : customMetadata.keySet()) {
                    headers.put(Header.container(StringUtils.trimMetadataKeyPrefix(key), (Object)RestApiUtils.uriEncode(customMetadata.get(key))));
                }
            }
            if (systemMetadata != null) {
                for (String key : systemMetadata.keySet()) {
                    headers.put(Header.provide(key, systemMetadata.get(key)));
                }
            }
            if (!(postContainerReply = ((IPostRequestBuilder.Container)((IPostRequestBuilder.Header)((IPostRequestBuilder.ConnectTimeout)session.post().retry(new DefaultRetryStrategy(managerConfig))).header(headers)).container(RestApiUtils.uriEncode(containerName))).send()).isSuccessful()) {
                if (postContainerReply.getStatus() == Status.NOT_FOUND) {
                    throw new ContainerNotFound();
                }
                logger.trace("POST detailed message:" + postContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(postContainerReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static CloudObject getObject(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        return RestApiUtils.getObject(managerConfig, session, containerName, objectName, false, false);
    }

    public static CloudObject getObject(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, boolean isContainerNameEncoded, boolean isObjectNameEncdoed) throws ServiceException {
        try {
            IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(isContainerNameEncoded ? containerName : RestApiUtils.uriEncode(containerName))).object(isObjectNameEncdoed ? objectName : RestApiUtils.uriEncode(objectName))).send();
            if (!headObjectReply.isSuccessful()) {
                if (headObjectReply.getStatus() == Status.NOT_FOUND) {
                    throw new ObjectNotFound();
                }
                logger.trace("HEAD detailed message:" + headObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headObjectReply);
            }
            return RestApiUtils.getObject(containerName, objectName, headObjectReply);
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return null;
        }
    }

    public static void deleteContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName) throws ContainerNotFound, ServiceException {
        try {
            IDeleteContainerReply deleteContainerReply = ((IDeleteRequestBuilder.Container)((IDeleteRequestBuilder.ConnectTimeout)session.delete().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).send();
            if (!deleteContainerReply.isSuccessful()) {
                if (deleteContainerReply.getStatus() == Status.NOT_FOUND) {
                    throw new ContainerNotFound();
                }
                if (deleteContainerReply.getStatus() == Status.CONFLICT) {
                    throw new ContainerNotEmpty();
                }
                logger.trace("DELETE detailed message:" + deleteContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(deleteContainerReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static void forceDeleteContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName, ExecutorService threadPool) throws ClientException, ServiceException {
        try {
            RestApiUtils.deleteContainer(managerConfig, session, containerName);
            return;
        }
        catch (ContainerNotFound cnf) {
            throw cnf;
        }
        catch (ContainerNotEmpty cne) {
            int limit = 10000;
            ListObjectsRequestConfig reqConfig = new ListObjectsRequestConfig();
            reqConfig.setLimit(limit);
            List<String> objectNames = RestApiUtils.listObjects(managerConfig, session, containerName, reqConfig);
            int retries = 10;
            while (objectNames.isEmpty()) {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    throw new ClientException(e);
                }
                objectNames = RestApiUtils.listObjects(managerConfig, session, containerName, reqConfig);
                --retries;
            }
            block8: while (!objectNames.isEmpty()) {
                DeleteObjectsResult deleteResult = RestApiUtils.deleteObjects(managerConfig, session, containerName, objectNames, threadPool);
                if (!deleteResult.getDeleteObjectErrors().isEmpty()) {
                    throw new ForceDeleteContainerException(deleteResult.getDeleteObjectErrors());
                }
                while (!deleteResult.getObjectsDeleted().isEmpty()) {
                    objectNames = RestApiUtils.listObjects(managerConfig, session, containerName, reqConfig);
                    boolean foundDeletedObj = false;
                    for (String deleteObj : deleteResult.getObjectsDeleted()) {
                        if (!objectNames.contains(deleteObj)) continue;
                        foundDeletedObj = true;
                        try {
                            Thread.sleep(20000L);
                            break;
                        }
                        catch (InterruptedException e) {
                            throw new ClientException(e);
                        }
                    }
                    if (foundDeletedObj) continue;
                    continue block8;
                }
            }
            RestApiUtils.deleteContainer(managerConfig, session, containerName);
            return;
        }
    }

    private static CloudContainer getContainer(String containerName, IHeadContainerReply headContainerReply) {
        CloudContainer cloudContainer = new CloudContainer();
        oracle.cloudstorage.api.header.Map headerMap = headContainerReply.getHeaders();
        cloudContainer.setName(containerName);
        cloudContainer.setLastModifiedDate(RestApiUtils.getDateFromHeaderValue(headerMap.get("x-last-modified-timestamp")));
        cloudContainer.setCreationDate(RestApiUtils.getDateFromHeaderValue(headerMap.get("x-timestamp")));
        cloudContainer.setStorageClass(headerMap.get("x-storage-class"));
        cloudContainer.setServerSideEncryptionPolicy(headerMap.get(CONTAINER_METADATA_SSE_POLICY_HEADER_KEY.toLowerCase(Locale.US)));
        cloudContainer.setBytesUsed(Long.parseLong(headerMap.get("x-container-bytes-used")));
        cloudContainer.setObjectCount(Long.parseLong(headerMap.get("x-container-object-count")));
        ContainerMetadata metadata = cloudContainer.getMetadata();
        if (headerMap.get(Header.containerQuotaBytes) != null) {
            metadata.setQuotaBytes(Long.parseLong(headerMap.get(Header.containerQuotaBytes)));
        }
        if (headerMap.get(Header.containerQuotaCount) != null) {
            metadata.setQuotaCount(Long.parseLong(headerMap.get(Header.containerQuotaCount)));
        }
        metadata.setReadAcl(headerMap.get("x-container-read"));
        metadata.setWriteAcl(headerMap.get("x-container-write"));
        metadata.setCustomMetadata(RestApiUtils.getContainerCustomMetadata(headContainerReply.getHeaders()));
        for (String mapKey : headerMap.keySet()) {
            if (mapKey.toLowerCase().startsWith("x-container-meta-") || TRANS_STD_HEADERS.contains(mapKey)) continue;
            metadata.getSystemMetadata().put(mapKey, headerMap.get(mapKey));
        }
        return cloudContainer;
    }

    private static CloudObject getObject(String container, String objectName, IHeadObjectReply headObjectReply) {
        CloudObject cloudObject = new CloudObject();
        cloudObject.setName(objectName);
        cloudObject.setContainer(container);
        cloudObject.setLastModifiedDate(RestApiUtils.getDateFromHeaderValue(headObjectReply.getHeader("x-last-modified-timestamp")));
        cloudObject.setCreationDate(RestApiUtils.getDateFromHeaderValue(headObjectReply.getHeader("x-timestamp")));
        cloudObject.setContentLength(Long.parseLong(headObjectReply.getHeader("Content-Length")));
        cloudObject.setETag(headObjectReply.getHeader("ETag"));
        cloudObject.setContentType(headObjectReply.getHeader("Content-Type"));
        cloudObject.setManifest(headObjectReply.getHeader("X-Object-Manifest"));
        ObjectMetadata metadata = cloudObject.getObjectMetadata();
        oracle.cloudstorage.api.header.Map headerMap = headObjectReply.getHeaders();
        for (String mapKey : headerMap.keySet()) {
            if (mapKey.toLowerCase().startsWith("x-object-meta-")) {
                metadata.getCustomMetadata().put(mapKey, headerMap.get(mapKey));
                continue;
            }
            if (TRANS_STD_HEADERS.contains(mapKey)) continue;
            metadata.getSystemMetadata().put(mapKey, headerMap.get(mapKey));
        }
        if (headObjectReply.getHeader("X-Static-Large-Object") != null && headObjectReply.getHeader("X-Static-Large-Object").equalsIgnoreCase("True")) {
            cloudObject.setSLO(true);
        }
        return cloudObject;
    }

    private static java.util.Map<String, String> getContainerCustomMetadata(java.util.Map<String, String> metadata) {
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("x-container-meta-")) continue;
            customMetadata.put(key, entry.getValue());
        }
        return customMetadata;
    }

    public static boolean isArchiveContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName) throws ServiceException {
        try {
            IHeadContainerReply headContainerReply = ((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).send();
            if (!headContainerReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headContainerReply);
            }
            return "Archive".equalsIgnoreCase(headContainerReply.getHeader("x-storage-class"));
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return false;
        }
    }

    public static List<String> listContainers(FileTransferManagerConfig managerConfig, ISession session) throws ServiceException {
        ArrayList<String> containerList = new ArrayList<String>();
        try {
            IGetAccountReply getAccountReply = session.get().send();
            if (!getAccountReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + getAccountReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(getAccountReply);
            }
            containerList.addAll(getAccountReply.getContainerIds());
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
        return containerList;
    }

    public static List<String> listContainers(FileTransferManagerConfig managerConfig, ISession session, ListContainersRequestConfig listContainersRequestConfig) throws ServiceException {
        ArrayList<String> containerList = new ArrayList<String>();
        if (listContainersRequestConfig == null) {
            return RestApiUtils.listContainers(managerConfig, session);
        }
        try {
            IGetAccountReply getAccountReply = null;
            IGetRequestBuilder.ConnectTimeout ct = (IGetRequestBuilder.ConnectTimeout)session.get().retry(new DefaultRetryStrategy(managerConfig));
            Map queryParamMap = new Map();
            if (listContainersRequestConfig.getPrefix() != null && !listContainersRequestConfig.getPrefix().isEmpty()) {
                queryParamMap.put(QueryParam.prefix.provide(listContainersRequestConfig.getPrefix()));
            }
            if (listContainersRequestConfig.getMarker() != null && !listContainersRequestConfig.getMarker().isEmpty()) {
                queryParamMap.put(QueryParam.marker.provide(listContainersRequestConfig.getMarker()));
            }
            if (listContainersRequestConfig.getLimit() > 0) {
                queryParamMap.put(QueryParam.limit.provide(listContainersRequestConfig.getLimit() + ""));
            }
            if (listContainersRequestConfig.getEndMarker() != null && !listContainersRequestConfig.getEndMarker().isEmpty()) {
                queryParamMap.put(QueryParam.endMarker.provide(listContainersRequestConfig.getEndMarker()));
            }
            if (listContainersRequestConfig.getDelimiter() != null && !listContainersRequestConfig.getDelimiter().isEmpty()) {
                queryParamMap.put(QueryParam.delimiter.provide(listContainersRequestConfig.getDelimiter()));
            }
            if (!(getAccountReply = !queryParamMap.isEmpty() ? ct.param(queryParamMap.encode()).send() : ct.send()).isSuccessful()) {
                logger.trace("HEAD detailed message:" + getAccountReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(getAccountReply);
            }
            containerList.addAll(getAccountReply.getContainerIds());
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
        return containerList;
    }

    public static List<String> listObjects(FileTransferManagerConfig managerConfig, ISession session, String containerName, ListObjectsRequestConfig listObjectsRequestConfig) throws ServiceException {
        ArrayList<String> objList = new ArrayList<String>();
        try {
            IGetContainerReply getContainerReply = null;
            IGetRequestBuilder.ConnectTimeout ct = (IGetRequestBuilder.ConnectTimeout)session.get().retry(new DefaultRetryStrategy(managerConfig));
            Map queryParamMap = new Map();
            if (listObjectsRequestConfig != null) {
                if (listObjectsRequestConfig.getPrefix() != null && !listObjectsRequestConfig.getPrefix().isEmpty()) {
                    queryParamMap.put(QueryParam.prefix.provide(listObjectsRequestConfig.getPrefix()));
                }
                if (listObjectsRequestConfig.getMarker() != null && !listObjectsRequestConfig.getMarker().isEmpty()) {
                    queryParamMap.put(QueryParam.marker.provide(listObjectsRequestConfig.getMarker()));
                }
                if (listObjectsRequestConfig.getLimit() > 0) {
                    queryParamMap.put(QueryParam.limit.provide(listObjectsRequestConfig.getLimit() + ""));
                }
                if (listObjectsRequestConfig.getEndMarker() != null && !listObjectsRequestConfig.getEndMarker().isEmpty()) {
                    queryParamMap.put(QueryParam.endMarker.provide(listObjectsRequestConfig.getEndMarker()));
                }
                if (listObjectsRequestConfig.getDelimiter() != null && !listObjectsRequestConfig.getDelimiter().isEmpty()) {
                    queryParamMap.put(QueryParam.delimiter.provide(listObjectsRequestConfig.getDelimiter()));
                }
                if (listObjectsRequestConfig.getPath() != null && !listObjectsRequestConfig.getPath().isEmpty()) {
                    queryParamMap.put(QueryParam.path.provide(listObjectsRequestConfig.getPath()));
                }
            }
            if (!(getContainerReply = !queryParamMap.isEmpty() ? ((IGetRequestBuilder.Container)ct.param(queryParamMap.encode()).container(RestApiUtils.uriEncode(containerName))).send() : ((IGetRequestBuilder.Container)ct.container(RestApiUtils.uriEncode(containerName))).send()).isSuccessful()) {
                if (getContainerReply.getStatus() == Status.NOT_FOUND) {
                    throw new ContainerNotFound();
                }
                logger.trace("HEAD detailed message:" + getContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(getContainerReply);
            }
            objList.addAll(getContainerReply.getObjectIds());
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
        return objList;
    }

    public static List<String> listDloSegments(FileTransferManagerConfig managerConfig, ISession session, String manifest, String marker, int limit) throws ServiceException {
        String encodedContainerName = manifest.substring(0, manifest.indexOf(47));
        String encodedPrefix = manifest.substring(manifest.indexOf(47) + 1);
        ArrayList<String> objList = new ArrayList<String>();
        try {
            IGetContainerReply getContainerReply = null;
            IGetRequestBuilder.ConnectTimeout ct = (IGetRequestBuilder.ConnectTimeout)session.get().retry(new DefaultRetryStrategy(managerConfig));
            Map queryParamMap = new Map();
            if (marker != null && !marker.isEmpty()) {
                queryParamMap.put(QueryParam.marker.provide(marker));
            }
            if (limit > 0) {
                queryParamMap.put(QueryParam.limit.provide(limit + ""));
            }
            if (!(getContainerReply = !queryParamMap.isEmpty() ? ((IGetRequestBuilder.Container)ct.param(queryParamMap.encode()).param(QueryParam.prefix.provide(encodedPrefix)).container(encodedContainerName)).send() : ((IGetRequestBuilder.Container)ct.container(encodedContainerName)).send()).isSuccessful()) {
                if (getContainerReply.getStatus() == Status.NOT_FOUND) {
                    throw new ContainerNotFound();
                }
                logger.trace("HEAD detailed message:" + getContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(getContainerReply);
            }
            objList.addAll(getContainerReply.getObjectIds());
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
        return objList;
    }

    public static List<String> getObjects(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectPrefix) throws ServiceException {
        IGetContainerReply getContainerReply = null;
        ArrayList<String> objIds = new ArrayList<String>();
        try {
            String marker = "";
            IGetRequestBuilder.ConnectTimeout ct = null;
            while (true) {
                ct = (IGetRequestBuilder.ConnectTimeout)session.get().retry(new DefaultRetryStrategy(managerConfig));
                IGetRequestBuilder.QueryParam qp = null;
                if (objectPrefix != null && !objectPrefix.isEmpty()) {
                    qp = ct.param(QueryParam.prefix.provide(objectPrefix));
                }
                if (!marker.isEmpty()) {
                    qp = ct.param(QueryParam.marker.provide(marker));
                }
                if (!(getContainerReply = qp != null ? ((IGetRequestBuilder.Container)qp.param(QueryParam.prefix.provide(objectPrefix)).container(RestApiUtils.uriEncode(containerName))).send() : ((IGetRequestBuilder.Container)ct.container(RestApiUtils.uriEncode(containerName))).send()).isSuccessful()) {
                    logger.trace("HEAD detailed message:" + getContainerReply.getContext().buildDetailedMessage());
                    throw RestApiUtils.convertToServiceException(getContainerReply);
                }
                Set<String> objIdSet = getContainerReply.getObjectIds();
                if (objIdSet == null || objIdSet.isEmpty()) {
                    return objIds;
                }
                if (objIdSet.size() < 10000) {
                    objIds.addAll(objIdSet);
                    return objIds;
                }
                ArrayList<String> itrObjIds = new ArrayList<String>(objIdSet);
                if (itrObjIds.isEmpty()) continue;
                String newMarker = (String)itrObjIds.get(itrObjIds.size() - 1);
                if (newMarker.equals(marker)) break;
                marker = newMarker;
                objIds.addAll(itrObjIds);
            }
            return objIds;
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return objIds;
        }
    }

    public static java.util.Map<String, String> getObjectHeaders(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        oracle.cloudstorage.api.header.Map retHeaders = null;
        try {
            IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
            if (!headObjectReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headObjectReply);
            }
            retHeaders = headObjectReply.getHeaders();
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
        return retHeaders;
    }

    public static java.util.Map<String, String> getObjectHeadersWithMultipartManifest(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        oracle.cloudstorage.api.header.Map retHeaders = null;
        try {
            IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.QueryParam)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).param(QueryParam.multipartManifest.provide("get"))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
            if (!headObjectReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + headObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(headObjectReply);
            }
            retHeaders = headObjectReply.getHeaders();
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
        return retHeaders;
    }

    public static ObjectRestoreJob restoreObject(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ClientException, ServiceException {
        ObjectRestoreJob objectRestoreJob = new ObjectRestoreJob();
        objectRestoreJob.setContainerName(containerName);
        objectRestoreJob.setObjectName(objectName);
        try {
            if (!RestApiUtils.isArchiveContainer(managerConfig, session, containerName)) {
                throw new NotAnArchiveContainer();
            }
        }
        catch (ServiceException se) {
            if (se.getHttpStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                throw new ContainerNotFound();
            }
            throw se;
        }
        String jobId = null;
        try {
            jobId = RestApiUtils.startRestore(managerConfig, session, containerName, objectName);
        }
        catch (ServiceException se) {
            if (se.getHttpStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                throw new ObjectNotFound();
            }
            throw se;
        }
        RestoreJob restoreJob = RestApiUtils.getRestoreJob(managerConfig, session, containerName, jobId);
        if (restoreJob.getRestoreJobDetails().getTotalSegments() > 0) {
            if (!restoreJob.isCompleted()) {
                RestApiUtils.updateSLOManifestRestoreJobInProgress(objectRestoreJob, restoreJob);
            } else {
                try {
                    List<SLOSegmentManifest> segmentManifestList = RestApiUtils.getSLOSegmentManifest(managerConfig, session, containerName, objectName, null);
                    RestoreJob segmentsRestoreJob = RestApiUtils.getSLOSegementsRestoreJob(managerConfig, session, RestApiUtils.startSLOSegementsRestore(managerConfig, session, segmentManifestList));
                    RestApiUtils.updateObjectRestoreJobForSegmentsRestore(objectRestoreJob, segmentsRestoreJob, restoreJob);
                }
                catch (IOException e) {
                    logger.error("IOException caught while retrieving manifest file for SLO " + containerName + "/" + objectName + ". " + e.getMessage());
                    throw new ClientException("IOException caught while retrieving manifest file for SLO " + containerName + "/" + objectName, e);
                }
            }
        } else {
            RestApiUtils.updateObjectRestoreJob(objectRestoreJob, restoreJob);
        }
        return objectRestoreJob;
    }

    private static void updateObjectRestoreJob(ObjectRestoreJob objectRestoreJob, RestoreJob restoreJob) {
        objectRestoreJob.setCompleted(restoreJob.isCompleted());
        objectRestoreJob.setCompletedPercentage(restoreJob.getCompletedPercentage());
        objectRestoreJob.setEndTime(restoreJob.getEndTime());
        objectRestoreJob.setJobId(restoreJob.getJobId());
        objectRestoreJob.setJobStatus(restoreJob.getJobStatus());
        objectRestoreJob.setObjectEtag(restoreJob.getRestoreJobDetails().getObjectEtag());
        objectRestoreJob.setObjectExpiration(restoreJob.getRestoreJobDetails().getObjectExpiration());
        objectRestoreJob.setRestoredSegments(restoreJob.getRestoreJobDetails().getRestoredSegments());
        objectRestoreJob.setStartTime(restoreJob.getStartTime());
        objectRestoreJob.setTotalSegments(restoreJob.getRestoreJobDetails().getTotalSegments());
    }

    private static void updateSLOManifestRestoreJobInProgress(ObjectRestoreJob objectRestoreJob, RestoreJob restoreJob) {
        objectRestoreJob.setCompleted(false);
        objectRestoreJob.setCompletedPercentage(1);
        objectRestoreJob.setJobId(restoreJob.getJobId());
        objectRestoreJob.setJobStatus(restoreJob.getJobStatus());
        objectRestoreJob.setObjectEtag(restoreJob.getRestoreJobDetails().getObjectEtag());
        objectRestoreJob.setObjectExpiration(restoreJob.getRestoreJobDetails().getObjectExpiration());
        objectRestoreJob.setRestoredSegments(0);
        objectRestoreJob.setStartTime(restoreJob.getStartTime());
        objectRestoreJob.setTotalSegments(restoreJob.getRestoreJobDetails().getTotalSegments());
    }

    private static void updateObjectRestoreJobForSegmentsRestore(ObjectRestoreJob objectRestoreJob, RestoreJob segmentsRestoreJob, RestoreJob manifestRestoreJob) {
        objectRestoreJob.setCompleted(segmentsRestoreJob.isCompleted());
        objectRestoreJob.setCompletedPercentage(segmentsRestoreJob.getCompletedPercentage());
        objectRestoreJob.setEndTime(segmentsRestoreJob.getEndTime());
        objectRestoreJob.setJobId(manifestRestoreJob.getJobId());
        objectRestoreJob.setJobStatus(segmentsRestoreJob.getJobStatus());
        objectRestoreJob.setObjectEtag(manifestRestoreJob.getRestoreJobDetails().getObjectEtag());
        objectRestoreJob.setObjectExpiration(manifestRestoreJob.getRestoreJobDetails().getObjectExpiration());
        objectRestoreJob.setRestoredSegments(segmentsRestoreJob.getRestoreJobDetails().getRestoredSegments());
        objectRestoreJob.setTotalSegments(segmentsRestoreJob.getRestoreJobDetails().getTotalSegments());
        objectRestoreJob.setStartTime(manifestRestoreJob.getStartTime());
        if (segmentsRestoreJob.getJobStatus().equals((Object)RestoreJobStatus.INPROGRESS) || segmentsRestoreJob.getJobStatus().equals((Object)RestoreJobStatus.PROCESSING)) {
            objectRestoreJob.setArchiveRestoreStatus(ArchiveRestoreStatus.INPROGRESS);
        } else if (segmentsRestoreJob.getJobStatus().equals((Object)RestoreJobStatus.SUCCESS)) {
            objectRestoreJob.setArchiveRestoreStatus(ArchiveRestoreStatus.RESTORED);
        }
    }

    public static String startRestore(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        try {
            IPostObjectReply postObjectReply = ((IPostRequestBuilder.Container)((IPostRequestBuilder.ConnectTimeout)session.post().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName) + "?restore").send();
            if (!postObjectReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + postObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(postObjectReply);
            }
            oracle.cloudstorage.api.header.Map headers = postObjectReply.getHeaders();
            String jobId = (String)headers.get("x-archive-restore-jobid");
            return jobId;
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return null;
        }
    }

    public static RestoreJob getRestoreJob(FileTransferManagerConfig managerConfig, ISession session, String containerName, String jobId) throws ServiceException {
        try {
            IGetContainerReply getContainerReply = ((IGetRequestBuilder.Container)((IGetRequestBuilder.ConnectTimeout)session.get().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName) + "?jobs&jobId=" + jobId)).send();
            if (!getContainerReply.isSuccessful()) {
                logger.trace("HEAD detailed message:" + getContainerReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(getContainerReply);
            }
            Iterator<String> itr = getContainerReply.getObjectIds().iterator();
            if (itr.hasNext()) {
                return new RestoreJob(itr.next());
            }
            throw new ServiceException("Invalid response from cloud storage service for job-id " + jobId);
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
            return null;
        }
    }

    public static ObjectRestoreJob getObjectRestoreJob(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) {
        ObjectRestoreJob objectRestoreJob = new ObjectRestoreJob();
        objectRestoreJob.setContainerName(containerName);
        objectRestoreJob.setObjectName(objectName);
        try {
            if (!RestApiUtils.isArchiveContainer(managerConfig, session, containerName)) {
                throw new NotAnArchiveContainer();
            }
        }
        catch (ServiceException se) {
            if (se.getHttpStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                throw new ContainerNotFound();
            }
            throw se;
        }
        java.util.Map<String, String> headers = null;
        try {
            headers = RestApiUtils.getObjectHeadersWithMultipartManifest(managerConfig, session, containerName, objectName);
        }
        catch (ServiceException se) {
            if (se.getHttpStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                throw new ObjectNotFound();
            }
            throw se;
        }
        ArchiveRestoreStatus restoreStatus = ArchiveRestoreStatus.valueOf(headers.get("x-archive-restore-status").toUpperCase(Locale.US));
        objectRestoreJob.setArchiveRestoreStatus(restoreStatus);
        objectRestoreJob.setObjectEtag(headers.get("etag"));
        String trackingId = headers.get("x-archive-restore-tracking");
        if (trackingId != null) {
            RestoreJob restoreJob = RestApiUtils.getRestoreJob(managerConfig, session, containerName, RestApiUtils.getRestoreJobIdbyTrackingId(trackingId));
            if (restoreJob.getRestoreJobDetails().getTotalSegments() > 0) {
                if (!restoreJob.isCompleted()) {
                    RestApiUtils.updateSLOManifestRestoreJobInProgress(objectRestoreJob, restoreJob);
                } else {
                    try {
                        List<SLOSegmentManifest> segmentManifestList = RestApiUtils.getSLOSegmentManifest(managerConfig, session, containerName, objectName, null);
                        RestoreJob segmentsRestoreJob = RestApiUtils.getSLOSegementsRestoreJob(managerConfig, session, RestApiUtils.startSLOSegementsRestore(managerConfig, session, segmentManifestList));
                        RestApiUtils.updateObjectRestoreJobForSegmentsRestore(objectRestoreJob, segmentsRestoreJob, restoreJob);
                    }
                    catch (IOException e) {
                        logger.error("IOException caught while retrieving manifest file for SLO " + containerName + "/" + objectName + ". " + e.getMessage());
                        throw new ClientException("IOException caught while retrieving manifest file for SLO " + containerName + "/" + objectName, e);
                    }
                }
            } else {
                RestApiUtils.updateObjectRestoreJob(objectRestoreJob, restoreJob);
            }
        }
        return objectRestoreJob;
    }

    public static LinkedHashMap<String, SLOSegmentManifest> startSLOSegementsRestore(FileTransferManagerConfig managerConfig, ISession session, List<SLOSegmentManifest> segmentManifestList) {
        LinkedHashMap<String, SLOSegmentManifest> jobIdMap = new LinkedHashMap<String, SLOSegmentManifest>();
        for (SLOSegmentManifest manifest : segmentManifestList) {
            jobIdMap.put(RestApiUtils.startRestore(managerConfig, session, manifest.getSegmentContainer(), manifest.getObjectName()), manifest);
        }
        return jobIdMap;
    }

    public static RestoreJob getSLOSegementsRestoreJob(FileTransferManagerConfig managerConfig, ISession session, LinkedHashMap<String, SLOSegmentManifest> jobIdMap) throws ServiceException {
        RestoreJob sloRestoreJob = new RestoreJob();
        RestoreJobDetails jobDetails = new RestoreJobDetails();
        sloRestoreJob.setRestoreJobDetails(jobDetails);
        jobDetails.setTotalSegments(jobIdMap.size());
        int jobsInProgress = 0;
        int leastCompletedPercentage = 101;
        for (Map.Entry<String, SLOSegmentManifest> entry : jobIdMap.entrySet()) {
            RestoreJob segmentRestoreJob = RestApiUtils.getRestoreJob(managerConfig, session, entry.getValue().getSegmentContainer(), entry.getKey());
            if (!segmentRestoreJob.isCompleted()) {
                ++jobsInProgress;
                sloRestoreJob.setJobStatus(segmentRestoreJob.getJobStatus());
                if (segmentRestoreJob.getCompletedPercentage() < leastCompletedPercentage) {
                    leastCompletedPercentage = segmentRestoreJob.getCompletedPercentage();
                }
            }
            sloRestoreJob.setEndTime(segmentRestoreJob.getEndTime());
        }
        if (jobsInProgress > 0) {
            sloRestoreJob.setCompleted(false);
            sloRestoreJob.setCompletedPercentage(leastCompletedPercentage == 0 ? 1 : leastCompletedPercentage);
        } else {
            sloRestoreJob.setCompleted(true);
            sloRestoreJob.setCompletedPercentage(100);
            sloRestoreJob.setJobStatus(RestoreJobStatus.SUCCESS);
        }
        jobDetails.setRestoredSegments(jobIdMap.size() - jobsInProgress);
        return sloRestoreJob;
    }

    public static long getObjectSize(java.util.Map<String, String> headers) {
        String contentLen;
        long ret = -1L;
        if (headers != null && (contentLen = headers.get("content-length")) != null && !contentLen.isEmpty()) {
            ret = Long.parseLong(contentLen);
        }
        return ret;
    }

    public static void doObjectDelete(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        try {
            IDeleteObjectReply deleteObjectReply = ((IDeleteRequestBuilder.Object)((IDeleteRequestBuilder.Container)((IDeleteRequestBuilder.ConnectTimeout)session.delete().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
            if (!deleteObjectReply.isSuccessful()) {
                logger.info("DELETE detailed message:" + deleteObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(deleteObjectReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static void doMultipartDelete(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName) throws ServiceException {
        try {
            IDeleteObjectReply deleteObjectReply = ((IDeleteRequestBuilder.Object)((IDeleteRequestBuilder.Container)((IDeleteRequestBuilder.QueryParam)((IDeleteRequestBuilder.ConnectTimeout)session.delete().retry(new DefaultRetryStrategy(managerConfig))).param(QueryParam.multipartManifest.provide("delete"))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
            if (!deleteObjectReply.isSuccessful()) {
                logger.info("DELETE detailed message:" + deleteObjectReply.getContext().buildDetailedMessage());
                throw RestApiUtils.convertToServiceException(deleteObjectReply);
            }
        }
        catch (InterruptedException | RetryException e) {
            RestApiUtils.processRESTApiExecException(e);
        }
    }

    public static void doSloManifestPut(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, JsonArray jsonArray) throws ServiceException {
        boolean retry;
        logger.debug("Uploading manifest file for " + objectName);
        int retryCount = 0;
        IPutObjectReply putObjectReply = null;
        IHeadObjectReply headObjectReply = null;
        ClientException lastError = null;
        do {
            retry = false;
            if (retryCount > 0) {
                logger.warn("Retrying SLO manifest upload...retry count: " + retryCount);
            }
            try {
                headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();
                if (!headObjectReply.isSuccessful() && !headObjectReply.getStatus().equals((Object)Status.NOT_FOUND)) {
                    lastError = RestApiUtils.convertToServiceException(headObjectReply);
                    retry = false;
                    throw lastError;
                }
                putObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.QueryParam)((IPutRequestBuilder.Header)((IPutRequestBuilder.ConnectTimeout)session.put().retry(new PutRetryStrategy(managerConfig))).header(Header.provide("X-Static-Large-Object", "True"))).param(QueryParam.multipartManifest.provide("put"))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).data(jsonArray.toString()).send();
                if (putObjectReply.isSuccessful()) {
                    logger.info("Manifest uploaded successfully for " + objectName);
                    return;
                }
                ServiceException se = RestApiUtils.convertToServiceException(putObjectReply);
                lastError = new ClientException(se);
                Status status = putObjectReply.getStatus();
                retry = status.getStatusCode() == 403 || status.equals((Object)Status.INTERNAL_SERVER_ERROR) || status.equals((Object)Status.BAD_REQUEST);
                logger.info("PUT failed: retry:" + retry);
            }
            catch (RetryException e) {
                logger.trace("Exception caught for uploading " + objectName + ". Upload will be retried. current retry count: " + retryCount + "\n" + e.getMessage());
                retry = true;
                lastError = RestApiUtils.convertRESTApiExecExceptionToServiceEx(e);
            }
            catch (ClientException ce) {
                lastError = ce;
            }
            catch (InterruptedException e) {
                logger.error("Failure uploading file: " + objectName + "\n" + e.getMessage());
                retry = false;
                lastError = new ClientException(e.getMessage(), e);
            }
            if (retryCount >= managerConfig.getMaxRestApiRetries()) {
                retry = false;
            }
            ++retryCount;
        } while (retry);
        logger.error("ERROR: Failure uploading manifest for object: " + objectName);
        if (lastError == null) {
            throw new ClientException("Unknown Exception while uploading manifest for object: " + objectName);
        }
        throw lastError;
    }

    public static void copySlo(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, String objectCopyName) throws ClientException, ServiceException {
        try {
            List<SLOSegmentManifest> sloManifestList = RestApiUtils.getSLOSegmentManifest(managerConfig, session, containerName, objectName, null);
            JsonArray jsonArray = SLOSegmentManifest.getSLOSegmentManifestForUpload(sloManifestList);
            RestApiUtils.doSloManifestPut(managerConfig, session, containerName, objectCopyName, jsonArray);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    public static void downloadRegularFile(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, File file, boolean isMultiPartManifest) {
        DownloadFullObject dfo = new DownloadFullObject(managerConfig, session, file, containerName, objectName, isMultiPartManifest);
        dfo.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SLOSegmentManifest> getSLOSegmentManifest(FileTransferManagerConfig managerConfig, ISession session, String containerName, String objectName, String tempDownloadDirPath) throws IOException {
        File manifestFile = null;
        try {
            File dir = null;
            if (tempDownloadDirPath != null && !tempDownloadDirPath.isEmpty()) {
                dir = new File(tempDownloadDirPath);
            }
            manifestFile = File.createTempFile("ftmapi-", ".manifest", dir);
            RestApiUtils.downloadRegularFile(managerConfig, session, containerName, objectName, manifestFile, true);
            logger.debug("Downloaded a SLO manifest file " + manifestFile.getAbsolutePath());
            List<SLOSegmentManifest> list = FileUtils.getSLOSegementManifest(manifestFile);
            return list;
        }
        finally {
            if (manifestFile != null && manifestFile.exists() && !manifestFile.delete()) {
                logger.trace("Failed to delete manifest file " + manifestFile.getAbsolutePath());
            }
        }
    }

    public static List<SLOSegmentManifest> getPartiallyUploadedSLOSegments(FileTransferManagerConfig managerConfig, ISession session, String segmentContainerName, String segmentPrefix) {
        List<String> segObjects = RestApiUtils.getObjects(managerConfig, session, segmentContainerName, segmentPrefix);
        ArrayList<SLOSegmentManifest> segmentManifestList = new ArrayList<SLOSegmentManifest>(segObjects.size());
        for (String objName : segObjects) {
            segmentManifestList.add(RestApiUtils.getSLOSegmentManifest(managerConfig, session, segmentContainerName, objName));
        }
        return segmentManifestList;
    }

    private static SLOSegmentManifest getSLOSegmentManifest(FileTransferManagerConfig managerConfig, ISession session, String segmentContainerName, String segmentObjectName) {
        SLOSegmentManifest segmentManifest = new SLOSegmentManifest();
        java.util.Map<String, String> headers = RestApiUtils.getObjectHeaders(managerConfig, session, segmentContainerName, segmentObjectName);
        segmentManifest.setContentType(headers.get(Header.contentType));
        segmentManifest.setName("/" + segmentContainerName + "/" + segmentObjectName);
        segmentManifest.setHash(headers.get(Header.eTag));
        segmentManifest.setLastModified(headers.get(Header.lastModified));
        segmentManifest.setBytes(Long.parseLong(headers.get(Header.contentLength)));
        return segmentManifest;
    }

    public static String uriEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder encodedStr = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                encodedStr.append("/");
                continue;
            }
            if (tok.equals(" ")) {
                encodedStr.append("%20");
                continue;
            }
            try {
                encodedStr.append(URLEncoder.encode(tok, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return encodedStr.toString();
    }

    private static Date getDateFromHeaderValue(String time) {
        if (time != null) {
            return new Date((long)(Double.parseDouble(time) * 1000.0));
        }
        return null;
    }

    private static String getRestoreJobIdbyTrackingId(String trackingId) {
        return trackingId.substring(trackingId.lastIndexOf("?jobs&jobId=") + "?jobs&jobId=".length());
    }

    public static ServiceException convertToServiceException(IReply reply) {
        String txId = null;
        if (reply != null && reply.getHeaders() != null) {
            txId = reply.getHeaders().get("x-trans-id");
            ServiceException se = new ServiceException(reply.getStatus().getStatusCode(), txId, reply.getStatus().getReasonPhrase());
            logger.info("Service exception: " + ExceptionUtils.getTransDetails(reply.getContext().buildDetailedMessage()));
            return se;
        }
        logger.info("Invalid server response.");
        return new ServiceException("Invalid server response.");
    }
}

