/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import oracle.cloudstorage.ftm.internal.RestoreJobDetails;
import oracle.cloudstorage.ftm.internal.UploadFile;
import oracle.cloudstorage.ftm.model.RestoreJobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreJob {
    static final Logger logger = LoggerFactory.getLogger(UploadFile.class);
    private String jobId;
    private RestoreJobStatus jobStatus;
    private int completedPercentage;
    private boolean completed;
    private long startTime;
    private long endTime;
    private RestoreJobDetails restoreJobDetails;

    public RestoreJob() {
    }

    public RestoreJob(String jsonJobDetails) {
        try (JsonReader reader = Json.createReader(new StringReader(jsonJobDetails));){
            String objectExpiration;
            String restoredSegments;
            JsonObject obj = reader.readObject();
            this.completedPercentage = obj.getInt("completedPercentage");
            this.completed = obj.getBoolean("completed");
            this.jobId = obj.getString("jobId");
            this.jobStatus = RestoreJobStatus.valueOf(obj.getString("progress").toUpperCase(Locale.US));
            JsonObject innerJsonObject = obj.getJsonObject("jobDetails");
            this.restoreJobDetails = new RestoreJobDetails();
            this.restoreJobDetails.setObjectEtag(innerJsonObject.getString("objectEtag"));
            try {
                restoredSegments = innerJsonObject.getString("restoredSegments");
            }
            catch (ClassCastException | NullPointerException e) {
                restoredSegments = null;
            }
            String timeStamp = null;
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd,HH:mm");
                timeStamp = obj.getString("startTime");
                Date date = formatter.parse(timeStamp);
                this.startTime = date.getTime();
                try {
                    timeStamp = obj.getString("endTime");
                    date = formatter.parse(timeStamp);
                    this.endTime = date.getTime();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (ClassCastException | ParseException e1) {
                logger.debug("Unable to parse time stamp " + timeStamp + ". " + e1.getMessage());
            }
            if (restoredSegments != null && !restoredSegments.isEmpty()) {
                this.restoreJobDetails.setRestoredSegments(Integer.parseInt(restoredSegments));
            }
            String totalSegments = null;
            try {
                totalSegments = innerJsonObject.getString("totalSegments");
            }
            catch (Exception date) {
                // empty catch block
            }
            if (totalSegments != null && !totalSegments.isEmpty()) {
                this.restoreJobDetails.setTotalSegments(Integer.parseInt(totalSegments));
            }
            if ((objectExpiration = innerJsonObject.getString("objectExpiration")) != null && !objectExpiration.isEmpty()) {
                this.restoreJobDetails.setObjectExpiration(Long.parseLong(objectExpiration));
            }
            if (this.restoreJobDetails.getTotalSegments() > 0 && this.restoreJobDetails.getRestoredSegments() < this.restoreJobDetails.getTotalSegments()) {
                this.completed = false;
            }
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public RestoreJobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(RestoreJobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public int getCompletedPercentage() {
        return this.completedPercentage;
    }

    public void setCompletedPercentage(int completedPercentage) {
        this.completedPercentage = completedPercentage;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public RestoreJobDetails getRestoreJobDetails() {
        return this.restoreJobDetails;
    }

    public void setRestoreJobDetails(RestoreJobDetails restoreJobDetails) {
        this.restoreJobDetails = restoreJobDetails;
    }
}

