/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class SLOSegmentManifest {
    private String hash;
    private String lastModified;
    private long bytes;
    private String name;
    private String contentType;
    private String segmentContainer;
    private String objectName;

    public SLOSegmentManifest() {
    }

    public SLOSegmentManifest(String hash, String lastModified, long bytes, String name, String contentType) {
        this.hash = hash;
        this.lastModified = lastModified;
        this.bytes = bytes;
        this.setName(name);
        this.contentType = contentType;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setSegmentContainerUsingSegmentName(name);
        this.setObjectNameUsingSegmentName(name);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSegmentContainer() {
        return this.segmentContainer;
    }

    public void setSegmentContainer(String segmentContainer) {
        this.segmentContainer = segmentContainer;
    }

    private void setSegmentContainerUsingSegmentName(String segmentName) {
        this.segmentContainer = segmentName.substring(1, segmentName.indexOf("/", 1));
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    private void setObjectNameUsingSegmentName(String segmentName) {
        this.objectName = segmentName.substring(segmentName.indexOf("/", 1) + 1);
    }

    public String toString() {
        return "name: " + this.name + ", hash: " + this.hash + ", last_modified: " + this.lastModified + ", bytes: " + this.bytes + ", content_type: " + this.contentType + ", segmentContainer: " + this.segmentContainer + ", objectName: " + this.objectName;
    }

    public static String toString(List<SLOSegmentManifest> segmentManifestList) {
        StringBuffer sb = new StringBuffer();
        for (SLOSegmentManifest sm : segmentManifestList) {
            sb.append(sm.toString() + "\n");
        }
        return sb.toString();
    }

    public static long getSLOSize(List<SLOSegmentManifest> sloSegmentManifestList) {
        long size = 0L;
        if (sloSegmentManifestList.size() > 1) {
            size = sloSegmentManifestList.get(0).getBytes() * (long)(sloSegmentManifestList.size() - 1);
            size += sloSegmentManifestList.get(sloSegmentManifestList.size() - 1).getBytes();
        } else if (sloSegmentManifestList.size() == 1) {
            size = sloSegmentManifestList.get(0).getBytes();
        }
        return size;
    }

    public static JsonArray getSLOSegmentManifestForUpload(List<SLOSegmentManifest> sloSegmentManifestList) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (SLOSegmentManifest sm : sloSegmentManifestList) {
            JsonObjectBuilder objBuilder = Json.createObjectBuilder().add("path", sm.getName()).add("etag", sm.getHash()).add("size_bytes", sm.getBytes());
            builder.add(objBuilder);
        }
        return builder.build();
    }
}

