/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import oracle.cloudstorage.ftm.CloudStorageClass;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.internal.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLOTransferManifest {
    static final Logger logger = LoggerFactory.getLogger(SLOTransferManifest.class);
    private static final String SLO_MANIFESTFILE_HOME = System.getProperty("user.home") + File.separator + ".oscs/ftm";
    private static final String SLO_MANIFESTFILE_SUFFIX = "-FtmSloTxManifest.txt";
    private String path;
    private String fileName;
    private long segmentSize;
    private String objectName;
    private String containerName;
    private String segmentContainerName;
    private CloudStorageClass storageClass;
    private long timestamp;
    private String segmentPrefix;
    private Path manifestFilePath;

    public SLOTransferManifest(File file, String objectName, String containerName, UploadConfig uploadConfig, long timestamp, String segmentPrefix) {
        this.path = file.getAbsolutePath();
        this.fileName = file.getName();
        this.segmentSize = uploadConfig.getSegmentSize();
        this.objectName = objectName;
        this.containerName = containerName;
        this.segmentContainerName = uploadConfig.getSegmentsContainer();
        this.storageClass = uploadConfig.getStorageClass();
        this.timestamp = timestamp;
        this.segmentPrefix = segmentPrefix;
    }

    public SLOTransferManifest(String path, String filename, long segmentSize, String objectName, String containerName, String segmentContainerName, CloudStorageClass storageClass, long timestamp, String segmentPrefix) {
        this.path = path;
        this.fileName = filename;
        this.segmentSize = segmentSize;
        this.objectName = objectName;
        this.containerName = containerName;
        this.segmentContainerName = segmentContainerName;
        this.storageClass = storageClass;
        this.timestamp = timestamp;
        this.segmentPrefix = segmentPrefix;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String filename) {
        this.fileName = filename;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(long segmentSize) {
        this.segmentSize = segmentSize;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getSegmentContainerName() {
        return this.segmentContainerName;
    }

    public void setSegmentContainerName(String segmentContainerName) {
        this.segmentContainerName = segmentContainerName;
    }

    public CloudStorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(CloudStorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getSegmentPrefix() {
        return this.segmentPrefix;
    }

    public void setSegmentPrefix(String segmentPrefix) {
        this.segmentPrefix = segmentPrefix;
    }

    public Path getManifestFilePath() {
        return this.manifestFilePath;
    }

    public void setManifestFilePath(Path manifestFilePath) {
        this.manifestFilePath = manifestFilePath;
    }

    public String toString() {
        return "SLOTransferManifest [path=" + this.path + ", fileName=" + this.fileName + ", segmentSize=" + this.segmentSize + ", objectName=" + this.objectName + ", containerName=" + this.containerName + ", segmentContainerName=" + this.segmentContainerName + ", storageClass=" + (Object)((Object)this.storageClass) + ", timestamp=" + this.timestamp + ", segmentPrefix=" + this.segmentPrefix + ", manifestFilePath=" + this.manifestFilePath + "]";
    }

    private String toManifestFileFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("path=\"" + StringUtils.convertToUnixPath(this.path) + "\"\n");
        sb.append("fileName=\"" + this.fileName + "\"\n");
        sb.append("objectName=\"" + this.objectName + "\"\n");
        sb.append("segmentSize=\"" + this.segmentSize + "\"\n");
        sb.append("containerName=\"" + this.containerName + "\"\n");
        sb.append("segmentContainerName=\"" + (this.segmentContainerName == null ? "" : this.segmentContainerName) + "\"\n");
        sb.append("storageClass=\"" + (Object)((Object)this.storageClass) + "\"\n");
        sb.append("timestamp=\"" + this.timestamp + "\"\n");
        sb.append("segmentPrefix=\"" + this.segmentPrefix + "\"\n");
        return sb.toString();
    }

    public void createManifestFile() {
        File manifestDir = new File(SLO_MANIFESTFILE_HOME);
        try {
            if (!(manifestDir.exists() || manifestDir.mkdirs() || manifestDir.exists())) {
                throw new ClientException("Failed to create FTM API home directory for manifest files.");
            }
            String manifestFileName = SLOTransferManifest.getManifestFileName(this.fileName, this.timestamp);
            this.manifestFilePath = Paths.get(manifestDir + File.separator + manifestFileName, new String[0]);
            Files.write(this.manifestFilePath, this.toManifestFileFormat().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Failed to create SLO transfer manifest file." + e.getMessage());
            logger.debug("Failed to create SLO transfer manifest file." + e);
            throw new ClientException("Failed to create SLO transfer manifest file.", e);
        }
    }

    private static String getManifestFileName(String filename, long timestamp) {
        return filename + "-" + timestamp + SLO_MANIFESTFILE_SUFFIX;
    }

    private static String getTimestampInFileName(String manifestFileName, String uploadFileName) {
        return manifestFileName.substring((uploadFileName + "-").length(), manifestFileName.lastIndexOf(SLO_MANIFESTFILE_SUFFIX));
    }

    public void deleteManifestFile() {
        try {
            if (this.manifestFilePath != null) {
                Files.deleteIfExists(this.manifestFilePath);
            }
        }
        catch (IOException e) {
            logger.debug("Failed to delete SLO transfer manifest file." + e);
        }
    }

    public static SLOTransferManifest getSLOTransferManifest(File file, String objectName, String containerName, UploadConfig config, long timestamp, String segmentPrefix) {
        File manifestDir = new File(SLO_MANIFESTFILE_HOME);
        SLOTransferManifest manifest = null;
        SLOTransferManifest manifestNew = new SLOTransferManifest(file, objectName, containerName, config, timestamp, segmentPrefix);
        if (manifestDir.exists()) {
            for (File f : SLOTransferManifest.listManifestFiles(file.getName())) {
                SLOTransferManifest manifestCurrent = SLOTransferManifest.createSLOTransferManifestFromFile(f);
                if (!manifestNew.compareManifest(manifestCurrent)) continue;
                manifest = manifestCurrent;
                break;
            }
        }
        if (manifest == null) {
            manifest = manifestNew;
            manifest.createManifestFile();
        }
        return manifest;
    }

    private static File[] listManifestFiles(final String fileName) {
        final File f = new File(SLO_MANIFESTFILE_HOME);
        File[] matchingFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String suffix;
                String[] tokens;
                if (dir.getAbsolutePath().equals(f.getAbsolutePath()) && name.startsWith(fileName + "-") && name.endsWith(SLOTransferManifest.SLO_MANIFESTFILE_SUFFIX) && (tokens = (suffix = name.substring((fileName + "-").length())).split("-")).length == 2) {
                    try {
                        Long.parseLong(tokens[0]);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return false;
            }
        });
        return matchingFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SLOTransferManifest createSLOTransferManifestFromFile(File manifestFile) {
        Properties prop = new Properties();
        SLOTransferManifest manifest = null;
        String path = null;
        String filename = null;
        String objectName = null;
        String containerName = null;
        String segmentContainerName = null;
        String storageClass = null;
        String segmentPrefix = null;
        long timestamp = 0L;
        long segmentSize = 0L;
        String[] properties = new String[]{"path", "fileName", "objectName", "segmentSize", "containerName", "segmentContainerName", "storageClass", "segmentPrefix", "timestamp"};
        try (FileInputStream input = new FileInputStream(manifestFile);){
            prop.load(input);
            block43: for (String propName : properties) {
                String value = prop.getProperty(propName);
                if (value == null) {
                    String string = null;
                    return string;
                }
                value = StringUtils.trimQuotes(value);
                switch (propName) {
                    case "timestamp": {
                        if (objectName == null || filename == null) {
                            SLOTransferManifest sLOTransferManifest = null;
                            return sLOTransferManifest;
                        }
                        String tsFileName = SLOTransferManifest.getTimestampInFileName(manifestFile.getName(), filename);
                        if (!value.equals(tsFileName)) {
                            SLOTransferManifest sLOTransferManifest = null;
                            return sLOTransferManifest;
                        }
                        timestamp = Long.parseLong(value);
                        continue block43;
                    }
                    case "segmentSize": {
                        segmentSize = Long.parseLong(value);
                        continue block43;
                    }
                    case "path": {
                        path = value;
                        continue block43;
                    }
                    case "fileName": {
                        filename = value;
                        continue block43;
                    }
                    case "objectName": {
                        objectName = value;
                        continue block43;
                    }
                    case "containerName": {
                        containerName = value;
                        continue block43;
                    }
                    case "segmentContainerName": {
                        segmentContainerName = value;
                        continue block43;
                    }
                    case "storageClass": {
                        storageClass = value;
                        continue block43;
                    }
                    case "segmentPrefix": {
                        segmentPrefix = value;
                        continue block43;
                    }
                }
            }
            manifest = new SLOTransferManifest(path, filename, segmentSize, objectName, containerName, segmentContainerName, CloudStorageClass.valueOf(storageClass), timestamp, segmentPrefix);
            manifest.setManifestFilePath(manifestFile.toPath());
            return manifest;
        }
        catch (FileNotFoundException ex) {
            logger.debug("SLO transfer manifest file " + manifestFile.getAbsolutePath() + " not found." + ex);
            return manifest;
        }
        catch (Exception ex) {
            logger.debug("Error while reading SLO transfer manifest file " + manifestFile.getAbsolutePath() + ". " + ex);
        }
        return manifest;
    }

    private boolean compareManifest(SLOTransferManifest obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        SLOTransferManifest other = obj;
        if (this.containerName == null ? other.containerName != null : !this.containerName.equals(other.containerName)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.objectName == null ? other.objectName != null : !this.objectName.equals(other.objectName)) {
            return false;
        }
        if (this.path == null ? other.path != null : !StringUtils.convertToUnixPath(this.path).equals(StringUtils.convertToUnixPath(other.path))) {
            return false;
        }
        if (this.segmentContainerName == null ? other.segmentContainerName != null : !this.segmentContainerName.equals(other.segmentContainerName)) {
            return false;
        }
        if (this.segmentSize != other.segmentSize) {
            return false;
        }
        return this.storageClass == other.storageClass;
    }
}

