/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.util.StringTokenizer;

public class StringUtils {
    public static String trimQuotes(String s) {
        if (s != null && s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            if (s.length() == 2) {
                return "";
            }
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String convertToUnixPath(String s) {
        if (s == null) {
            return s;
        }
        return s.replaceAll("\\\\", "/");
    }

    public static String trimLeadingSlash(String s) {
        if (s == null) {
            return s;
        }
        String ret = s;
        while (!ret.isEmpty() && ret.startsWith("/")) {
            ret = ret.substring(1);
        }
        return ret;
    }

    public static String trimMetadataKeyPrefix(String metaKey) {
        if (metaKey == null) {
            return metaKey;
        }
        String ret = metaKey.toLowerCase();
        if (!ret.isEmpty()) {
            if (ret.startsWith("x-object-meta-")) {
                ret = metaKey.substring("x-object-meta-".length());
            }
            if (ret.startsWith("x-account-meta-")) {
                ret = metaKey.substring("x-account-meta-".length());
            }
            if (ret.startsWith("x-container-meta-")) {
                ret = metaKey.substring("x-container-meta-".length());
            }
        }
        return ret;
    }

    public static String normalizeObjectName(String objectName) {
        if (objectName == null || objectName.isEmpty()) {
            return objectName;
        }
        StringBuilder ret = new StringBuilder();
        StringTokenizer st = new StringTokenizer(objectName, "/", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                if (ret.toString().endsWith("/")) continue;
                ret.append("/");
                continue;
            }
            ret.append(tok);
        }
        return ret.toString();
    }
}

