/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.json.JsonArray;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadContainerReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.CloudStorageClass;
import oracle.cloudstorage.ftm.FileTransferManager;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.ContainerSSEPolicyMismatch;
import oracle.cloudstorage.ftm.exception.ContainerStorageClassValidationFailed;
import oracle.cloudstorage.ftm.exception.Md5ChecksumFailed;
import oracle.cloudstorage.ftm.exception.ObjectExists;
import oracle.cloudstorage.ftm.exception.ServiceException;
import oracle.cloudstorage.ftm.exception.UnsupportedSSEPolicy;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import oracle.cloudstorage.ftm.internal.SLOSegmentManifest;
import oracle.cloudstorage.ftm.internal.SLOTransferManifest;
import oracle.cloudstorage.ftm.internal.StringUtils;
import oracle.cloudstorage.ftm.internal.UploadFullObject;
import oracle.cloudstorage.ftm.internal.UploadSegment;
import oracle.cloudstorage.ftm.internal.UploadSegmentUtil;
import oracle.cloudstorage.ftm.model.CloudContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFile {
    static final Logger logger = LoggerFactory.getLogger(UploadFile.class);
    public static final int RC_FILE_READ_COMPLETE = -100;

    public static void upload(FileTransferManager fileTransferManager, UploadConfig uploadConfig, ExecutorService threadPool, String containerName, String objectName, File file) throws ClientException, ServiceException {
        block62: {
            Throwable throwable;
            ISession session = fileTransferManager.getSession();
            FileTransferManagerConfig managerConfig = fileTransferManager.getFileTransferManagerConfig();
            UploadConfig uploadConfigCloned = (UploadConfig)uploadConfig.clone();
            CloudStorageClass storageClass = uploadConfigCloned.getStorageClass();
            long segmentSize = 0xC800000L;
            String segmentsContainer = containerName + "_segments";
            if (uploadConfigCloned.getSegmentSize() > 0L) {
                if (uploadConfigCloned.getSegmentSize() > 5368709122L) {
                    segmentSize = 5368709122L;
                    uploadConfigCloned.setSegmentSize(segmentSize);
                } else {
                    segmentSize = uploadConfigCloned.getSegmentSize();
                }
            }
            if (uploadConfigCloned.getSegmentsContainer() != null && !uploadConfigCloned.getSegmentsContainer().isEmpty()) {
                segmentsContainer = uploadConfigCloned.getSegmentsContainer();
            }
            uploadConfigCloned.setSegmentsContainer(segmentsContainer);
            boolean sgementsContainerValidationDone = false;
            boolean sloOverwrite = false;
            try {
                throwable = null;
                try (IGetObjectReply getObjectReply = ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)((IGetRequestBuilder.ConnectTimeout)session.get().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).object(RestApiUtils.uriEncode(objectName))).send();){
                    if (getObjectReply.isSuccessful()) {
                        if (!uploadConfigCloned.isOverwrite()) {
                            throw new ObjectExists(file.getName(), containerName);
                        }
                        sloOverwrite = true;
                    } else if (getObjectReply.getMessage().contains("you must first restore it")) {
                        if (!uploadConfigCloned.isOverwrite()) {
                            throw new ObjectExists(file.getName(), containerName);
                        }
                        sloOverwrite = true;
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            catch (InterruptedException | RetryException e) {
                RestApiUtils.processRESTApiExecException(e);
            }
            catch (IOException e1) {
                logger.error("Failed to verify if object exists: Exception: " + e1.getMessage());
                throw new ClientException("Failed to verify if object exists. " + e1.getMessage(), e1);
            }
            try {
                throwable = null;
                try (UploadSegmentUtil uploadSegmentUtil = new UploadSegmentUtil(file, segmentSize);){
                    logger.info("Uploading file : " + file.getName() + " as " + containerName + "/" + objectName + " ...");
                    long timestamp = System.currentTimeMillis();
                    if (uploadSegmentUtil.isSegmented()) {
                        boolean isResume;
                        if (!sgementsContainerValidationDone) {
                            UploadFile.verifySegmentsContainer(managerConfig, session, segmentsContainer, storageClass, containerName);
                            sgementsContainerValidationDone = true;
                        }
                        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
                        String segmentPrefix = UploadSegmentUtil.getSegmentPrefix(objectName, timestamp);
                        SLOTransferManifest transferManifest = SLOTransferManifest.getSLOTransferManifest(file, objectName, containerName, uploadConfigCloned, timestamp, segmentPrefix);
                        uploadSegmentUtil.setTransferManifest(transferManifest);
                        boolean bl = isResume = timestamp > transferManifest.getTimestamp();
                        if (isResume) {
                            timestamp = transferManifest.getTimestamp();
                            List<SLOSegmentManifest> preExistingSLOSegmentManifests = RestApiUtils.getPartiallyUploadedSLOSegments(managerConfig, session, transferManifest.getSegmentContainerName(), transferManifest.getSegmentPrefix());
                            uploadSegmentUtil.setPreExistingSLOSegmentManifests(preExistingSLOSegmentManifests);
                        }
                        int index = uploadSegmentUtil.createSegmentInputStream();
                        while (index != -100) {
                            boolean skipMsg = false;
                            try {
                                UploadFile.waitForAnyTaskToComplete(futures, uploadConfigCloned.getMaxThreadsPerLargeObjectTransfer(), uploadSegmentUtil, skipMsg);
                                logger.trace("Uploading segment " + index + "...");
                                Future<Boolean> future = threadPool.submit(new UploadSegment(managerConfig, session, uploadSegmentUtil, file, index, segmentsContainer, objectName, timestamp));
                                futures.add(future);
                                index = uploadSegmentUtil.createSegmentInputStream();
                                logger.trace("Created next segment with index " + index + " for file " + file.getAbsolutePath() + " and resource " + segmentsContainer + "/" + objectName);
                            }
                            catch (ClientException clientException) {
                                logger.error(clientException.getMessage());
                                UploadFile.cancelFutures(futures);
                                throw clientException;
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                logger.error(exception.getMessage());
                                UploadFile.cancelFutures(futures);
                                throw new ClientException(exception.getMessage(), exception);
                            }
                        }
                        try {
                            for (Future future : futures) {
                                if (((Boolean)future.get()).booleanValue()) continue;
                                logger.error("One of the segment upload failed! Exiting...");
                                UploadFile.cancelFutures(futures);
                            }
                        }
                        catch (ClientException e) {
                            throw e;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            logger.error(e.getMessage());
                            throw new ClientException(e);
                        }
                        finally {
                            UploadFile.cancelFutures(futures);
                        }
                        String copyName = objectName + "_ftm_delete_";
                        if (sloOverwrite && storageClass.equals((Object)CloudStorageClass.Standard)) {
                            try {
                                RestApiUtils.copySlo(managerConfig, session, containerName, objectName, copyName);
                            }
                            catch (Exception exception) {
                                logger.warn("Failed to copy existing object " + objectName + " before overwriting it. " + exception.getMessage());
                            }
                        }
                        JsonArray jsonArray = uploadSegmentUtil.getSloManifest(objectName, segmentsContainer, timestamp);
                        logger.trace("jsonArray for SLO upload: " + jsonArray.toString());
                        try {
                            RestApiUtils.doSloManifestPut(managerConfig, session, containerName, objectName, jsonArray);
                            transferManifest.deleteManifestFile();
                            if (sloOverwrite && storageClass.equals((Object)CloudStorageClass.Standard)) {
                                try {
                                    RestApiUtils.doMultipartDelete(managerConfig, session, containerName, copyName);
                                }
                                catch (Exception e) {
                                    logger.warn("Failed to delete existing object. " + e.getMessage());
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Failed to upload manifest file for  " + file.getName() + ".");
                            throw e;
                        }
                        logger.info("Uploaded completed successfully for a file " + file.getName() + " as a SLO " + containerName + "/" + objectName);
                        break block62;
                    }
                    UploadFullObject ufo = new UploadFullObject(managerConfig, session, uploadConfigCloned, file, containerName, objectName, uploadSegmentUtil);
                    ufo.run();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e1) {
                logger.error("Failed to close input file for  " + file.getName() + "." + e1.getMessage());
                throw new ClientException("Failed to close input file for  " + file.getName() + "." + e1.getMessage(), e1);
            }
        }
    }

    private static void waitForAnyTaskToComplete(LinkedList<Future<Boolean>> futures, int maxThreadsAllowed, UploadSegmentUtil uploadSegmentUtil, boolean skipMsg) throws InterruptedException, ExecutionException {
        block0: while (futures.size() == maxThreadsAllowed) {
            if (!skipMsg) {
                logger.info("Waiting for current threads to complete...");
                skipMsg = true;
            }
            Thread.sleep(100L);
            for (Future future : futures) {
                if (!future.isDone()) continue;
                if (!((Boolean)future.get()).booleanValue()) {
                    UploadFile.cancelFutures(futures);
                    continue;
                }
                futures.remove(future);
                continue block0;
            }
        }
    }

    private static void cancelFutures(LinkedList<Future<Boolean>> futures) {
        for (Future future : futures) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
    }

    public static void verifyMetaChecksum(FileTransferManagerConfig managerConfig, ISession session, String expectedChecksum, String containerName, String objectName) {
        Map<String, String> objHeaders = RestApiUtils.getObjectHeaders(managerConfig, session, containerName, objectName);
        String reportedChecksum = StringUtils.trimQuotes(objHeaders.get("Etag"));
        if (!expectedChecksum.equals(reportedChecksum)) {
            throw new Md5ChecksumFailed(containerName, objectName);
        }
    }

    public static void verifyContainer(FileTransferManagerConfig managerConfig, ISession session, String containerName, CloudStorageClass storageClass) throws ClientException, ServiceException {
        block6: {
            try {
                IHeadContainerReply headContainerReply = ((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)session.head().retry(new DefaultRetryStrategy(managerConfig))).container(RestApiUtils.uriEncode(containerName))).send();
                if (headContainerReply.isSuccessful()) {
                    String headerValue = headContainerReply.getHeader("X-Storage-Class");
                    CloudStorageClass currentStorageClass = CloudStorageClass.Standard;
                    if (headerValue != null && headerValue.equalsIgnoreCase(CloudStorageClass.Archive.toString())) {
                        currentStorageClass = CloudStorageClass.Archive;
                    }
                    if (!currentStorageClass.equals((Object)storageClass)) {
                        logger.error("container [" + containerName + "] is not compatible with specified Storage Class: " + storageClass.toString());
                        throw new ContainerStorageClassValidationFailed(containerName);
                    }
                    break block6;
                }
                if (headContainerReply.getStatus().getStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                    RestApiUtils.putContainer(managerConfig, session, containerName, storageClass, false);
                    break block6;
                }
                logger.error("Failed to verify if container [" + containerName + "] exists. " + headContainerReply.getStatus().getStatusCode() + " reason:" + headContainerReply.getStatus().getReasonPhrase());
                throw new ServiceException(headContainerReply.getStatus().getStatusCode(), null, headContainerReply.getMessage());
            }
            catch (InterruptedException | RetryException e) {
                RestApiUtils.processRESTApiExecException(e);
            }
        }
    }

    public static void verifySegmentsContainer(FileTransferManagerConfig managerConfig, ISession session, String segmentsContainerName, CloudStorageClass storageClass, String containerName) throws ClientException, ServiceException {
        CloudContainer objectContainer = RestApiUtils.getContainer(managerConfig, session, containerName);
        String objectContainerSSEPolicy = objectContainer.getServerSideEncryptionPolicy() == null ? "NONE" : objectContainer.getServerSideEncryptionPolicy();
        try {
            String segmentsContainerSSEPolicy;
            CloudContainer segmentsContainer = RestApiUtils.getContainer(managerConfig, session, segmentsContainerName);
            CloudStorageClass currentStorageClass = CloudStorageClass.valueOf(segmentsContainer.getStorageClass());
            if (!currentStorageClass.equals((Object)storageClass)) {
                logger.error("container [" + segmentsContainerName + "] is not compatible with specified Storage Class: " + storageClass.toString());
                throw new ContainerStorageClassValidationFailed(segmentsContainerName);
            }
            String string = segmentsContainerSSEPolicy = segmentsContainer.getServerSideEncryptionPolicy() == null ? "NONE" : segmentsContainer.getServerSideEncryptionPolicy();
            if (!segmentsContainerSSEPolicy.equals(objectContainerSSEPolicy)) {
                logger.error("The object's container " + containerName + "[SSE policy: " + objectContainerSSEPolicy + "] " + " and the segments' container " + segmentsContainerName + "[SSE policy: " + segmentsContainerSSEPolicy + "] " + " have different SSE policies.");
                throw new ContainerSSEPolicyMismatch();
            }
        }
        catch (ServiceException se) {
            if (se.getHttpStatusCode() == Status.NOT_FOUND.getStatusCode()) {
                if (objectContainerSSEPolicy.equals("NONE")) {
                    RestApiUtils.putContainer(managerConfig, session, segmentsContainerName, storageClass, false);
                } else if (objectContainerSSEPolicy.equals("BASE_ENCRYPTION")) {
                    RestApiUtils.putContainer(managerConfig, session, segmentsContainerName, storageClass, true);
                } else {
                    logger.error("Unsupported object container's SSE policy [" + objectContainerSSEPolicy + "]. Cannot create segments container " + segmentsContainerName + ".");
                    throw new UnsupportedSSEPolicy();
                }
                return;
            }
            logger.error("Failed to verify if container [" + segmentsContainerName + "] exists. " + se.getHttpStatusCode() + " reason:" + se.getMessage());
            throw se;
        }
    }
}

