/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.UploadConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.Md5ChecksumFailed;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.Md5ChecksumUtils;
import oracle.cloudstorage.ftm.internal.PutRetryStrategy;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import oracle.cloudstorage.ftm.internal.UploadSegmentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadFullObject
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(UploadFullObject.class);
    FileTransferManagerConfig managerConfig;
    UploadConfig uploadConfig;
    String container;
    private String objectName;
    File file;
    UploadSegmentUtil uploadSegmentUtil;
    ISession session;

    UploadFullObject(FileTransferManagerConfig managerConfig, ISession session, UploadConfig uploadConfig, File file, String container, String objectName, UploadSegmentUtil fileUtils) {
        this.managerConfig = managerConfig;
        this.uploadConfig = uploadConfig;
        this.container = container;
        this.objectName = objectName;
        this.file = file;
        this.uploadSegmentUtil = fileUtils;
        this.session = session;
    }

    @Override
    public void run() {
        int retryCount = 0;
        IPutObjectReply putObjectReply = null;
        IHeadObjectReply headObjectReply = null;
        boolean retry = false;
        ClientException lastError = null;
        do {
            retry = false;
            try (FileInputStream fs = new FileInputStream(this.file.getAbsolutePath());){
                if (retryCount > 0) {
                    logger.info("Retrying file upload...retry count: " + retryCount);
                    Thread.sleep((long)retryCount * 5000L);
                }
                String computedMD5 = Md5ChecksumUtils.getFileCheckSum(this.file);
                headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)this.session.head().retry(new DefaultRetryStrategy(this.managerConfig))).container(RestApiUtils.uriEncode(this.container))).object(RestApiUtils.uriEncode(this.objectName))).send();
                if (!headObjectReply.isSuccessful() && !headObjectReply.getStatus().equals((Object)Status.NOT_FOUND)) {
                    lastError = RestApiUtils.convertToServiceException(headObjectReply);
                    retry = false;
                    throw lastError;
                }
                putObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.ConnectTimeout)this.session.put().retry(new PutRetryStrategy(this.managerConfig))).chunk(65536).container(RestApiUtils.uriEncode(this.container))).object(RestApiUtils.uriEncode(this.objectName))).data(fs).send();
                logger.trace(putObjectReply.toString());
                if (putObjectReply.isSuccessful()) {
                    String serverMD5 = putObjectReply.getMd5(1L, TimeUnit.MINUTES);
                    logger.trace("Computed MD5: " + computedMD5);
                    logger.trace("Header   MD5: " + serverMD5);
                    if (serverMD5 != null && serverMD5.equals(computedMD5)) {
                        logger.info("Upload completed successfully for a file [" + this.file.getName() + "] as " + this.container + "/" + this.objectName);
                        return;
                    }
                    logger.warn("MD5 verification failed. Uploaded MD5: " + serverMD5 + ", computed MD5:" + computedMD5);
                    retry = true;
                    lastError = new Md5ChecksumFailed(this.container, this.objectName);
                } else {
                    lastError = RestApiUtils.convertToServiceException(putObjectReply);
                    retry = putObjectReply.getStatus().getStatusCode() == 403 || putObjectReply.getStatus().equals((Object)Status.INTERNAL_SERVER_ERROR) || putObjectReply.getStatus().equals((Object)Status.GATEWAY_TIMEOUT) || putObjectReply.getStatus().equals((Object)Status.REQUEST_TIMEOUT);
                }
            }
            catch (IOException e) {
                logger.trace("Exception caught for uploading " + this.objectName + ". Upload will be retried. current retry count: " + retryCount + "\n" + e.getMessage());
                retry = true;
                lastError = new ClientException(e.getMessage(), e);
            }
            catch (TimeoutException | RetryException e) {
                logger.trace("Exception caught for uploading " + this.objectName + ". Upload will be retried. current retry count: " + retryCount + "\n" + e.getMessage());
                retry = true;
                lastError = RestApiUtils.convertRESTApiExecExceptionToServiceEx(e);
            }
            catch (ClientException ce) {
                lastError = ce;
            }
            catch (InterruptedException | NoSuchAlgorithmException | ExecutionException e) {
                logger.error("Failure uploading file: " + this.objectName + "\n" + e.getMessage());
                lastError = new ClientException(e);
                retry = false;
            }
            if (retryCount >= this.managerConfig.getMaxRestApiRetries()) {
                retry = false;
            }
            ++retryCount;
        } while (retry);
        throw lastError;
    }
}

