/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.ftm.FileTransferManagerConfig;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.Md5ChecksumFailed;
import oracle.cloudstorage.ftm.internal.DefaultRetryStrategy;
import oracle.cloudstorage.ftm.internal.PutRetryStrategy;
import oracle.cloudstorage.ftm.internal.RestApiUtils;
import oracle.cloudstorage.ftm.internal.UploadSegmentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadSegment
implements Callable<Boolean> {
    static final Logger logger = LoggerFactory.getLogger(UploadSegment.class);
    FileTransferManagerConfig managerConfig;
    private String segmentsContainer = "";
    private String objectName;
    private File master = null;
    private int chunkIndex = 0;
    private long timestamp = 0L;
    private UploadSegmentUtil uploadSegmentUtil = null;
    private ISession session = null;

    UploadSegment(FileTransferManagerConfig managerConfig, ISession session, UploadSegmentUtil uploadSegmentUtil, File file, int chunk, String segContainer, String objectName, long timestamp) {
        this.managerConfig = managerConfig;
        this.uploadSegmentUtil = uploadSegmentUtil;
        this.master = file;
        this.chunkIndex = chunk;
        this.segmentsContainer = segContainer;
        this.objectName = objectName;
        this.timestamp = timestamp;
        this.session = session;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() {
        int retryCount = 0;
        boolean retry = false;
        ClientException lastError = null;
        IPutObjectReply putObjectReply = null;
        IHeadObjectReply headObjectReply = null;
        try (InputStream is = this.uploadSegmentUtil.segmentInputStreams.get(this.chunkIndex);){
            do {
                block29: {
                    retry = false;
                    try {
                        is.reset();
                        if (retryCount > 0) {
                            logger.info("Retrying segment [" + this.chunkIndex + "] upload...retry count: " + retryCount);
                            Thread.sleep((long)retryCount * 1000L);
                        }
                        String segmentName = UploadSegmentUtil.getSegmentName(this.objectName, this.timestamp, this.chunkIndex);
                        headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.ConnectTimeout)this.session.head().retry(new DefaultRetryStrategy(this.managerConfig))).container(RestApiUtils.uriEncode(this.segmentsContainer))).object(RestApiUtils.uriEncode(segmentName))).send();
                        if (!headObjectReply.isSuccessful() && !headObjectReply.getStatus().equals((Object)Status.NOT_FOUND)) {
                            lastError = RestApiUtils.convertToServiceException(headObjectReply);
                            retry = false;
                            throw lastError;
                        }
                        putObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)((IPutRequestBuilder.ConnectTimeout)this.session.put().retry(new PutRetryStrategy(this.managerConfig))).chunk(65536).header(Header.envelopeKey1.provide(null))).header(Header.envelopeKey2.provide(null))).header(Header.digestKey1.provide(null))).header(Header.digestKey2.provide(null))).container(RestApiUtils.uriEncode(this.segmentsContainer))).object(RestApiUtils.uriEncode(segmentName))).data(is).send();
                        logger.trace(putObjectReply.toString());
                        if (putObjectReply.isSuccessful()) {
                            String computedMD5 = this.uploadSegmentUtil.segmentCheckSum.get(this.chunkIndex);
                            String serverMD5 = putObjectReply.getMd5(1L, TimeUnit.MINUTES);
                            logger.trace("Segment Computed MD5: " + computedMD5);
                            logger.trace("Segment Header   MD5: " + serverMD5);
                            if (serverMD5 == null || !serverMD5.equals(computedMD5)) {
                                logger.warn("MD5 verification failed. Uploaded MD5: " + serverMD5 + ", computed MD5:" + computedMD5);
                                retry = true;
                                lastError = new Md5ChecksumFailed(this.segmentsContainer, segmentName);
                                break block29;
                            }
                            logger.info("Segment [ " + this.chunkIndex + " ] of file " + this.master.getAbsolutePath() + " uploaded successfully!");
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    catch (IOException e) {
                        logger.trace("Exception caught for uploading " + this.objectName + ". Upload will be retried. current retry count: " + retryCount + "\n" + e.getMessage());
                        retry = true;
                        lastError = new ClientException(e.getMessage(), e);
                        break block29;
                    }
                    catch (TimeoutException | RetryException e) {
                        logger.trace("Exception caught for uploading " + this.objectName + ". Upload will be retried. current retry count: " + retryCount + "\n" + e.getMessage());
                        retry = true;
                        lastError = RestApiUtils.convertRESTApiExecExceptionToServiceEx(e);
                        break block29;
                    }
                    catch (ClientException ce) {
                        lastError = ce;
                        break block29;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        logger.error("Failure uploading file: " + this.objectName + "\n" + e.getMessage());
                        retry = false;
                        lastError = new ClientException(e.getMessage(), e);
                        break block29;
                    }
                    {
                        lastError = RestApiUtils.convertToServiceException(putObjectReply);
                        retry = putObjectReply.getStatus().getStatusCode() == 403 || putObjectReply.getStatus().equals((Object)Status.INTERNAL_SERVER_ERROR) || putObjectReply.getStatus().equals((Object)Status.GATEWAY_TIMEOUT) || putObjectReply.getStatus().equals((Object)Status.REQUEST_TIMEOUT);
                    }
                }
                if (retryCount >= this.managerConfig.getMaxRestApiRetries()) {
                    retry = false;
                }
                ++retryCount;
            } while (retry);
            throw lastError;
        }
        catch (IOException e) {
            logger.error("IOException caught while uploading file: " + this.objectName + "\n" + e.getMessage());
            retry = false;
            lastError = new ClientException(e.getMessage(), e);
        }
        throw lastError;
    }
}

