/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import oracle.cloudstorage.ftm.exception.ClientException;
import oracle.cloudstorage.ftm.exception.FileSizeTooBig;
import oracle.cloudstorage.ftm.exception.SegmentSizeTooSmall;
import oracle.cloudstorage.ftm.internal.FileSegmentChecksumInfo;
import oracle.cloudstorage.ftm.internal.FileSegmentInputStream;
import oracle.cloudstorage.ftm.internal.FileUtils;
import oracle.cloudstorage.ftm.internal.Md5ChecksumUtils;
import oracle.cloudstorage.ftm.internal.SLOSegmentManifest;
import oracle.cloudstorage.ftm.internal.SLOTransferManifest;
import oracle.cloudstorage.ftm.internal.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadSegmentUtil
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public Map<Integer, FileSegmentInputStream> segmentInputStreams = new ConcurrentHashMap<Integer, FileSegmentInputStream>();
    public Map<Integer, String> segmentCheckSum = new ConcurrentHashMap<Integer, String>();
    private FileInputStream fis;
    private long segmentSize = 0L;
    private long fileSize = 0L;
    private long fileOffset = 0L;
    private int segmentIndex = 0;
    private File origFile = null;
    private String checksum = "";
    private SLOTransferManifest transferManifest = null;
    private List<SLOSegmentManifest> preExistingSLOSegmentManifests = null;
    private Map<Integer, SLOSegmentManifest> preExistingSLOSegmentManifestMap = new HashMap<Integer, SLOSegmentManifest>();

    public long getFileSize() {
        return this.fileSize;
    }

    public UploadSegmentUtil(File file, long segSize) {
        this.setupUtil(file, segSize);
    }

    private void setupUtil(File file, long segSize) {
        try {
            this.segmentSize = segSize;
            this.fileSize = file.length();
            this.origFile = file;
            if (this.fileSize > 0xA0000000000L) {
                logger.error("Files over 10995116277760 bytes not supported. File " + file.getAbsolutePath() + " size is " + this.fileSize);
                throw new FileSizeTooBig();
            }
            long segments = this.fileSize / segSize;
            if (segments > 2048L) {
                logger.error("Your specified segment size will result in more than 2048 segments which is not supported. Increase your segment size.");
                throw new SegmentSizeTooSmall(this.segmentSize, 2048L);
            }
            if (this.isSegmented()) {
                this.fis = new FileInputStream(file.getAbsolutePath());
            }
        }
        catch (FileNotFoundException e) {
            logger.error("File Not Found - " + file.getAbsolutePath());
            throw new ClientException(e.getMessage(), e);
        }
    }

    public boolean isSegmented() {
        return this.fileSize >= this.segmentSize;
    }

    public int createSegmentInputStream() throws ClientException {
        logger.trace("File Offset: " + this.fileOffset);
        while (this.fileOffset < this.fileSize) {
            long segmentInputStreamOffset = this.fileOffset;
            try {
                FileSegmentChecksumInfo segmentChecksumInfo = Md5ChecksumUtils.getFileSegmentChecksum(this.fis, this.segmentSize);
                ++this.segmentIndex;
                this.fileOffset += segmentChecksumInfo.getSegmentSize();
                this.segmentCheckSum.put(this.segmentIndex, segmentChecksumInfo.getChecksum());
                this.checksum = this.checksum + segmentChecksumInfo.getChecksum();
                if (this.preExistingSLOSegmentManifestMap.containsKey(this.segmentIndex) && this.preExistingSLOSegmentManifestMap.get(this.segmentIndex).getHash().equals(segmentChecksumInfo.getChecksum())) continue;
                logger.trace("Segment input stream created with index: " + this.segmentIndex + ", offset in file: " + segmentInputStreamOffset + ", stream size:" + segmentChecksumInfo.getSegmentSize());
                this.segmentInputStreams.put(this.segmentIndex, new FileSegmentInputStream(this.origFile, segmentInputStreamOffset, segmentChecksumInfo.getSegmentSize()));
                return this.segmentIndex;
            }
            catch (IOException e) {
                logger.error("Exception caught reading file " + e.getMessage());
                throw new ClientException(e);
            }
        }
        return -100;
    }

    public String getMetaCheckSum() {
        return Md5ChecksumUtils.getChecksum(this.checksum);
    }

    public SLOTransferManifest getTransferManifest() {
        return this.transferManifest;
    }

    public void setTransferManifest(SLOTransferManifest transferManifest) {
        this.transferManifest = transferManifest;
    }

    public List<SLOSegmentManifest> getPreExistingSLOSegmentManifests() {
        return this.preExistingSLOSegmentManifests;
    }

    public void setPreExistingSLOSegmentManifests(List<SLOSegmentManifest> preExistingSLOSegmentManifests) {
        this.preExistingSLOSegmentManifests = preExistingSLOSegmentManifests;
        for (SLOSegmentManifest ssm : preExistingSLOSegmentManifests) {
            this.preExistingSLOSegmentManifestMap.put(UploadSegmentUtil.getSegmentIndex(ssm.getObjectName()), ssm);
        }
    }

    public JsonArray getSloManifest(String objectName, String segmentsContainer, long timestamp) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (int i = 1; i <= this.segmentCheckSum.size(); ++i) {
            long bytes = this.segmentSize;
            if (i == this.segmentCheckSum.size()) {
                long segmentsSum = (long)(i - 1) * this.segmentSize;
                bytes = this.getFileSize() - segmentsSum;
            }
            String eTag = this.segmentCheckSum.get(i);
            String path = "/" + segmentsContainer + "/" + UploadSegmentUtil.getSegmentName(objectName, timestamp, i);
            JsonObjectBuilder objBuilder = Json.createObjectBuilder().add("path", path).add("etag", eTag).add("size_bytes", bytes);
            builder.add(objBuilder);
        }
        return builder.build();
    }

    public static int getSegmentIndex(String segmentName) {
        return (int)Long.parseLong(segmentName.substring(segmentName.lastIndexOf("/") + 1));
    }

    public static String getSegmentPrefix(String objectName, long timestamp) {
        return objectName + "/_segment_/" + timestamp + "/";
    }

    public static String getSegmentName(String objectName, long timestamp, int segmentIndex) {
        String normObjName = StringUtils.normalizeObjectName(objectName);
        return UploadSegmentUtil.getSegmentPrefix(normObjName, timestamp) + String.format("%08d", segmentIndex);
    }

    @Override
    public void close() throws IOException {
        if (this.fis != null) {
            this.fis.close();
        }
    }
}

