/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.ftm.model;

import java.util.Collections;
import java.util.List;
import oracle.cloudstorage.ftm.exception.ClientException;

public class DeleteObjectsResult {
    private List<String> objectsDeleted;
    private List<DeleteObjectError> deleteObjectErrors;

    public DeleteObjectsResult(List<String> objectsDeleted, List<DeleteObjectError> deleteObjectErrors) {
        this.objectsDeleted = objectsDeleted;
        this.deleteObjectErrors = deleteObjectErrors;
    }

    public List<String> getObjectsDeleted() {
        return Collections.unmodifiableList(this.objectsDeleted);
    }

    public List<DeleteObjectError> getDeleteObjectErrors() {
        return Collections.unmodifiableList(this.deleteObjectErrors);
    }

    public String toString() {
        return "DeleteObjectsResult [objectsDeleted=" + this.objectsDeleted + ", deleteObjectErrors=" + this.deleteObjectErrors + "]";
    }

    public static class DeleteObjectError {
        private String objectName;
        private ClientException exception;

        public DeleteObjectError(String objectName, ClientException exception) {
            this.objectName = objectName;
            this.exception = exception;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public ClientException getException() {
            return this.exception;
        }

        public String toString() {
            return "DeleteObjectError [objectName=" + this.objectName + ", exception=" + this.exception + "]";
        }
    }
}

