/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client;

import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.Provider;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.idcws.client.utils.ClientUtils;
import oracle.ucm.idcws.client.utils.GenericUtils;
import oracle.ucm.idcws.client.utils.LogUtils;
import oracle.ucm.idcws.client.utils.ProgramOptionsProcessor;
import oracle.ucm.idcws.generic.GenericSoapPortType;
import oracle.ucm.idcws.generic.GenericSoapService;
import oracle.ucm.idcws.generic.obj.Generic;
import oracle.ucm.idcws.generic.obj.Service;
import oracle.webservices.ClientConfig;
import oracle.webservices.ClientFactory;
import oracle.webservices.ConnectionConfig;
import oracle.webservices.ConnectionConfigBean;
import oracle.webservices.ImplType;
import oracle.webservices.WsMetaFactory;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTool {
    private ProgramOptionsProcessor m_op = null;
    private LogUtils m_logger;
    private boolean m_isSilent;
    private boolean m_isQuiet;
    private boolean m_isVerbose;
    private boolean m_isAnonymous;
    private String m_username;
    private boolean m_usernameRequired;
    private String m_password;
    private boolean m_passwordRequired;
    private boolean m_performLogout = true;
    private int m_timeout;
    private URL m_serviceWsdlUrl;
    private WebServiceFeature[] m_features;
    private boolean m_isWebLogic;
    private Map<String, Object> m_proxySettings;
    private ConnectionConfig m_connectionConfig = new ConnectionConfigBean();
    private GenericSoapService m_genericSoapService = null;
    private boolean m_proxyAuthRequired = false;
    private boolean m_proxyAuthPingFirst = false;
    private static final String HEADER_OPTION = "Tool.Header";
    private static final String HEADER2_OPTION = "Tool.Header2";
    private static final String COPYRIGHT_OPTION = "Tool.Copyright";
    private static final String ALLOW_RESTRICTIONS_OVERWRITES_OPTION = "Tool.AllowOverwrites";
    private boolean m_appendLog = false;

    public boolean setup(String[] args) {
        String url;
        String usageRequest;
        boolean terminateEarly = false;
        ProgramOptionsProcessor op = new ProgramOptionsProcessor();
        String resource = this.getToolRestrictionsOptionsResource();
        try {
            op.load(resource, false);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        boolean allowRestrictionsOverwrite = ClientUtils.getTrimmedStringBooleanValue(op.get(ALLOW_RESTRICTIONS_OVERWRITES_OPTION));
        if (!allowRestrictionsOverwrite) {
            Set<String> restrictedOptions = op.getKeys();
            op.setRestrictedOptions(restrictedOptions);
        }
        ProgramOptionsProcessor temp = new ProgramOptionsProcessor(args);
        String defaultOptionsResourceOverride = ClientUtils.getStringIfPostTrimNonEmpty(temp.get("properties", "props", "options"));
        String defaultOptionsPropertiesFileOverride = ClientUtils.getStringIfPostTrimNonEmpty(temp.get("propertiesFile"));
        if (defaultOptionsResourceOverride != null) {
            op.load(defaultOptionsResourceOverride, true);
        } else if (defaultOptionsPropertiesFileOverride != null) {
            op.load(new File(defaultOptionsPropertiesFileOverride), true);
        } else {
            try {
                op.load(this.getToolDefaultOptionsResource(), true);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        op.load(args, true);
        this.setOptionsProcessor(op);
        this.setLogger(new LogUtils());
        String versionCheck = op.get("version", "v");
        if (ClientUtils.getBooleanValue(versionCheck, false, true)) {
            this.log(this.getToolClassAndRevision());
            terminateEarly = true;
            return terminateEarly;
        }
        PrintWriter pw = null;
        String logFileName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("LOG_FILE_NAME", "logFileName", "logFile"));
        if (logFileName != null) {
            File logFile = ClientUtils.getWriteableFile(logFileName);
            this.m_appendLog = ClientUtils.getTrimmedStringBooleanValue(op.get("LOG_FILE_APPEND"));
            try {
                pw = new PrintWriter((Writer)new FileWriter(logFile, this.m_appendLog), true);
            }
            catch (IOException e) {
                throw new IllegalStateException(ClientMessages.ucmclient_log_file_write_error(logFileName).toExceptionString(), e);
            }
        }
        if (pw != null) {
            this.setLogger(new LogUtils(pw));
            if (this.m_appendLog) {
                this.log();
            }
        }
        String silentValue = op.get("silent");
        this.setSilent(ClientUtils.getBooleanValue(silentValue, false, true));
        String quietValue = op.get("quiet", "silent");
        this.setQuiet(!this.isSilent() && ClientUtils.getBooleanValue(quietValue, false, true));
        if (!this.isSilent() && !this.isQuiet()) {
            String copyright;
            String header = ClientUtils.getStringIfPostTrimNonEmpty(op.get(HEADER_OPTION));
            this.log(header != null ? header : this.getToolHeader());
            String header2 = ClientUtils.getStringIfPostTrimNonEmpty(op.get(HEADER2_OPTION));
            if (header2 != null) {
                this.log(header2);
            }
            if ((copyright = ClientUtils.getStringIfPostTrimNonEmpty(op.get(COPYRIGHT_OPTION))) != null) {
                this.log(copyright);
            }
        }
        if (ClientUtils.getBooleanValue(usageRequest = op.get("usage", "help", "h", "?"), false, true)) {
            this.log();
            this.log(this.getUsage());
            this.log();
            terminateEarly = true;
            return terminateEarly;
        }
        String connectionHelpRequest = op.get("connectionhelp", "urlhelp");
        if (ClientUtils.getBooleanValue(connectionHelpRequest, false, true)) {
            this.log();
            this.log(this.getConnectionUsage());
            this.log();
            terminateEarly = true;
            return terminateEarly;
        }
        String verboseValue = op.get("verbose", "debug");
        this.setVerbose(!this.isSilent() && !this.isQuiet() && ClientUtils.getBooleanValue(verboseValue, false, true));
        op.setSystemProperties();
        if (this.isVerbose()) {
            String httpnph;
            this.log(this.getToolClassAndRevision());
            String osn = System.getProperty("os.name");
            String osa = System.getProperty("os.arch");
            String osv = System.getProperty("os.version");
            this.log();
            this.log("OS: " + osn + " / " + osa + " / " + osv);
            String jven = System.getProperty("java.vendor");
            String jver = System.getProperty("java.version");
            String jrv = System.getProperty("java.runtime.version");
            this.log("Java: " + jven + " / " + jver + " / " + jrv);
            String jvmn = System.getProperty("java.vm.name");
            String jvmven = System.getProperty("java.vm.vendor");
            String jvmver = System.getProperty("java.vm.version");
            this.log("JVM: " + jvmn + " / " + jvmven + " / " + jvmver);
            String httph = System.getProperty("http.proxyHost");
            String httpp = System.getProperty("http.proxyPort");
            if (httph != null) {
                this.log("HTTP Proxy System Properties: " + httph + " / " + httpp);
            }
            String httpsh = System.getProperty("https.proxyHost");
            String httpsp = System.getProperty("https.proxyPort");
            if (httpsh != null) {
                this.log("HTTPS Proxy System Properties: " + httpsh + " / " + httpsp);
            }
            if ((httpnph = System.getProperty("http.nonProxyHosts")) != null) {
                this.log("HTTP Proxy Non-Proxy-Hosts System Properties: " + httpnph);
            }
        }
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_program_options_supplied().toString());
            for (String option : op.toString().split("[\\r\\n]+")) {
                this.log(option);
            }
            this.log();
        }
        if ((url = op.get("url", "connectionURL")) == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("url").toExceptionString());
        }
        if (!ClientUtils.nonEmptyPostTrim(url)) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_option_value_error("url", url).toExceptionString());
        }
        this.m_serviceWsdlUrl = this.getServiceWsdlUrl(url);
        this.m_isAnonymous = ClientUtils.getBooleanValue(op.get("guest", "anonymous"), false, true);
        this.m_usernameRequired = !this.m_isAnonymous && ClientUtils.getBooleanValue(op.get("userRequired", "usernameRequired"), true, true);
        boolean bl = this.m_passwordRequired = !this.m_isAnonymous && ClientUtils.getBooleanValue(op.get("passRequired", "passwordRequired"), true, true);
        if (this.m_isAnonymous) {
            this.m_username = "anonymous";
        } else {
            String username = op.get("username", "user");
            if (username == null && this.m_usernameRequired) {
                throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("username").toExceptionString());
            }
            if (!ClientUtils.nonEmptyPostTrim(username) && this.m_usernameRequired) {
                throw new IllegalStateException(ClientMessages.ucmclient_invalid_option_value_error("username", username).toExceptionString());
            }
            this.m_username = username;
            String password = op.get("password");
            String passwordFile = op.get("passwordFile");
            password = this.getPassword(password, passwordFile);
            if (this.m_passwordRequired && (password == null || password.length() == 0)) {
                throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("password").toExceptionString());
            }
            this.m_password = password;
        }
        String socketTimeout = op.get("timeout", "socketTimeout");
        int timeout = ClientUtils.getIntValue(socketTimeout, 300);
        this.m_timeout = timeout <= 0 ? timeout : timeout * 1000;
        String proxyHost = op.get("proxyHost", "http.proxyHost");
        if (ClientUtils.nonEmptyPostTrim(proxyHost)) {
            this.m_proxySettings = new HashMap<String, Object>(5);
            this.m_proxySettings.put("oracle.webservices.proxyHost", proxyHost);
            String proxyPort = op.get("proxyPort", "http.proxyPort");
            int port = ClientUtils.getPositiveIntValue(proxyPort, 80);
            this.m_proxySettings.put("oracle.webservices.proxyPort", String.valueOf(port));
            this.m_connectionConfig.setProxyAddress(new InetSocketAddress(proxyHost, port));
            String nonProxyHosts = op.get("nonProxyHosts", "http.nonProxyHosts");
            if (ClientUtils.nonEmptyPostTrim(nonProxyHosts)) {
                ArrayList<String> nonProxyList = new ArrayList<String>();
                for (String host : nonProxyHosts.split("\\|")) {
                    if ((host = host.trim()).length() <= 0) continue;
                    nonProxyList.add(host);
                }
                this.m_connectionConfig.setDontProxyForList(nonProxyList);
            }
            String proxyUsername = op.get("proxyUsername", "http.proxyUsername");
            String proxyPassword = op.get("proxyPassword", "http.proxyPassword");
            String proxyPasswordFile = op.get("proxyPasswordFile");
            String proxyPass = this.getPassword(proxyPassword, proxyPasswordFile);
            if (ClientUtils.nonEmpty(proxyUsername) && ClientUtils.nonEmpty(proxyPass)) {
                String proxyAuthType;
                this.m_proxyAuthRequired = true;
                this.m_proxySettings.put("oracle.webservices.proxyUsername", proxyUsername);
                this.m_connectionConfig.setProxyUsername(proxyUsername);
                this.m_proxySettings.put("oracle.webservices.proxyPassword", proxyPass);
                this.m_connectionConfig.setProxyPass(proxyPass);
                this.m_proxyAuthPingFirst = ClientUtils.getBooleanValue(op.get("proxyAuthPingFirst"), false, true);
                String proxyRealm = op.get("proxyRealm", "http.proxyRealm");
                if (proxyRealm != null) {
                    this.m_proxySettings.put("oracle.webservices.proxyAuthRealm", proxyRealm);
                    this.m_connectionConfig.setProxyRealm(proxyRealm);
                }
                if (!ClientUtils.nonEmptyPostTrim(proxyAuthType = op.get("proxyAuthType"))) {
                    proxyAuthType = "basic";
                }
                if ("basic".equalsIgnoreCase(proxyAuthType)) {
                    proxyAuthType = "basic";
                    boolean preemptiveProxyBasicAuth = ClientUtils.getBooleanValue(op.get("preemptiveProxyBasicAuth"), true, true);
                    if (preemptiveProxyBasicAuth) {
                        this.m_proxySettings.put("oracle.webservices.preemptiveBasicAuth", Boolean.TRUE);
                        this.m_connectionConfig.setProxyPreemptiveBasicAuth("true");
                    }
                }
                if ("digest".equalsIgnoreCase(proxyAuthType)) {
                    proxyAuthType = "digest";
                }
                this.m_proxySettings.put("oracle.webservices.proxyAuthType", proxyAuthType);
                this.m_connectionConfig.setProxyAuthType(proxyAuthType);
            }
        }
        ArrayList<Object> features = new ArrayList<Object>();
        String authPolicy = ClientUtils.getStringIfPostTrimNonEmpty(op.get("policy", "jaxwsPolicy", "wsPolicy"));
        if (authPolicy != null) {
            features.add(new SecurityPolicyFeature(authPolicy));
        } else if (this.m_isAnonymous) {
            features.add(new SecurityPolicyFeature("oracle/no_authentication_client_policy"));
        }
        MTOMFeature mtomFeature = new MTOMFeature();
        features.add(mtomFeature);
        String stack = ClientUtils.getStringIfPostTrimNonEmpty(op.get("stack", "jaxwsStack"));
        boolean bl2 = this.m_isWebLogic = "wl".equalsIgnoreCase(stack) || "weblogic".equalsIgnoreCase(stack);
        if (this.isVerbose()) {
            this.log("Stack: " + (this.m_isWebLogic ? "WebLogic" : "JRF"));
            this.log();
        }
        if (this.m_isWebLogic) {
            this.log("javax.xml.ws.spi.Provider: " + Provider.provider().getClass());
            String tempDir = op.get("tmp", "temp", "tmpDir", "tempDir");
            tempDir = tempDir == null ? System.getProperty("java.io.tmpdir") : tempDir;
            tempDir = tempDir == null ? "/tmp" : tempDir;
            StreamingAttachmentFeature streamingFeature = new StreamingAttachmentFeature(tempDir, true, 0x100000L);
            features.add(streamingFeature);
        }
        this.m_features = features.toArray(new WebServiceFeature[0]);
        if (!this.m_isWebLogic) {
            boolean skipOptimizations = ClientUtils.getBooleanValue(op.get("skipOptimizations"), false, true);
            if (!skipOptimizations) {
                this.setJRFStackOptimizations();
            }
            WsMetaFactory jrfWsMetaFactory = WsMetaFactory.newInstance((ImplType)ImplType.JRF);
            ClientConfig cfg = new ClientConfig();
            cfg.setServiceQName(GenericSoapService.m_serviceQName);
            cfg.setWsdlURL(this.m_serviceWsdlUrl);
            if (cfg.getProperties() == null) {
                cfg.setProperties(new HashMap());
            }
            cfg.getProperties().put("connection.config", this.m_connectionConfig);
            ClientFactory jrfClientFactory = jrfWsMetaFactory.createClientFactory(cfg);
            GenericSoapService genericSoapService = (GenericSoapService)((Object)jrfClientFactory.create(this.m_serviceWsdlUrl, GenericSoapService.m_serviceQName, GenericSoapService.class));
            this.setGenericSoapService(genericSoapService);
        } else {
            GenericSoapService genericSoapService = new GenericSoapService(this.m_serviceWsdlUrl);
            this.setGenericSoapService(genericSoapService);
        }
        return terminateEarly;
    }

    public void logout() {
    }

    private URL getServiceWsdlUrl(String url) {
        URL serviceWsdlUrl = null;
        try {
            if (url.endsWith("/idcws")) {
                url = url + "/GenericSoapPort?WSDL";
            } else if (url.endsWith("/idcws/")) {
                url = url + "GenericSoapPort?WSDL";
            } else if (url.endsWith("/idcws/GenericSoapPort")) {
                url = url + "?WSDL";
            }
            serviceWsdlUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            this.log(e);
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_option_value_error("url", url).toExceptionString());
        }
        return serviceWsdlUrl;
    }

    public void ping() throws Exception {
        GenericSoapPortType client = this.getClient();
        this.ping(client);
    }

    public void ping(GenericSoapPortType client) throws Exception {
        Generic request;
        Generic response;
        if (!this.isSilent() && !this.isQuiet()) {
            this.log(ClientMessages.ucmclient_performing_connection_test().toString());
        }
        if ((response = GenericUtils.sendGenericRequest(client, request = this.createServiceRequest("PING_SERVER"))) == null || response.getService() == null || !"PING_SERVER".equals(response.getService().getIdcService())) {
            throw new IllegalStateException(ClientMessages.ucmclient_content_server_unavailable_error().toExceptionString());
        }
        GenericUtils.throwOnResponseError(response);
        Map<String, String> responseBinder = GenericUtils.getResponseLocalData(response);
        String dUser = responseBinder.get("dUser");
        if (this.m_username != null && !this.m_username.equalsIgnoreCase(dUser)) {
            throw new IllegalStateException(ClientMessages.ucmclient_unexpected_user_error(dUser).toExceptionString());
        }
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_connection_test_response().toString());
            this.log(response);
        }
        if (!this.isSilent()) {
            this.log(ClientMessages.ucmclient_connection_test_successful().toString());
        }
    }

    private String getPassword(String password, String passwordFile) {
        if (ClientUtils.nonEmptyPostTrim(passwordFile)) {
            return ClientUtils.readPasswordFromFile(passwordFile);
        }
        return password;
    }

    public void setOptionsProcessor(ProgramOptionsProcessor processor) {
        this.m_op = processor;
    }

    public ProgramOptionsProcessor getOptionsProcessor() {
        return this.m_op;
    }

    public void setLogger(LogUtils logger) {
        this.m_logger = logger;
    }

    public LogUtils getLogger() {
        return this.m_logger;
    }

    protected void log() {
        this.getLogger().log();
    }

    protected void log(String message) {
        this.getLogger().log(message);
    }

    protected void print(String message) {
        this.getLogger().print(message);
    }

    protected void log(Exception e) {
        this.getLogger().logException(e);
    }

    protected void log(Generic g) {
        String indent = this.getLogger().getDefaultIndent();
        this.getLogger().logGeneric(g, indent);
    }

    public void setPerformLogout(boolean performLogout) {
        this.m_performLogout = performLogout;
    }

    public boolean getPerformLogout() {
        return this.m_performLogout;
    }

    public void setSilent(boolean isSilent) {
        this.m_isSilent = isSilent;
    }

    public boolean isSilent() {
        return this.m_isSilent;
    }

    public void setQuiet(boolean isQuiet) {
        this.m_isQuiet = isQuiet;
    }

    public boolean isQuiet() {
        return this.m_isQuiet;
    }

    public void setVerbose(boolean isVerbose) {
        this.m_isVerbose = isVerbose;
    }

    public boolean isVerbose() {
        return this.m_isVerbose;
    }

    public void setGenericSoapService(GenericSoapService genericSoapService) {
        this.m_genericSoapService = genericSoapService;
    }

    public GenericSoapService getGenericSoapService() {
        return this.m_genericSoapService;
    }

    public GenericSoapPortType getClient() {
        GenericSoapPortType client;
        Map requestContext = null;
        GenericSoapService genericSoapService = this.getGenericSoapService();
        if (this.m_isWebLogic) {
            client = genericSoapService.getGenericSoapPort(this.m_features);
            requestContext = ((BindingProvider)client).getRequestContext();
            requestContext.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 32768);
        } else {
            client = genericSoapService.getGenericSoapPort(this.m_features);
            requestContext = ((BindingProvider)client).getRequestContext();
            requestContext.put("oracle.webservices.httpConnTimeout", new Integer(this.m_timeout));
            requestContext.put("oracle.webservices.httpReadTimeout", new Integer(this.m_timeout));
            requestContext.put("oracle.webservices.soap.streamingOutgoing", "true");
            requestContext.put("oracle.webservices.soap.streamingIncoming", "true");
            requestContext.put("oracle.webservices.soap.streamInputDefault", "true");
            requestContext.put("oracle.webservices.soap.memoryThreshold", "100000");
            requestContext.put("oracle.webservices.soap.keepXop", "true");
            if (this.m_proxySettings != null) {
                requestContext.putAll(this.m_proxySettings);
            }
        }
        if (!this.m_isAnonymous) {
            if (this.m_usernameRequired) {
                requestContext.put("javax.xml.ws.security.auth.username", this.m_username);
            }
            if (this.m_passwordRequired) {
                requestContext.put("javax.xml.ws.security.auth.password", this.m_password);
            }
        }
        return client;
    }

    public Generic createServiceRequest(String serviceName) {
        Generic request = new Generic();
        request.setWebKey("cs");
        Service service = new Service();
        service.setIdcService(serviceName);
        request.setService(service);
        Service.Document document = new Service.Document();
        service.setDocument(document);
        GenericUtils.addRequestProperty(request, "UserDateFormat", "iso8601");
        GenericUtils.addRequestProperty(request, "UserTimeZone", "UTC");
        if (this.m_isAnonymous) {
            GenericUtils.addRequestProperty(request, "IsAllowAnonymous", "1");
        }
        return request;
    }

    public Generic sendRequest(Generic request) {
        GenericSoapPortType client;
        block3: {
            client = this.getClient();
            if (this.m_proxyAuthRequired && this.m_proxyAuthPingFirst) {
                try {
                    this.ping(client);
                }
                catch (Exception e) {
                    if (!this.isVerbose()) break block3;
                    this.log(e);
                }
            }
        }
        return GenericUtils.sendGenericRequest(client, request);
    }

    protected Map<String, String> getCustomMetadataIfPresent(ProgramOptionsProcessor op) {
        HashMap<String, String> metadata = new HashMap<String, String>(2);
        for (int i = 0; i < 10; ++i) {
            String key;
            String argkey = "k" + i;
            String argval = "v" + i;
            if (!op.containsKey(argkey) || !op.containsKey(argval) || (key = ClientUtils.getStringIfPostTrimNonEmpty(op.get(argkey))) == null) continue;
            String value = ClientUtils.getStringIfPostTrimNonEmpty(op.get(argval));
            String string = value = value == null ? "" : value;
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(" * " + ClientMessages.ucmclient_custom_metadata_added_to_request_payload(key, value).toString());
            }
            metadata.put(key, value);
        }
        return metadata;
    }

    protected void closeLog() {
        if (this.m_appendLog) {
            this.log();
            this.log("##################################################");
        }
        this.getLogger().close();
    }

    protected void setJRFStackOptimizations() {
        block8: {
            try {
                Method m;
                Class<?> configClass = Class.forName("HTTPClient.HttpClientConfiguration");
                if (configClass == null) break block8;
                try {
                    m = configClass.getDeclaredMethod("setStaleSocketCheckEnabled", Boolean.TYPE);
                    if (m != null) {
                        m.invoke(null, true);
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    m = configClass.getDeclaredMethod("setSocketIdleTime", Integer.TYPE);
                    if (m != null) {
                        m.invoke(null, 25);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected String getConnectionUsage() {
        return ClientMessages.ucmclient_connection_usage().toString();
    }

    protected abstract String getToolClassAndRevision();

    protected abstract String getToolHeader();

    protected abstract String getToolRestrictionsOptionsResource();

    protected abstract String getToolDefaultOptionsResource();

    protected abstract String getUsage();

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 128389 $";
    }
}

