/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import oracle.ucm.idcws.client.AbstractTool;
import oracle.ucm.idcws.client.DownloadTool;
import oracle.ucm.idcws.client.SearchTool;
import oracle.ucm.idcws.client.StorageTool;
import oracle.ucm.idcws.client.UploadTool;
import oracle.ucm.idcws.client.utils.ClientUtils;

public class JarEntryClass {
    public static void main(String[] args) {
        boolean debug = Boolean.parseBoolean(System.getProperty("debugtool", "false"));
        if (args != null && args.length >= 1) {
            boolean classFound = JarEntryClass.isJRFStackInClasspath();
            if (debug && classFound) {
                System.out.println("JRF class located in current class loader");
            }
            if (!classFound && ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
                URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                String customClasspath = System.getenv("CUSTOM_CLASSPATH");
                if (customClasspath != null) {
                    String[] classTokens;
                    if (debug) {
                        System.out.println("CUSTOM_CLASSPATH environment variable detected");
                    }
                    boolean isWindows = System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
                    String separator = isWindows ? ";" : ":";
                    for (String token : classTokens = customClasspath.split(separator)) {
                        if (token == null || token.length() <= 0) continue;
                        File f = new File(token);
                        if (debug) {
                            System.out.println("Attempting to add " + f + " to system class loader ...");
                        }
                        JarEntryClass.addFileToUrlClassLoader(loader, f);
                    }
                }
                classFound = JarEntryClass.isJRFStackInClasspath();
                if (debug && classFound) {
                    System.out.println("JRF class located");
                }
                if (!classFound) {
                    String mwHome = System.getenv("MW_HOME");
                    if (mwHome != null) {
                        if (debug) {
                            System.out.println("MW_HOME environment variable detected");
                        }
                        File mw = new File(mwHome);
                        File jrfclient = new File(mw, "oracle_common/modules/oracle.jrf_11.1.1/jrf-client.jar");
                        JarEntryClass.addFileToUrlClassLoader(loader, jrfclient);
                    }
                    classFound = JarEntryClass.isJRFStackInClasspath();
                    if (debug && classFound) {
                        System.out.println("JRF class located");
                    }
                }
            }
            if (!classFound) {
                System.err.println("Error: Web Service stack does not appear to be in classpath.");
                System.err.println("Call tool directly - e.g. java -classpath ... oracle.ucm.idcws.client.DownloadTool -url=...");
                if (ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
                    JarEntryClass.logLoader((URLClassLoader)ClassLoader.getSystemClassLoader());
                }
                System.exit(1);
            }
            String[] destArgs = new String[args.length - 1];
            System.arraycopy(args, 1, destArgs, 0, args.length - 1);
            if (args[0].matches("(?i:.*UPLOAD.*)")) {
                UploadTool.main(destArgs);
            } else if (args[0].matches("(?i:.*DOWNLOAD.*)")) {
                DownloadTool.main(destArgs);
            } else if (args[0].matches("(?i:.*SEARCH.*)")) {
                SearchTool.main(destArgs);
            } else if (args[0].matches("(?i:.*STORAGE.*)")) {
                StorageTool.main(destArgs);
            } else if (args[0].matches("(?i:^-version$)")) {
                JarEntryClass.version();
            } else {
                JarEntryClass.usage();
            }
        } else {
            JarEntryClass.usage();
        }
    }

    private static void version() {
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        String uploadRevision = ClientUtils.getRevision(UploadTool.idcVersionInfo(null));
        String downloadRevision = ClientUtils.getRevision(DownloadTool.idcVersionInfo(null));
        String searchRevision = ClientUtils.getRevision(SearchTool.idcVersionInfo(null));
        String storageRevision = ClientUtils.getRevision(StorageTool.idcVersionInfo(null));
        System.out.println("AbstractTool [p" + parentRevision + "]");
        System.out.println("DownloadTool [r" + downloadRevision + "]");
        System.out.println("  UploadTool [r" + uploadRevision + "]");
        System.out.println("  SearchTool [r" + searchRevision + "]");
        System.out.println(" StorageTool [r" + storageRevision + "]");
    }

    private static void usage() {
        System.out.println("Usage: java -jar oracle.ucm.fa_genericclient_11.1.1.jar UploadTool|DownloadTool options*");
    }

    private static boolean isJRFStackInClasspath() {
        boolean classFound = false;
        try {
            Class<?> c = Class.forName("oracle.webservices.ClientFactory");
            classFound = c != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classFound;
    }

    private static void addFileToUrlClassLoader(URLClassLoader loader, File file) {
        if (file != null) {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory() || file.isFile()) {
                // empty if block
            }
        }
        try {
            Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            m.setAccessible(true);
            m.invoke((Object)loader, file.toURI().toURL());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static void logLoader(URLClassLoader loader) {
        System.err.println("\nURLClassLoader entries:");
        for (URL u : loader.getURLs()) {
            System.err.println(u);
        }
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 123575 $";
    }
}

