/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client;

import java.util.Map;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.idcws.client.AbstractTool;
import oracle.ucm.idcws.client.utils.ClientUtils;
import oracle.ucm.idcws.client.utils.GenericUtils;
import oracle.ucm.idcws.client.utils.ProgramOptionsProcessor;
import oracle.ucm.idcws.client.utils.SearchUtils;
import oracle.ucm.idcws.generic.obj.Generic;
import oracle.ucm.idcws.generic.obj.ResultSet;

public class StorageTool
extends AbstractTool {
    private static final String TOOL = "Oracle WebCenter Content Storage Migration Utility";
    private static final String TOOL_RESTRICTIONS_OPTIONS_RESOURCE = "oracle/ucm/client/StorageTool.properties";
    private static final String TOOL_DEFAULT_OPTIONS_RESOURCE = "StorageTool.properties";

    public static void main(String[] args) {
        StorageTool d = new StorageTool();
        try {
            d.run(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public void run(String[] args) throws Exception {
        try {
            Generic response;
            String count;
            boolean terminateEarly = this.setup(args);
            if (terminateEarly) {
                return;
            }
            ProgramOptionsProcessor op = this.getOptionsProcessor();
            boolean ping = ClientUtils.getBooleanValue(op.get("ping", "testConnection"), false, true);
            if (ping) {
                this.ping();
                return;
            }
            String targetStorageRule = ClientUtils.getStringIfPostTrimNonEmpty(op.get("target", "targetRule", "targetStorageRule", "storageRule"));
            if (targetStorageRule == null) {
                targetStorageRule = "FusionStorageRule";
            }
            if (!this.verifyStorageRule(op, targetStorageRule)) {
                throw new Exception(ClientMessages.ucmclient_storagemigration_invalidrule(targetStorageRule).toExceptionString());
            }
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_storagemigration_goodrule(targetStorageRule).toString());
            }
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_storagemigration_searching().toString());
            }
            boolean dryRun = ClientUtils.getBooleanValue(op.get("dryRun"), true, true);
            boolean bypassReindexingAndRefinery = !ClientUtils.getBooleanValue(op.get("reindex"), false, true);
            boolean abortOnFirstFailure = ClientUtils.getBooleanValue(op.get("abortOnFirstFailure", "abortOnFailure"), false, true);
            Generic request = this.createServiceRequest("GET_SEARCH_RESULTS");
            boolean allDocs = ClientUtils.getBooleanValue(op.get("allDocs"), true, true);
            if (allDocs) {
                GenericUtils.addRequestProperty(request, "SearchEngineName", "DATABASE.METADATA.ALLDOCS");
            } else {
                String engine = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SearchEngineName", "engine"));
                if (engine != null) {
                    GenericUtils.addRequestProperty(request, "SearchEngineName", engine);
                }
            }
            String queryText = ClientUtils.getStringIfPostTrimNonEmpty(op.get("QueryText"));
            if (queryText == null) {
                queryText = StorageTool.buildQueryString(op);
                if (queryText.length() == 0) {
                    queryText = "(<NOT> (xStorageRule <matches> `" + targetStorageRule + "`))";
                }
                GenericUtils.addRequestProperty(request, "SearchQueryFormat", "UNIVERSAL");
            } else {
                String queryFormat = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SearchQueryFormat"));
                GenericUtils.addRequestProperty(request, "SearchQueryFormat", queryFormat == null ? "UNIVERSAL" : queryFormat);
            }
            GenericUtils.addRequestProperty(request, "QueryText", queryText);
            String sortSpec = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortSpec"));
            if (sortSpec == null) {
                String sortField = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortField"));
                String sortOrder = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortOrder"));
                if (sortField != null) {
                    GenericUtils.addRequestProperty(request, "SortField", sortField);
                    GenericUtils.addRequestProperty(request, "SortOrder", sortOrder == null ? "ASC" : sortOrder);
                }
            } else {
                GenericUtils.addRequestProperty(request, "SortSpec", sortSpec);
            }
            int startRow = ClientUtils.getPositiveIntValue(op.get("StartRow"), 1);
            GenericUtils.addRequestProperty(request, "StartRow", String.valueOf(startRow));
            String endRow = ClientUtils.getStringIfPostTrimNonEmpty(op.get("EndRow"));
            if (endRow != null) {
                GenericUtils.addRequestProperty(request, "EndRow", String.valueOf(ClientUtils.getPositiveIntValue(endRow, 10)));
            }
            if ((count = ClientUtils.getStringIfPostTrimNonEmpty(op.get("ResultCount"))) != null) {
                GenericUtils.addRequestProperty(request, "ResultCount", String.valueOf(ClientUtils.getPositiveIntValue(count, 10)));
            }
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                this.log(request);
            }
            long initial = System.currentTimeMillis();
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_performing_search().toString());
            }
            if ((response = this.sendRequest(request)) == null) {
                throw new IllegalStateException(ClientMessages.ucmclient_search_response_null_error().toExceptionString());
            }
            if (this.isVerbose()) {
                this.log("\n" + ClientMessages.ucmclient_content_server_response_payload().toString());
                this.log(response);
            }
            GenericUtils.throwOnResponseError(response);
            long duration = (System.currentTimeMillis() - initial) / 1000L;
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_search_stats(duration).toString());
                this.log(ClientMessages.ucmclient_search_completed().toString());
            }
            int processed = 0;
            int skipped = 0;
            int migrated = 0;
            int failed = 0;
            ResultSet resultSet = GenericUtils.getResultSet(response, "SearchResults");
            Map<String, String> responseBinder = GenericUtils.getResponseLocalData(response);
            int totalRows = ClientUtils.getIntValue(responseBinder.get("TotalRows"), -1);
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_storagemigration_searchresultcounts_batchdetails(resultSet.getRow().size(), totalRows).toString());
            }
            for (Map<String, String> dataObject : GenericUtils.getDataObjects(resultSet)) {
                Map<String, String> migrationResponseBinder;
                String storageRule;
                ++processed;
                String dID = dataObject.get("dID");
                String dDocName = dataObject.get("dDocName");
                String xStorageRule = dataObject.get("xStorageRule");
                String dDocLastModifiedDate = dataObject.get("dDocLastModifiedDate");
                if (targetStorageRule.equals(xStorageRule)) {
                    ++skipped;
                    if (this.isSilent() || this.isQuiet()) continue;
                    this.log(ClientMessages.ucmclient_storagemigration_skipped(dID).toString());
                    continue;
                }
                if (dryRun) {
                    ++migrated;
                    if (this.isSilent() || this.isQuiet()) continue;
                    this.log(ClientMessages.ucmclient_storagemigration_candidate(dID).toString());
                    continue;
                }
                if (!this.isSilent() && !this.isQuiet()) {
                    this.log(ClientMessages.ucmclient_performing_storagemigration(dID).toString());
                }
                Generic migrationBinder = this.createServiceRequest("UPDATE_DOCINFO");
                GenericUtils.addRequestProperty(migrationBinder, "dID", dID);
                GenericUtils.addRequestProperty(migrationBinder, "dDocName", dDocName);
                GenericUtils.addRequestProperty(migrationBinder, "xStorageRule", targetStorageRule);
                if (bypassReindexingAndRefinery) {
                    GenericUtils.addRequestProperty(migrationBinder, "addReleasedWebFile", "TRUE");
                }
                if (this.isVerbose()) {
                    this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                    this.log(migrationBinder);
                }
                initial = System.currentTimeMillis();
                Generic migrationResponse = this.sendRequest(migrationBinder);
                if (migrationResponse == null) {
                    throw new IllegalStateException(ClientMessages.ucmclient_storagemigration_response_null_error().toExceptionString());
                }
                if (this.isVerbose()) {
                    this.log("\n" + ClientMessages.ucmclient_content_server_response_payload().toString());
                    this.log(migrationResponse);
                }
                GenericUtils.throwOnResponseError(migrationResponse);
                duration = (System.currentTimeMillis() - initial) / 1000L;
                if (this.isVerbose()) {
                    this.log(ClientMessages.ucmclient_storagemigration_stats(dID, duration).toString());
                }
                if (targetStorageRule.equals(storageRule = (migrationResponseBinder = GenericUtils.getResponseLocalData(migrationResponse)).get("xStorageRule"))) {
                    ++migrated;
                    if (!this.isVerbose()) continue;
                    this.log(ClientMessages.ucmclient_storagemigration_successful().toString());
                    continue;
                }
                ++failed;
                if (!this.isVerbose()) continue;
                this.log(ClientMessages.ucmclient_storagemigration_failed(dID).toString());
            }
            if (dryRun) {
                this.log(ClientMessages.ucmclient_storagemigration_dryrun_result(processed, migrated, skipped).toString());
            } else {
                this.log(ClientMessages.ucmclient_storagemigration_result(processed, failed, migrated, skipped).toString());
            }
            return;
        }
        catch (Exception e) {
            this.log("\nError - " + e.getMessage());
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(e);
            }
            throw e;
        }
        finally {
            this.logout();
            this.closeLog();
        }
    }

    private boolean verifyStorageRule(ProgramOptionsProcessor op, String targetStorageRule) {
        Generic response;
        String providerName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("provider", "providerName"));
        if (providerName == null) {
            providerName = "DefaultFileStore";
        }
        Generic request = this.createServiceRequest("FS_GET_STORAGE_RULE");
        GenericUtils.addRequestProperty(request, "pName", providerName);
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        if ((response = this.sendRequest(request)) == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_response_error("FS_GET_STORAGE_RULE").toExceptionString());
        }
        if (this.isVerbose()) {
            this.log("\n" + ClientMessages.ucmclient_content_server_response_payload().toString());
            this.log(response);
        }
        GenericUtils.throwOnResponseError(response);
        boolean existingRule = false;
        ResultSet resultSet = GenericUtils.getResultSet(response, "StorageRules");
        for (Map<String, String> dataObject : GenericUtils.getDataObjects(resultSet)) {
            if (!targetStorageRule.equals(dataObject.get("StorageRule"))) continue;
            existingRule = true;
            break;
        }
        return existingRule;
    }

    private static String buildQueryString(ProgramOptionsProcessor op) {
        StringBuilder queryBuilder = new StringBuilder();
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dID");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocName");
        SearchUtils.processStringQueryParam(op, queryBuilder, "xStorageRule", "provider");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dFileSize", "size");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dDocCreatedDate", "created", "createDate");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dDocLastModifiedDate", "modified", "lastModified", "lastModifiedDate");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dInDate", "released", "releaseDate");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dSecurityGroup", "group");
        String queryText = queryBuilder.toString();
        return queryText;
    }

    protected String getToolClassAndRevision() {
        String revision = ClientUtils.getRevision(StorageTool.idcVersionInfo(null));
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        return "StorageTool" + (revision != null && revision.length() > 0 ? " [r" + revision + "]/[p" + parentRevision + "]" : "");
    }

    protected String getUsage() {
        return ClientMessages.ucmclient_storage_usage().toString();
    }

    protected String getToolHeader() {
        return TOOL;
    }

    protected String getToolRestrictionsOptionsResource() {
        return TOOL_RESTRICTIONS_OPTIONS_RESOURCE;
    }

    protected String getToolDefaultOptionsResource() {
        return TOOL_DEFAULT_OPTIONS_RESOURCE;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 128389 $";
    }
}

