/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client.bulk;

import java.util.concurrent.ThreadPoolExecutor;
import oracle.ucm.idcws.client.utils.LogUtils;

public class ExecutorMonitor
implements Runnable {
    private ThreadPoolExecutor m_executor;
    private int m_sleepSeconds;
    private boolean m_shutdown = false;
    private LogUtils m_logger;

    public ExecutorMonitor(ThreadPoolExecutor executor, int sleepSeconds, LogUtils ridcLogger) {
        this.m_executor = executor;
        this.m_sleepSeconds = sleepSeconds;
        this.m_logger = ridcLogger;
    }

    public void shutdown() {
        this.m_shutdown = true;
    }

    public boolean isShutdown() {
        return this.m_shutdown;
    }

    public void run() {
        ThreadPoolExecutor e = this.getExecutor();
        while (!this.isShutdown()) {
            this.log(String.format("Pool Size:%d,  Active Tasks:%d,  Completed Tasks:%d,  Tasks Seen:%d", e.getPoolSize(), e.getActiveCount(), e.getCompletedTaskCount(), e.getTaskCount()));
            try {
                Thread.sleep(this.m_sleepSeconds * 1000);
            }
            catch (InterruptedException ignore) {
                this.log(String.format("Pool Size:%d,  Active Tasks:%d,  Completed Tasks:%d,  Tasks Seen:%d", e.getPoolSize(), e.getActiveCount(), e.getCompletedTaskCount(), e.getTaskCount()));
            }
        }
    }

    protected ThreadPoolExecutor getExecutor() {
        return this.m_executor;
    }

    protected LogUtils getLogger() {
        return this.m_logger;
    }

    protected void log(String message) {
        this.getLogger().log("[ExecutorMonitor] " + message);
    }

    protected void logException(Exception e) {
        this.getLogger().log("[ExecutorMonitor] - Exception: " + e.getMessage());
        this.getLogger().logException(e);
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 114142 $";
    }
}

