/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client.bulk;

import java.util.Map;
import java.util.concurrent.Callable;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.idcws.client.AbstractTool;
import oracle.ucm.idcws.client.bulk.UploadException;
import oracle.ucm.idcws.client.model.content.CheckinSource;
import oracle.ucm.idcws.client.model.content.TransferFile;
import oracle.ucm.idcws.client.model.response.CheckinResponse;
import oracle.ucm.idcws.client.utils.GenericUtils;
import oracle.ucm.idcws.client.utils.LogUtils;
import oracle.ucm.idcws.generic.obj.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadThread
implements Callable<CheckinResponse> {
    private int m_taskNumber;
    private AbstractTool m_tool;
    private CheckinSource m_checkinSource;
    private Map<String, String> m_customMetadata;

    public UploadThread(int taskNumber, AbstractTool tool, CheckinSource checkinSource, Map<String, String> metadata) {
        this.m_taskNumber = taskNumber;
        this.m_tool = tool;
        this.m_checkinSource = checkinSource;
        this.m_customMetadata = metadata;
    }

    @Override
    public CheckinResponse call() throws Exception {
        CheckinResponse checkinResponse = null;
        CheckinSource source = this.getCheckinSource();
        String identifier = source.getIdentifier();
        try {
            Generic response;
            TransferFile alternate;
            Generic request = this.m_tool.createServiceRequest("CHECKIN_UNIVERSAL");
            String dDocName = source.getDDocName();
            if (dDocName != null) {
                GenericUtils.addRequestProperty(request, "dDocName", dDocName);
            }
            GenericUtils.addRequestProperty(request, "dSecurityGroup", source.getDSecurityGroup());
            GenericUtils.addRequestProperty(request, "dDocAccount", source.getDDocAccount());
            GenericUtils.addRequestProperty(request, "dDocType", source.getDDocType());
            GenericUtils.addRequestProperty(request, "dDocTitle", source.getDDocTitle());
            TransferFile primary = source.getPrimaryFile();
            GenericUtils.addPrimaryRequestFile(request, primary);
            if (source.getPrimaryFileCharacterSet() != null) {
                GenericUtils.addRequestProperty(request, "primaryFile:dCharacterSet", source.getPrimaryFileCharacterSet());
            }
            if (source.getPrimaryFileLanguage() != null) {
                GenericUtils.addRequestProperty(request, "primaryFile:dLanguage", source.getPrimaryFileLanguage());
            }
            if ((alternate = source.getAlternateFile()) != null) {
                GenericUtils.addAlternateRequestFile(request, alternate);
                if (source.getAlternateFileCharacterSet() != null) {
                    GenericUtils.addRequestProperty(request, "alternateFile:dCharacterSet", source.getAlternateFileCharacterSet());
                }
                if (source.getAlternateFileLanguage() != null) {
                    GenericUtils.addRequestProperty(request, "alternateFile:dLanguage", source.getAlternateFileLanguage());
                }
            }
            for (Map.Entry<String, String> entry : this.m_customMetadata.entrySet()) {
                GenericUtils.addRequestProperty(request, entry.getKey(), entry.getValue());
            }
            if (this.isVerbose()) {
                this.log();
                this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                this.log(request);
            }
            long initial = System.currentTimeMillis();
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_performing_upload().toString());
            }
            if ((response = this.m_tool.sendRequest(request)) == null) {
                throw new IllegalStateException(ClientMessages.ucmclient_upload_response_null_error().toExceptionString());
            }
            GenericUtils.throwOnResponseError(response);
            Map<String, String> responseBinder = GenericUtils.getResponseLocalData(response);
            String dID = responseBinder.get("dID");
            dDocName = responseBinder.get("dDocName");
            String dDocTitle = responseBinder.get("dDocTitle");
            String dOriginalName = responseBinder.get("dOriginalName");
            long dFileSize = new Long(responseBinder.get("dFileSize"));
            long duration = (System.currentTimeMillis() - initial) / 1000L;
            checkinResponse = new CheckinResponse(identifier, this.m_taskNumber, dID, dDocName, dDocTitle, dOriginalName, dFileSize, duration);
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_upload_stats(duration).toString());
                this.log();
                this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
                this.log(response);
            }
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_upload_successful().toString() + " [dID=" + dID + " | dDocName=" + dDocName + "]");
            }
        }
        catch (Exception e) {
            this.log(String.format("ERROR - \"%s\" ; Error occurred uploading primaryFile \"%s\" with dDocTitle \"%s\" and checkin identifier \"%s\".", e.getMessage(), source.getPrimaryFile().getFileName(), source.getDDocTitle(), identifier));
            if (this.m_tool.isVerbose()) {
                this.log(e);
            }
            throw new UploadException(String.format("ERROR - \"%s\" ; Error occurred for task %d uploading primaryFile \"%s\" with dDocTitle \"%s\" and checkin identifier \"%s\".", e.getMessage(), this.m_taskNumber, source.getPrimaryFile().getFileName(), source.getDDocTitle(), identifier), (Throwable)e, identifier, this.m_taskNumber);
        }
        finally {
            source.closePrimaryFile();
            source.closeAlternateFile();
            this.logout();
        }
        return checkinResponse;
    }

    protected boolean isVerbose() {
        return this.m_tool.isVerbose();
    }

    protected boolean isSilent() {
        return this.m_tool.isSilent();
    }

    protected boolean isQuiet() {
        return this.m_tool.isQuiet();
    }

    protected void logout() {
        this.m_tool.logout();
    }

    protected LogUtils getLogger() {
        return this.m_tool.getLogger();
    }

    protected void log() {
        this.getLogger().log();
    }

    protected void log(String message) {
        this.getLogger().log(Thread.currentThread().getName() + " task:" + this.m_taskNumber + " - " + message);
    }

    protected void log(Exception e) {
        this.getLogger().log(Thread.currentThread().getName() + " task:" + this.m_taskNumber + " - Exception: " + e.getMessage());
        this.getLogger().logException(e);
    }

    protected void log(Generic g) {
        this.getLogger().log(Thread.currentThread().getName() + " task:" + this.m_taskNumber + " - Binder: ");
        String indent = this.getLogger().getDefaultIndent();
        this.getLogger().logGeneric(g, indent);
    }

    protected CheckinSource getCheckinSource() {
        return this.m_checkinSource;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122373 $";
    }
}

