/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client.model.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TransferFile {
    private InputStream m_inputStream = null;
    private long m_contentLength = 0L;
    private String m_contentType = null;
    private String m_fileName = null;
    private File m_file = null;

    public TransferFile() {
    }

    public TransferFile(InputStream inputStream, String fileName, long contentLength, String contentType) {
        this.m_inputStream = inputStream;
        this.m_fileName = fileName;
        this.m_contentLength = contentLength;
        this.m_contentType = contentType;
    }

    public TransferFile(InputStream inputStream, String fileName, long contentLength) {
        this.m_inputStream = inputStream;
        this.m_fileName = fileName;
        this.m_contentLength = contentLength;
    }

    public TransferFile(File file) throws IOException {
        this(file, null);
    }

    public TransferFile(File file, String contentType) throws IOException {
        this.m_file = file;
        this.m_fileName = file.getName();
        this.m_contentLength = file.length();
        this.m_contentType = contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_inputStream == null && this.m_file != null) {
            this.m_inputStream = new FileInputStream(this.m_file);
        }
        return this.m_inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.m_inputStream = inputStream;
    }

    public String getContentType() {
        if (this.m_contentType == null) {
            this.m_contentType = "application/octet-stream";
        }
        return this.m_contentType;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public long getContentLength() {
        return this.m_contentLength;
    }

    public void setContentLength(long contentLength) {
        this.m_contentLength = contentLength;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 114142 $";
    }
}

