/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import oracle.ucm.client.i18n.ClientMessages;

public class ClientUtils {
    private static final String REVISION_PRE = "$Rev: ";
    private static final String REVISION_POST = " $";

    public static String readPasswordFromFile(String passwordFile) {
        String file = ClientUtils.getStringIfPostTrimNonEmpty(passwordFile);
        if (file == null) {
            throw new IllegalArgumentException("passwordFile value invalid '" + passwordFile + "'");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String string = br.readLine();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(ClientMessages.ucmclient_password_file_read_error(passwordFile).toExceptionString(), e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static File getReadableFile(String inputFile) {
        if ((inputFile = ClientUtils.getStringIfPostTrimNonEmpty(inputFile)) == null) {
            throw new IllegalArgumentException("'inputFile' '" + inputFile + "' is null/invalid.");
        }
        File file = new File(inputFile);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new IllegalStateException(ClientMessages.ucmclient_file_read_error(inputFile).toExceptionString());
        }
        return file;
    }

    public static File getReadableDirectory(String localDirectory) {
        if ((localDirectory = ClientUtils.getStringIfPostTrimNonEmpty(localDirectory)) == null) {
            throw new IllegalArgumentException("'localDirectory' '" + localDirectory + "' is null/invalid.");
        }
        File file = new File(localDirectory);
        if (!(file.exists() && file.isDirectory() && file.canRead())) {
            throw new IllegalStateException(ClientMessages.ucmclient_file_read_error(localDirectory).toExceptionString());
        }
        return file;
    }

    public static File[] getDirectoryFiles(String localDirectory) {
        File file = ClientUtils.getReadableDirectory(localDirectory);
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.exists() && f.isFile() && f.canRead();
            }
        };
        return file.listFiles(filter);
    }

    public static File getWriteableFile(String outputFile) {
        if ((outputFile = ClientUtils.getStringIfPostTrimNonEmpty(outputFile)) == null) {
            throw new IllegalArgumentException("'outputFile' '" + outputFile + "' is null/invalid.");
        }
        File file = new File(outputFile);
        if (!(!file.exists() || file.isFile() && file.canWrite())) {
            throw new IllegalStateException(ClientMessages.ucmclient_file_write_error(outputFile).toExceptionString());
        }
        return file;
    }

    public static boolean nonEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean nonEmptyPostTrim(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static String getStringIfPostTrimNonEmpty(String string) {
        return ClientUtils.nonEmptyPostTrim(string) ? string.trim() : null;
    }

    public static String getStringProcessed(String string, boolean trimValue, boolean emptyValid) {
        String result = null;
        if (string != null) {
            if (trimValue) {
                string = string.trim();
            }
            if (emptyValid || string.length() > 0) {
                result = string;
            }
        }
        return result;
    }

    public static boolean getTrimmedStringBooleanValue(String string) {
        return ClientUtils.nonEmptyPostTrim(string) ? Boolean.valueOf(string.trim()) : false;
    }

    public static boolean getBooleanValue(String string, boolean ifNullDefault, boolean ifTrimEmptyDefault) {
        boolean result = ifNullDefault;
        if (string != null) {
            String trimmed = string.trim();
            result = trimmed.length() == 0 ? ifTrimEmptyDefault : Boolean.valueOf(trimmed);
        }
        return result;
    }

    public static String leftPad(String s, int maxSize) {
        if (s == null) {
            s = "";
        }
        if (maxSize <= 0) {
            return s;
        }
        StringBuilder b = new StringBuilder(maxSize);
        if (s.length() <= maxSize) {
            for (int i = 0; i < maxSize - s.length(); ++i) {
                b.append(" ");
            }
            b.append(s);
        } else {
            b.append(s.substring(0, maxSize));
        }
        return b.toString();
    }

    public static String rightPad(String s, int maxSize) {
        if (s == null) {
            s = "";
        }
        if (maxSize <= 0) {
            return s;
        }
        StringBuilder b = new StringBuilder(maxSize);
        if (s.length() <= maxSize) {
            b.append(s);
            for (int i = 0; i < maxSize - s.length(); ++i) {
                b.append(" ");
            }
        } else {
            b.append(s.substring(0, maxSize));
        }
        return b.toString();
    }

    public static String asHex(byte[] hash) {
        StringBuilder buf = new StringBuilder(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(ClientUtils.byteToHex(hash[i]));
        }
        return buf.toString().toUpperCase();
    }

    public static String byteToHex(byte b) {
        return Integer.toHexString(b & 0xFF);
    }

    public static int getIntValue(String string, int defaultIntValue) {
        return ClientUtils.getIntValue(string, defaultIntValue, false);
    }

    public static int getIntValue(String string, int defaultIntValue, boolean throwIfNFE) {
        int result;
        block3: {
            result = defaultIntValue;
            String input = ClientUtils.getStringIfPostTrimNonEmpty(string);
            if (input != null) {
                try {
                    result = Integer.parseInt(input);
                }
                catch (NumberFormatException nfe) {
                    if (!throwIfNFE) break block3;
                    throw nfe;
                }
            }
        }
        return result;
    }

    public static int getPositiveIntValue(String string, int defaultIntValue) {
        int value = ClientUtils.getIntValue(string, defaultIntValue);
        return value > 0 ? value : defaultIntValue;
    }

    public static int getPositiveIntValue(String string, int defaultIntValue, boolean throwIfNFE) {
        int value = ClientUtils.getIntValue(string, defaultIntValue, throwIfNFE);
        return value > 0 ? value : defaultIntValue;
    }

    public static void streamDrain(InputStream in) {
        if (in != null) {
            try {
                int n = in.read();
                while (n >= 0) {
                    in.skip(65536L);
                    n = in.read();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void streamClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void streamClose(OutputStream out) {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String transformAccount(String account) {
        if ((account = ClientUtils.getStringIfPostTrimNonEmpty(account)) == null) {
            throw new IllegalArgumentException("'account' '" + account + "' is null/invalid.");
        }
        String transformedAccount = Pattern.compile("^/*(.*?)\\$*/*\\$*$").matcher(account).replaceFirst("$1\\$");
        transformedAccount = Pattern.compile("\\$*//*").matcher(transformedAccount).replaceAll("\\$/");
        return transformedAccount;
    }

    public static String getRevision(Object o) {
        int postIndex;
        String idcVersion;
        int preIndex;
        String revision = "";
        if (o != null && o instanceof String && (preIndex = (idcVersion = (String)o).indexOf(REVISION_PRE)) != -1 && (postIndex = idcVersion.indexOf(REVISION_POST, preIndex)) != -1) {
            revision = idcVersion.substring(preIndex + REVISION_PRE.length(), postIndex);
        }
        return revision;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 114142 $";
    }

    public static class RightpadPlus
    extends Rightpad {
        String header;

        public RightpadPlus(int size, String header) {
            super(size);
            this.header = header;
        }

        public String getHeader() {
            return this.header;
        }
    }

    public static class Rightpad
    extends Pad {
        public Rightpad(int size) {
            this.size = size;
        }
    }

    public static class LeftpadPlus
    extends Leftpad {
        String header;

        public LeftpadPlus(int size, String header) {
            super(size);
            this.header = header;
        }

        public String getHeader() {
            return this.header;
        }
    }

    public static class Leftpad
    extends Pad {
        public Leftpad(int size) {
            this.size = size;
        }
    }

    public static class Pad {
        int size;

        public int getSize() {
            return this.size;
        }
    }
}

