/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import oracle.ucm.idcws.client.model.content.TransferFile;
import oracle.ucm.idcws.generic.GenericSoapPortType;
import oracle.ucm.idcws.generic.obj.Field;
import oracle.ucm.idcws.generic.obj.File;
import oracle.ucm.idcws.generic.obj.Generic;
import oracle.ucm.idcws.generic.obj.ResultSet;
import oracle.ucm.idcws.generic.obj.Row;
import oracle.ucm.idcws.generic.obj.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericUtils {
    public static Generic sendGenericRequest(GenericSoapPortType client, Generic request) {
        return client.genericSoapOperation(request);
    }

    public static void addRequestProperty(Generic request, String name, String value) {
        List<Field> binder = request.getService().getDocument().getField();
        Field f = new Field();
        f.setName(name);
        f.setValue(value);
        binder.add(f);
    }

    public static void addPrimaryRequestFile(Generic request, TransferFile file) {
        GenericUtils.addRequestFile(request, "primaryFile", file);
    }

    public static void addAlternateRequestFile(Generic request, TransferFile file) {
        GenericUtils.addRequestFile(request, "alternateFile", file);
    }

    public static void addRequestFile(Generic request, String type, final TransferFile transferFile) {
        File file = new File();
        file.setName(type);
        file.setHref(transferFile.getFileName());
        DataHandler dh = new DataHandler(new DataSource(){

            public InputStream getInputStream() throws IOException {
                return transferFile.getInputStream();
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public String getContentType() {
                return transferFile.getContentType();
            }

            public String getName() {
                return transferFile.getFileName();
            }
        });
        file.setContents(dh);
        request.getService().getDocument().getFile().add(file);
    }

    public static void addPrimaryRequestFile(Generic request, String dOriginalName, String sourceContentFilePath) {
        GenericUtils.addRequestFile(request, "primaryFile", dOriginalName, sourceContentFilePath);
    }

    public static void addAlternateRequestFile(Generic request, String dOriginalName, String sourceContentFilePath) {
        GenericUtils.addRequestFile(request, "alternateFile", dOriginalName, sourceContentFilePath);
    }

    public static void addRequestFile(Generic request, String type, String dOriginalName, String sourceContentFilePath) {
        File file = new File();
        file.setName(type);
        file.setHref(dOriginalName);
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(sourceContentFilePath));
        file.setContents(dh);
        request.getService().getDocument().getFile().add(file);
    }

    public static Map<String, String> getResponseLocalData(Generic response) {
        List<Field> responseFields = response.getService().getDocument().getField();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Field f : responseFields) {
            result.put(f.getName(), f.getValue());
        }
        return result;
    }

    public static int getResponseCode(Generic response) {
        Map<String, String> rb = GenericUtils.getResponseLocalData(response);
        int result = -1;
        if (rb.containsKey("StatusCode")) {
            result = Integer.valueOf(rb.get("StatusCode"));
        }
        return result;
    }

    public static void throwOnResponseError(Generic response) {
        Map<String, String> rb = GenericUtils.getResponseLocalData(response);
        if (rb.containsKey("StatusCode") && Integer.valueOf(rb.get("StatusCode")) != 0) {
            throw new IllegalStateException("ServiceException: " + rb.get("StatusCode") + " - " + rb.get("StatusMessage"));
        }
    }

    public static ResultSet getResultSet(Generic response, String resultSetName) {
        ResultSet resultset = null;
        List<ResultSet> resultSets = response.getService().getDocument().getResultSet();
        for (ResultSet rs : resultSets) {
            if (!rs.getName().equals(resultSetName)) continue;
            resultset = rs;
            break;
        }
        return resultset;
    }

    public static List<Map<String, String>> getDataObjects(ResultSet rs) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Row row : rs.getRow()) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Field f : row.getField()) {
                m.put(f.getName(), f.getValue());
            }
            list.add(m);
        }
        return list;
    }

    public static List<Map<String, String>> getDataObjects(Generic response, String resultSetName) {
        ResultSet rs = GenericUtils.getResultSet(response, resultSetName);
        return GenericUtils.getDataObjects(rs);
    }

    public static Map<String, String> getDataObject(Generic response, String resultSetName, int rowIndex) {
        ResultSet rs = GenericUtils.getResultSet(response, resultSetName);
        HashMap<String, String> result = new HashMap<String, String>();
        List<Row> rows = rs.getRow();
        if (rows != null && rows.size() > rowIndex && rowIndex >= 0) {
            Row row = rows.get(rowIndex);
            List<Field> rowFields = row.getField();
            for (Field f : rowFields) {
                result.put(f.getName(), f.getValue());
            }
        }
        return result;
    }

    public static File getResponseFile0(Generic response) {
        Service s = response.getService();
        Service.Document d = s.getDocument();
        List<File> files = d.getFile();
        return files.get(0);
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122373 $";
    }
}

